/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ORecordBytesLazy;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerLiteral;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerLong;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapEntryProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;

public class OMVRBTreeMapProvider<K, V>
extends OMVRBTreeProviderAbstract<K, V> {
    private static final long serialVersionUID = 1L;
    public static final byte CURRENT_PROTOCOL_VERSION = 3;
    protected final OMemoryStream stream;
    protected OBinarySerializer<K> keySerializer;
    protected OStreamSerializer streamKeySerializer;
    protected OStreamSerializer valueSerializer;
    protected boolean keepKeysInMemory;
    protected boolean keepValuesInMemory;

    public OMVRBTreeMapProvider(OStorage iStorage, String iClusterName, ORID iRID) {
        this(iStorage, iClusterName, null, null);
        ORecordInternal.setIdentity(this.record, iRID.getClusterId(), iRID.getClusterPosition());
    }

    public OMVRBTreeMapProvider(OStorage iStorage, String iClusterName, OBinarySerializer<K> iKeySerializer, OStreamSerializer iValueSerializer) {
        super(new ORecordBytesLazy(), iStorage, iClusterName);
        ((ORecordBytesLazy)this.record).recycle(this);
        this.stream = new OMemoryStream();
        this.keySerializer = iKeySerializer;
        this.valueSerializer = iValueSerializer;
    }

    @Override
    public OMVRBTreeEntryDataProvider<K, V> getEntry(ORID iRid) {
        return new OMVRBTreeMapEntryProvider(this, iRid);
    }

    @Override
    public OMVRBTreeEntryDataProvider<K, V> createEntry() {
        return new OMVRBTreeMapEntryProvider(this);
    }

    @Override
    public OMVRBTreeProvider<K, V> copy() {
        return new OMVRBTreeMapProvider<K, V>(this.storage, this.clusterName, this.keySerializer, this.valueSerializer);
    }

    @Override
    protected void load(ODatabaseDocument iDb) {
        ((ORecordBytesLazy)this.record).recycle(this);
        super.load(iDb);
    }

    @Override
    protected void load(OStorage iSt) {
        ((ORecordBytesLazy)this.record).recycle(this);
        super.load(iSt);
    }

    @Override
    public boolean updateConfig() {
        boolean changed = super.updateConfig();
        this.keepKeysInMemory = OGlobalConfiguration.MVRBTREE_ENTRY_KEYS_IN_MEMORY.getValueAsBoolean();
        this.keepValuesInMemory = OGlobalConfiguration.MVRBTREE_ENTRY_VALUES_IN_MEMORY.getValueAsBoolean();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toStream() throws OSerializationException {
        OProfilerMBean profiler = Orient.instance().getProfiler();
        long timer = profiler.startChrono();
        try {
            this.stream.jump(0);
            this.stream.set((byte)3);
            this.stream.setAsFixed(this.root != null ? this.root.toStream() : ORecordId.EMPTY_RECORD_ID_STREAM);
            this.stream.set(this.size);
            this.stream.set(this.pageSize);
            this.stream.set(this.keySize);
            this.stream.set(this.keySerializer.getId());
            this.stream.setCustom(this.valueSerializer.getName());
            if (this.streamKeySerializer != null) {
                this.stream.setCustom(this.streamKeySerializer.getName());
            } else {
                this.stream.setCustom("");
            }
            byte[] result = this.stream.toByteArray();
            this.record.fromStream(result);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            profiler.stopChrono(profiler.getProcessMetric("mvrbtree.toStream"), "Serialize a MVRBTree", timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OProfilerMBean profiler = Orient.instance().getProfiler();
        long timer = profiler.startChrono();
        try {
            this.stream.setSource(iStream);
            byte protocolVersion = this.stream.peek();
            if (protocolVersion != -1) {
                this.stream.getAsByte();
                if (protocolVersion != 3) {
                    OLogManager.instance().debug((Object)this, "Found tree %s created with MVRBTree protocol version %d while current one supports the version %d. The tree will be migrated transparently", this.getRecord().getIdentity(), protocolVersion, (byte)3);
                }
            }
            this.root = new ORecordId();
            this.root.fromStream(this.stream.getAsByteArrayFixed(10));
            this.size = this.stream.getAsInteger();
            this.pageSize = protocolVersion == -1 ? (int)this.stream.getAsShort() : this.stream.getAsInteger();
            if (protocolVersion < 1) {
                this.keySize = 1;
                OLogManager.instance().warn((Object)this, "Previous index version was found, partial composite index queries may do not work if you do not recreate index.", new Object[0]);
            } else {
                this.keySize = this.stream.getAsInteger();
            }
            if (protocolVersion < 3) {
                this.streamKeySerializer = OStreamSerializerFactory.get(this.stream.getAsStringCustom());
                this.valueSerializer = OStreamSerializerFactory.get(this.stream.getAsStringCustom());
                this.keySerializer = this.createRelatedSerializer(this.streamKeySerializer);
            } else {
                this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(this.stream.getAsByte());
                this.valueSerializer = OStreamSerializerFactory.get(this.stream.getAsStringCustom());
                String oldKeySerializerName = this.stream.getAsStringCustom();
                if (oldKeySerializerName != null && oldKeySerializerName.length() > 0) {
                    this.streamKeySerializer = OStreamSerializerFactory.get(oldKeySerializerName);
                }
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on unmarshalling OMVRBTreeMapProvider object from record: %s", (Throwable)e, OSerializationException.class, this.root);
        }
        finally {
            profiler.stopChrono(profiler.getProcessMetric("mvrbtree.fromStream"), "Deserialize a MVRBTree", timer);
        }
        return this;
    }

    public OBinarySerializer<K> createRelatedSerializer(OStreamSerializer streamKeySerializer) {
        if (streamKeySerializer instanceof OBinarySerializer) {
            return (OBinarySerializer)((Object)streamKeySerializer);
        }
        if (streamKeySerializer instanceof OStreamSerializerLiteral) {
            return new OSimpleKeySerializer();
        }
        if (streamKeySerializer instanceof OStreamSerializerLong) {
            return OLongSerializer.INSTANCE;
        }
        throw new OSerializationException("Given serializer " + streamKeySerializer.getClass().getName() + " can not be converted into " + OBinarySerializer.class.getName() + ".");
    }

    public OBinarySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OStreamSerializer getValueSerializer() {
        return this.valueSerializer;
    }
}

