/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.orientechnologies.orient.graph.script.OScriptGraphOrientWrapper;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import javax.script.Bindings;

public class OGraphServerHandler
extends OServerPluginAbstract
implements OScriptInjection {
    private boolean enabled = true;
    private int graphPoolMax = OGlobalConfiguration.DB_POOL_MAX.getValueAsInteger();

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (!param.name.equalsIgnoreCase("graph.pool.max")) continue;
            this.graphPoolMax = Integer.parseInt(param.value);
        }
        this.enabled = true;
        OLogManager.instance().info((Object)this, "Installing GREMLIN language v.%s - graph.pool.max=%d", OGremlinHelper.getEngineVersion(), this.graphPoolMax);
        Orient.instance().getScriptManager().registerInjection(this);
    }

    @Override
    public String getName() {
        return "graph";
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        OGremlinHelper.global().setMaxGraphPool(this.graphPoolMax).create();
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        OGremlinHelper.global().destroy();
    }

    @Override
    public void bind(Bindings binding) {
        Object scriptGraph = binding.get("orient");
        if (scriptGraph == null || !(scriptGraph instanceof OScriptGraphOrientWrapper)) {
            binding.put("orient", (Object)new OScriptGraphOrientWrapper());
        }
    }

    @Override
    public void unbind(Bindings binding) {
        binding.put("orient", (Object)null);
    }

    @Override
    public void onAfterClientRequest(OClientConnection connection, byte requestType) {
        super.onAfterClientRequest(connection, requestType);
        OrientBaseGraph.clearInitStack();
    }
}

