/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLDeleteVertex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE VERTEX";
    private ORecordId rid;
    private int removed = 0;
    private ODatabaseDocument database;
    private OCommandRequest query;
    private String returning = "COUNT";
    private List<ORecord> allDeletedRecords;
    private OrientGraph graph;
    private OModifiableBoolean shutdownFlag = new OModifiableBoolean();

    public OCommandExecutorSQLDeleteVertex parse(OCommandRequest iRequest) {
        this.database = OCommandExecutorSQLDeleteVertex.getDatabase();
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword("DELETE");
        this.parserRequiredKeyword("VERTEX");
        OClass clazz = null;
        String where = null;
        String word = this.parseOptionalWord(true, new String[0]);
        while (word != null) {
            if (word.startsWith("#")) {
                this.rid = new ORecordId(word);
            } else if (word.equalsIgnoreCase("from")) {
                StringBuilder q = new StringBuilder();
                int newPos = OStringSerializerHelper.getEmbedded(this.parserText, this.parserGetCurrentPosition(), -1, q);
                this.query = this.database.command(new OSQLAsynchQuery(q.toString(), this));
                this.parserSetCurrentPosition(newPos);
            } else {
                if (word.equals("WHERE")) {
                    if (clazz == null) {
                        clazz = ((OMetadataInternal)this.database.getMetadata()).getImmutableSchemaSnapshot().getClass("V");
                    }
                    where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetPreviousPosition()) : "";
                    this.query = this.database.command(new OSQLAsynchQuery("select from " + clazz.getName() + where, this));
                    break;
                }
                if (word.equals("LIMIT")) {
                    word = this.parseOptionalWord(true, new String[0]);
                    try {
                        this.limit = Integer.parseInt(word);
                    }
                    catch (Exception e) {
                        throw new OCommandSQLParsingException("Invalid LIMIT: " + word);
                    }
                } else if (word.length() > 0 && (clazz = ((OMetadataInternal)this.database.getMetadata()).getImmutableSchemaSnapshot().getClass(word)) == null) {
                    throw new OCommandSQLParsingException("Class '" + word + "' was not found");
                }
            }
            word = this.parseOptionalWord(true, new String[0]);
            if (!this.parserIsEnded()) continue;
        }
        where = where == null ? "" : " WHERE " + where;
        if (this.query == null && this.rid == null) {
            StringBuilder queryString = new StringBuilder();
            queryString.append("select from ");
            if (clazz == null) {
                queryString.append("V");
            } else {
                queryString.append(clazz.getName());
            }
            queryString.append(where);
            if (this.limit > -1) {
                queryString.append(" LIMIT " + this.limit);
            }
            this.query = this.database.command(new OSQLAsynchQuery(queryString.toString(), this));
        }
        return this;
    }

    @Override
    public Object execute(final Map<Object, Object> iArgs) {
        if (this.rid == null && this.query == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.rid != null) {
            OGraphCommandExecutorSQLFactory.runInTx(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                @Override
                public Object call(OrientBaseGraph graph) {
                    OrientVertex v = graph.getVertex(OCommandExecutorSQLDeleteVertex.this.rid);
                    if (v != null) {
                        v.remove();
                        OCommandExecutorSQLDeleteVertex.this.removed = 1;
                    }
                    return null;
                }
            });
        } else if (this.query != null) {
            this.graph = OGraphCommandExecutorSQLFactory.getGraph(false, this.shutdownFlag);
            OGraphCommandExecutorSQLFactory.runInTx(this.graph, new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                @Override
                public Object call(OrientBaseGraph graph) {
                    return OCommandExecutorSQLDeleteVertex.this.query.execute(iArgs);
                }
            });
        } else {
            throw new OCommandExecutionException("Invalid target");
        }
        return this.removed;
    }

    @Override
    public boolean result(Object iRecord) {
        OrientVertex v;
        OIdentifiable id = (OIdentifiable)iRecord;
        if (id.getIdentity().isValid() && (v = this.graph.getVertex(id)) != null) {
            v.remove();
            ++this.removed;
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "DELETE VERTEX <rid>|<class>|FROM <query> [WHERE <conditions>] [LIMIT <max-records>]>";
    }

    @Override
    public void end() {
        if (this.graph != null && this.shutdownFlag.getValue()) {
            this.graph.shutdown(false, false);
        }
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return this.query != null && !OCommandExecutorSQLDeleteVertex.getDatabase().getTransaction().isActive() ? OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE : OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }
}

