/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLMoveVertex
extends OCommandExecutorSQLSetAware
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "MOVE VERTEX";
    private static final String KEYWORD_MERGE = "MERGE";
    private String source = null;
    private String clusterName;
    private String className;
    private OClass clazz;
    private LinkedHashMap<String, Object> fields;
    private ODocument merge;

    public OCommandExecutorSQLMoveVertex parse(OCommandRequest iRequest) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLMoveVertex.getDatabase();
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword("MOVE");
        this.parserRequiredKeyword("VERTEX");
        this.source = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
        if (this.source == null) {
            throw new OCommandSQLParsingException("Cannot find source");
        }
        this.parserRequiredKeyword("TO");
        String temp = this.parseOptionalWord(true, new String[0]);
        while (temp != null) {
            if (temp.startsWith("CLUSTER:")) {
                if (this.className != null) {
                    throw new OCommandSQLParsingException("Cannot define multiple sources. Found both cluster and class.");
                }
                this.clusterName = temp.substring("CLUSTER:".length());
                if (database.getClusterIdByName(this.clusterName) == -1) {
                    throw new OCommandSQLParsingException("Cluster '" + this.clusterName + "' was not found");
                }
            } else if (temp.startsWith("CLASS:")) {
                if (this.clusterName != null) {
                    throw new OCommandSQLParsingException("Cannot define multiple sources. Found both cluster and class.");
                }
                this.className = temp.substring("CLASS:".length());
                this.clazz = database.getMetadata().getSchema().getClass(this.className);
                if (this.clazz == null) {
                    throw new OCommandSQLParsingException("Class '" + this.className + "' was not found");
                }
            } else if (temp.equals("SET")) {
                this.fields = new LinkedHashMap();
                this.parseSetFields(this.clazz, this.fields);
            } else if (temp.equals(KEYWORD_MERGE)) {
                this.merge = this.parseJSON();
            }
            temp = this.parserOptionalWord(true);
            if (!this.parserIsEnded()) continue;
            break;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null && this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OModifiableBoolean shutdownGraph = new OModifiableBoolean();
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(true, shutdownGraph);
        try {
            Set<OIdentifiable> sourceRIDs = OSQLEngine.getInstance().parseRIDTarget(graph.getRawGraph(), this.source, this.context, iArgs);
            ArrayList<ODocument> result = new ArrayList<ODocument>(sourceRIDs.size());
            for (OIdentifiable from : sourceRIDs) {
                OrientVertex fromVertex = graph.getVertex(from);
                if (fromVertex == null) continue;
                ORID oldVertex = fromVertex.getIdentity().copy();
                ORID newVertex = fromVertex.moveTo(this.className, this.clusterName);
                ODocument newVertexDoc = (ODocument)newVertex.getRecord();
                if (this.fields != null) {
                    for (Map.Entry<String, Object> f : this.fields.entrySet()) {
                        if (!(f.getValue() instanceof OSQLFunctionRuntime)) continue;
                        this.fields.put(f.getKey(), ((OSQLFunctionRuntime)f.getValue()).getValue((OIdentifiable)newVertex.getRecord(), null, this.context));
                    }
                    OSQLHelper.bindParameters(newVertexDoc, this.fields, new OCommandParameters(iArgs), this.context);
                }
                if (this.merge != null) {
                    newVertexDoc.merge(this.merge, true, false);
                }
                newVertexDoc.save();
                result.add(new ODocument().field("old", oldVertex, OType.LINK).field("new", newVertex, OType.LINK));
            }
            ArrayList<ODocument> arrayList = result;
            return arrayList;
        }
        finally {
            if (shutdownGraph.getValue()) {
                graph.shutdown(false);
            }
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public String getSyntax() {
        return "MOVE VERTEX <source> TO <destination> [SET [<field>=<value>]* [,]] [MERGE <JSON>]";
    }
}

