/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.fetch;

import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.db.OObjectLazySet;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyList;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyMap;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazySet;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerList;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerMap;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerSet;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OObjectFetchContext
implements OFetchContext {
    protected final String fetchPlan;
    protected final boolean lazyLoading;
    protected final OEntityManager entityManager;
    protected final OUserObject2RecordHandler obj2RecHandler;

    public OObjectFetchContext(String iFetchPlan, boolean iLazyLoading, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler) {
        this.fetchPlan = iFetchPlan;
        this.lazyLoading = iLazyLoading;
        this.obj2RecHandler = iObj2RecHandler;
        this.entityManager = iEntityManager;
    }

    @Override
    public void onBeforeMap(ODocument iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
        Map map = (Map)iRootRecord.field(iFieldName);
        HashMap target = null;
        Field f = OObjectEntitySerializer.getField(iFieldName, iUserObject.getClass());
        boolean customSerialization = OObjectEntitySerializer.isSerializedType(f);
        Class<Enum> genericType = OReflectionHelper.getGenericMultivalueType(f);
        target = map instanceof ORecordLazyMap || map instanceof OTrackedMap && !OReflectionHelper.isJavaType(genericType) && !customSerialization && !genericType.isEnum() ? new OObjectLazyMap(iUserObject, (OTrackedMap)map, OObjectEntitySerializer.isCascadeDeleteField(iUserObject.getClass(), f.getName())) : (customSerialization ? new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), iRootRecord, map) : (genericType.isEnum() ? new OObjectEnumLazyMap(genericType, iRootRecord, map) : new HashMap()));
        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
    }

    @Override
    public void onBeforeArray(ODocument iRootRecord, String iFieldName, Object iUserObject, OIdentifiable[] iArray) throws OFetchException {
        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, Array.newInstance(iRootRecord.getSchemaClass().getProperty(iFieldName).getLinkedClass().getJavaClass(), iArray.length));
    }

    @Override
    public void onAfterDocument(ODocument iRootRecord, ODocument iDocument, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onBeforeDocument(ODocument iRecord, ODocument iDocument, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onAfterArray(ODocument iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onAfterMap(ODocument iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    public void onBeforeDocument(ODocument iRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    public void onAfterDocument(ODocument iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onBeforeCollection(ODocument iRootRecord, String iFieldName, Object iUserObject, Iterable<?> iterable) throws OFetchException {
        if (iterable instanceof ORidBag) {
            throw new IllegalStateException(OType.LINKBAG.name() + " can not be directly mapped to any Java collection.");
        }
        Field f = OObjectEntitySerializer.getField(iFieldName, iUserObject.getClass());
        boolean customSerialization = OObjectEntitySerializer.isSerializedType(f);
        Class<Enum> genericType = OReflectionHelper.getGenericMultivalueType(f);
        Object target = iterable instanceof ORecordLazyList || iterable instanceof OTrackedList && !OReflectionHelper.isJavaType(genericType) && !customSerialization && !genericType.isEnum() ? new OObjectLazyList(iUserObject, (List)iterable, OObjectEntitySerializer.isCascadeDeleteField(iUserObject.getClass(), f.getName())) : (iterable instanceof ORecordLazySet || iterable instanceof OMVRBTreeRIDSet || iterable instanceof OTrackedSet && !OReflectionHelper.isJavaType(genericType) && !customSerialization && !genericType.isEnum() ? new OObjectLazySet(iUserObject, (Set)iterable, OObjectEntitySerializer.isCascadeDeleteField(iUserObject.getClass(), f.getName())) : (customSerialization ? (iterable instanceof List ? new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), iRootRecord, (List)iterable) : new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), iRootRecord, (Set)iterable)) : (genericType.isEnum() ? (iterable instanceof List ? new OObjectEnumLazyList(genericType, iRootRecord, (List)iterable) : new OObjectEnumLazySet(genericType, iRootRecord, (Set)iterable)) : (iterable instanceof List ? new ArrayList() : new HashSet()))));
        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
    }

    @Override
    public void onAfterCollection(ODocument iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onAfterFetch(ODocument iRootRecord) throws OFetchException {
    }

    @Override
    public void onBeforeFetch(ODocument iRootRecord) throws OFetchException {
    }

    @Override
    public void onBeforeStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
    }

    @Override
    public void onAfterStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
    }

    public OUserObject2RecordHandler getObj2RecHandler() {
        return this.obj2RecHandler;
    }

    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    @Override
    public boolean fetchEmbeddedDocuments() {
        return true;
    }
}

