/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import java.util.Date;

@Deprecated
public class ODefaultReplicationConflictResolver
implements OReplicationConflictResolver {
    private static final String DISTRIBUTED_CONFLICT_CLASS = "ODistributedConflict";
    private static final String FIELD_RECORD = "record";
    private static final String FIELD_NODE = "node";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_OTHER_RID = "otherRID";
    private static final String FIELD_CURRENT_VERSION = "currentVersion";
    private static final String FIELD_OTHER_VERSION = "otherVersion";
    private static final int MAX_RETRIES = 10;
    private boolean ignoreIfSameContent;
    private boolean ignoreIfMergeOk;
    private boolean latestAlwaysWin;
    private ODatabase<?> database;
    private OIndex<?> index = null;
    private OServer serverInstance;
    private ODistributedServerManager cluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(OServer iServer, ODistributedServerManager iCluster, String iDatabaseName) {
        this.serverInstance = iServer;
        this.cluster = iCluster;
        ODefaultReplicationConflictResolver oDefaultReplicationConflictResolver = this;
        synchronized (oDefaultReplicationConflictResolver) {
            if (this.index != null) {
                return;
            }
            OServerUserConfiguration replicatorUser = this.serverInstance.getUser("replicator");
            ODatabaseDocumentInternal threadDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
            this.database = threadDb != null && !threadDb.isClosed() && threadDb.getStorage().getName().equals(iDatabaseName) ? threadDb : this.serverInstance.openDatabase("document", iDatabaseName, replicatorUser.name, replicatorUser.password);
            if (this.database.getMetadata() != null) {
                OClass cls = this.database.getMetadata().getSchema().getClass(DISTRIBUTED_CONFLICT_CLASS);
                if (cls == null) {
                    cls = this.database.getMetadata().getSchema().createClass(DISTRIBUTED_CONFLICT_CLASS);
                    this.index = cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE);
                } else {
                    OProperty p = cls.getProperty(FIELD_RECORD);
                    this.index = p == null ? cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE) : p.getIndex();
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            this.database.close();
        }
        if (this.index != null) {
            this.index = null;
        }
    }

    @Override
    public void handleCreateConflict(String iRemoteNode, ORecordId iCurrentRID, int iCurrentVersion, ORecordId iOtherRID, int iOtherVersion) {
        if (iCurrentRID.equals(iOtherRID)) {
            for (int retry = 0; retry < 10; ++retry) {
                ODistributedServerLog.debug((Object)this, this.cluster.getLocalNodeName(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Resolved conflict automatically between versions on CREATE record %s/%s v.%d (other RID=%s v.%d). Current record version will be overwritten", this.database.getName(), iCurrentRID, iCurrentVersion, iOtherRID, iOtherVersion);
                Object record = iCurrentRID.getRecord();
                ORecordInternal.setVersion(record, iOtherVersion - 1);
                record.setDirty();
                try {
                    record.save();
                    return;
                }
                catch (OConcurrentModificationException e) {
                    continue;
                }
            }
        }
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeName(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on CREATE record %s/%s v.%d (other RID=%s v.%d)...", this.database.getName(), iCurrentRID, iCurrentVersion, iOtherRID, iOtherVersion);
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)3, iCurrentRID, iRemoteNode);
            try {
                doc.field(FIELD_OTHER_RID, iOtherRID);
                doc.save();
            }
            catch (Exception e) {
                this.errorOnWriteConflict(iRemoteNode, doc);
            }
        }
    }

    @Override
    public void handleUpdateConflict(String iRemoteNode, ORecordId iCurrentRID, ORecordVersion iCurrentVersion, ORecordVersion iOtherVersion) {
        int otherVersionNumber = iOtherVersion == null ? -1 : iOtherVersion.getCounter();
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeName(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on UDPATE record %s/%s (current=v%d, other=v%d)...", this.database.getName(), iCurrentRID, iCurrentVersion.getCounter(), otherVersionNumber);
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)1, iCurrentRID, iRemoteNode);
            try {
                doc.field(FIELD_CURRENT_VERSION, iCurrentVersion.getCounter());
                doc.field(FIELD_OTHER_VERSION, otherVersionNumber);
                doc.save();
            }
            catch (Exception e) {
                this.errorOnWriteConflict(iRemoteNode, doc);
            }
        }
    }

    @Override
    public void handleDeleteConflict(String iRemoteNode, ORecordId iCurrentRID) {
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeName(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on DELETE record %s/%s (cannot be deleted on other node)", this.database.getName(), iCurrentRID);
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)2, iCurrentRID, iRemoteNode);
            try {
                doc.save();
            }
            catch (Exception e) {
                this.errorOnWriteConflict(iRemoteNode, doc);
            }
        }
    }

    @Override
    public void handleCommandConflict(String iRemoteNode, Object iCommand, Object iLocalResult, Object iRemoteResult) {
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeName(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on COMMAND execution on db '%s', cmd='%s' result local=%s, remote=%s", this.database.getName(), iCommand, iLocalResult, iRemoteResult);
    }

    @Override
    public ODocument getAllConflicts() {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.database);
        Object entries = this.database.query(new OSQLSynchQuery("select from ODistributedConflict"), new Object[0]);
        ODocument result = new ODocument().field("result", entries);
        for (int i = 0; i < entries.size(); ++i) {
            ODocument record = (ODocument)((OIdentifiable)entries.get(i)).getRecord();
            record.setClassName(null);
            ODocumentInternal.addOwner(record, result);
            record.getIdentity().reset();
            Byte operation = (Byte)record.field(FIELD_OPERATION);
            record.field(FIELD_OPERATION, ORecordOperation.getName(operation.byteValue()));
            entries.set(i, (ODocument)record);
        }
        return result;
    }

    @Override
    public ODocument reset() {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.database);
        int deleted = (Integer)this.database.command(new OSQLSynchQuery("delete from ODistributedConflict")).execute(new Object[0]);
        return new ODocument().field("result", deleted);
    }

    @Override
    public boolean existConflictsForRecord(ORecordId iRID) {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.database);
        if (this.index == null) {
            ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Index against %s is not available right now, searches will be slower", DISTRIBUTED_CONFLICT_CLASS);
            Object result = this.database.query(new OSQLSynchQuery("select from ODistributedConflict where record = " + iRID.toString()), new Object[0]);
            return !result.isEmpty();
        }
        if (this.index.contains(iRID)) {
            ODistributedServerLog.info((Object)this, this.cluster.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Conflict already present for record %s, skip it", iRID);
            return true;
        }
        return false;
    }

    protected ODocument createConflictDocument(byte iOperation, ORecordId iRid, String iServerNode) {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.database);
        ODocument doc = new ODocument(DISTRIBUTED_CONFLICT_CLASS);
        doc.field(FIELD_OPERATION, iOperation);
        doc.field(FIELD_DATE, new Date());
        doc.field(FIELD_RECORD, iRid);
        doc.field(FIELD_NODE, iServerNode);
        return doc;
    }

    protected void errorOnWriteConflict(String iRemoteNode, ODocument doc) {
        ODistributedServerLog.error((Object)this, this.cluster.getLocalNodeName(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Error on saving CONFLICT for record %s/%s...", this.database.getName(), doc);
    }
}

