/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OCreateRecordTask
extends OAbstractRecordReplicatedTask {
    public static final String SUFFIX_QUEUE_NAME = ".insert";
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;
    protected int clusterId = -1;
    private transient ORecord record;

    public OCreateRecordTask() {
    }

    public OCreateRecordTask(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType) {
        super(iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OCreateRecordTask(ORecord record) {
        this((ORecordId)record.getIdentity(), record.toStream(), record.getRecordVersion(), ORecordInternal.getRecordType(record));
        if (this.rid.getClusterId() == -1) {
            OClass clazz;
            if (record instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)record)) != null) {
                this.clusterId = clazz.getClusterSelection().getCluster(clazz, (ODocument)record);
            } else {
                ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
                this.clusterId = db.getDefaultClusterId();
            }
        }
    }

    @Override
    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
            ORecordInternal.fill(this.record, this.rid, this.version, this.content, true);
        }
        return this.record;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "creating record %s/%s v.%s...", database.getName(), this.rid.toString(), this.version.toString());
        this.getRecord();
        if (ORecordId.isPersistent(this.rid.getClusterPosition())) {
            ORecordInternal.setIdentity(this.record, this.rid.getClusterId(), -1L);
        }
        if (this.clusterId > -1) {
            this.record.save(database.getClusterNameById(this.clusterId), true);
        } else if (this.rid.getClusterId() != -1) {
            this.record.save(database.getClusterNameById(this.rid.getClusterId()), true);
        } else {
            this.record.save();
        }
        this.rid = (ORecordId)this.record.getIdentity();
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> assigned new rid %s/%s v.%d", database.getName(), this.rid.toString(), this.record.getVersion());
        return new OPlaceholder(this.record);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public ODeleteRecordTask getFixTask(ODistributedRequest iRequest, OAbstractRemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse) {
        if (iBadResponse instanceof Throwable) {
            return null;
        }
        OPlaceholder badResult = (OPlaceholder)iBadResponse;
        return new ODeleteRecordTask(new ORecordId(badResult.getIdentity()), badResult.getRecordVersion()).setDelayed(false);
    }

    @Override
    public ODeleteRecordTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        if (iBadResponse instanceof Throwable) {
            return null;
        }
        OPlaceholder badResult = (OPlaceholder)iBadResponse;
        return new ODeleteRecordTask(new ORecordId(badResult.getIdentity()), badResult.getRecordVersion()).setDelayed(false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.content == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.content.length);
            out.write(this.content);
        }
        out.write(this.recordType);
        out.writeInt(this.clusterId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int contentSize = in.readInt();
        if (contentSize == 0) {
            this.content = null;
        } else {
            this.content = new byte[contentSize];
            in.readFully(this.content);
        }
        this.recordType = in.readByte();
        this.clusterId = in.readInt();
    }

    @Override
    public String getName() {
        return "record_create";
    }
}

