/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class ODeployDatabaseTask
extends OAbstractReplicatedTask {
    public static final int CHUNK_MAX_SIZE = 0x400000;
    public static final String DEPLOYDB = "deploydb.";
    protected final ODocument databaseConfiguration = new ODocument();
    protected long random;

    public ODeployDatabaseTask() {
    }

    public ODeployDatabaseTask(ODatabaseDocumentTx db) {
        this.random = UUID.randomUUID().getLeastSignificantBits();
        if (db != null) {
            OStorageAbstract stg = (OStorageAbstract)db.getStorage().getUnderlying();
            ODocument clusters = new ODocument();
            this.databaseConfiguration.field("clusters", clusters);
            for (String clName : stg.getClusterNames()) {
                OCluster c = stg.getClusterByName(clName);
                ODocument cluster = new ODocument();
                clusters.field(clName, cluster);
                try {
                    cluster.field("records", c.getEntries());
                    cluster.field("first", c.getFirstPosition());
                    cluster.field("last", c.getFirstPosition());
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Error on deploying cluster " + clName, (Throwable)e, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OServer iServer, final ODistributedServerManager iManager, final ODatabaseDocumentTx database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            final String databaseName = database.getName();
            Lock lock = iManager.getLock(databaseName);
            if (lock.tryLock()) {
                try {
                    Long lastDeployment = (Long)iManager.getConfigurationMap().get(DEPLOYDB + databaseName);
                    if (lastDeployment != null && lastDeployment == this.random) {
                        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database '%s' because already executed", databaseName);
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    iManager.getConfigurationMap().put(DEPLOYDB + databaseName, this.random);
                    iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                    iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                    ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploying database %s...", databaseName);
                    final AtomicLong lastOperationId = new AtomicLong(-1L);
                    File backupFile = ((ODistributedStorage)database.getStorage()).getLastValidBackup();
                    if (backupFile == null || !backupFile.exists()) {
                        backupFile = new File(Orient.getTempPath() + "/backup_" + database.getName() + ".zip");
                        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "creating backup of database '%s' in directory: %s...", databaseName, backupFile.getAbsolutePath());
                        if (backupFile.exists()) {
                            backupFile.delete();
                        } else {
                            backupFile.getParentFile().mkdirs();
                        }
                        backupFile.createNewFile();
                        final FileOutputStream fileOutputStream = new FileOutputStream(backupFile);
                        final File completedFile = new File(backupFile.getAbsolutePath() + ".completed");
                        if (completedFile.exists()) {
                            completedFile.delete();
                        }
                        new Thread(new Runnable(){

                            /*
                             * Loose catch block
                             */
                            @Override
                            public void run() {
                                block16: {
                                    Thread.currentThread().setName("OrientDB SyncDatabase node=" + iManager.getLocalNodeName() + " db=" + databaseName);
                                    database.backup(fileOutputStream, null, new Callable<Object>(){

                                        @Override
                                        public Object call() throws Exception {
                                            lastOperationId.set(database.getStorage().getLastOperationId());
                                            return null;
                                        }
                                    }, new OCommandOutputListener(){

                                        @Override
                                        public void onMessage(String iText) {
                                            if (iText.startsWith("\n")) {
                                                iText = iText.substring(1);
                                            }
                                            OLogManager.instance().info((Object)this, iText, new Object[0]);
                                        }
                                    }, OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger(), 0x400000);
                                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), ODeployDatabaseTask.this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "backup of database '%s' completed. lastOperationId=%d...", databaseName, lastOperationId.get());
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    try {
                                        completedFile.createNewFile();
                                    }
                                    catch (IOException e) {
                                        OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e, completedFile);
                                    }
                                    break block16;
                                    catch (IOException e) {
                                        try {
                                            OLogManager.instance().error((Object)this, "Cannot execute backup of database %s for deploy database", (Throwable)e, databaseName);
                                        }
                                        catch (Throwable throwable) {
                                            try {
                                                fileOutputStream.close();
                                            }
                                            catch (IOException e2) {
                                                // empty catch block
                                            }
                                            try {
                                                completedFile.createNewFile();
                                            }
                                            catch (IOException e3) {
                                                OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e3, completedFile);
                                            }
                                            throw throwable;
                                        }
                                        try {
                                            fileOutputStream.close();
                                        }
                                        catch (IOException e4) {
                                            // empty catch block
                                        }
                                        try {
                                            completedFile.createNewFile();
                                        }
                                        catch (IOException e5) {
                                            OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e5, completedFile);
                                        }
                                    }
                                }
                            }
                        }).start();
                        ((ODistributedStorage)database.getStorage()).setLastValidBackup(backupFile);
                    } else {
                        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "reusing last backup of database '%s' in directory: %s...", databaseName, backupFile.getAbsolutePath());
                    }
                    while (lastOperationId.get() < 0L) {
                        Thread.sleep(100L);
                    }
                    ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(lastOperationId.get(), backupFile, 0L, 0x400000);
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s...", 1, 0, OFileUtils.getSizeAsNumber(chunk.buffer.length));
                    if (chunk.last) {
                        iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                    }
                    ODistributedDatabaseChunk oDistributedDatabaseChunk = chunk;
                    return oDistributedDatabaseChunk;
                }
                finally {
                    lock.unlock();
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploy database task completed", new Object[0]);
                }
            }
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database %s because another node is doing it", databaseName);
        } else {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database from the same node", new Object[0]);
        }
        return Boolean.FALSE;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public boolean isRequireNodeOnline() {
        return true;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getName() {
        return "deploy_db";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.random);
        byte[] buffer = this.databaseConfiguration.toStream();
        out.writeInt(buffer.length);
        out.write(buffer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.random = in.readLong();
        int bufferLength = in.readInt();
        byte[] buffer = new byte[bufferLength];
        in.read(buffer);
        this.databaseConfiguration.fromStream(buffer);
    }

    @Override
    public boolean isRequiredOpenDatabase() {
        return true;
    }
}

