/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.security.OSecurityNull;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.io.File;
import java.io.FileOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

public class OAutomaticBackup
extends OServerPluginAbstract {
    private Date firstTime = null;
    private long delay = -1L;
    private int bufferSize = 0x100000;
    private int compressionLevel = 9;
    private String targetDirectory = "backup";
    private String targetFileName;
    private Set<String> includeDatabases = new HashSet<String>();
    private Set<String> excludeDatabases = new HashSet<String>();
    private OServer serverInstance;

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        File filePath;
        this.serverInstance = iServer;
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (param.name.equalsIgnoreCase("delay")) {
                this.delay = OIOUtils.getTimeAsMillisecs(param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("firsttime")) {
                try {
                    this.firstTime = OIOUtils.getTodayWithTime(param.value);
                    if (!this.firstTime.before(new Date())) continue;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.firstTime);
                    cal.add(5, 1);
                    this.firstTime = cal.getTime();
                    continue;
                }
                catch (ParseException e) {
                    throw new OConfigurationException("Parameter 'firstTime' has invalid format, expected: HH:mm:ss", e);
                }
            }
            if (param.name.equalsIgnoreCase("target.directory")) {
                this.targetDirectory = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase("db.include") && param.value.trim().length() > 0) {
                for (String db : param.value.split(",")) {
                    this.includeDatabases.add(db);
                }
                continue;
            }
            if (param.name.equalsIgnoreCase("db.exclude") && param.value.trim().length() > 0) {
                for (String db : param.value.split(",")) {
                    this.excludeDatabases.add(db);
                }
                continue;
            }
            if (param.name.equalsIgnoreCase("target.fileName")) {
                this.targetFileName = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase("buffer")) {
                this.bufferSize = Integer.parseInt(param.value);
                continue;
            }
            if (!param.name.equalsIgnoreCase("compressionLevel")) continue;
            this.compressionLevel = Integer.parseInt(param.value);
        }
        if (this.delay <= 0L) {
            throw new OConfigurationException("Cannot find mandatory parameter 'delay'");
        }
        if (!this.targetDirectory.endsWith("/")) {
            this.targetDirectory = this.targetDirectory + "/";
        }
        if ((filePath = new File(this.targetDirectory)).exists()) {
            if (!filePath.isDirectory()) {
                throw new OConfigurationException("Parameter 'path' points to a file, not a directory");
            }
        } else {
            filePath.mkdirs();
        }
        OLogManager.instance().info((Object)this, "Automatic backup plugin installed and active: delay=%dms, firstTime=%s, targetDirectory=%s", this.delay, this.firstTime, this.targetDirectory);
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OLogManager.instance().info((Object)this, "[OAutomaticBackup] Scanning databases to backup...", new Object[0]);
                int ok = 0;
                int errors = 0;
                Map<String, String> databaseNames = OAutomaticBackup.this.serverInstance.getAvailableStorageNames();
                for (final Map.Entry<String, String> dbName : databaseNames.entrySet()) {
                    boolean include = OAutomaticBackup.this.includeDatabases.size() > 0 ? OAutomaticBackup.this.includeDatabases.contains(dbName.getKey()) : true;
                    if (OAutomaticBackup.this.excludeDatabases.contains(dbName.getKey())) {
                        include = false;
                    }
                    if (!include) continue;
                    String fileName = (String)OVariableParser.resolveVariables(OAutomaticBackup.this.targetFileName, "${", "}", new OVariableParserListener(){

                        @Override
                        public String resolve(String iVariable) {
                            if (iVariable.equalsIgnoreCase(VARIABLES.DBNAME.toString())) {
                                return (String)dbName.getKey();
                            }
                            if (iVariable.startsWith(VARIABLES.DATE.toString())) {
                                return new SimpleDateFormat(iVariable.substring(VARIABLES.DATE.toString().length() + 1)).format(new Date());
                            }
                            throw new IllegalArgumentException("Variable '" + iVariable + "' wasn't found");
                        }
                    });
                    String exportFilePath = OAutomaticBackup.this.targetDirectory + fileName;
                    ODatabaseDocumentTx db = null;
                    try {
                        db = new ODatabaseDocumentTx(dbName.getValue());
                        db.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityNull.class);
                        db.open("admin", "aaa");
                        long begin = System.currentTimeMillis();
                        db.backup(new FileOutputStream(exportFilePath), null, null, new OCommandOutputListener(){

                            @Override
                            public void onMessage(String iText) {
                                OLogManager.instance().info((Object)this, iText, new Object[0]);
                            }
                        }, OAutomaticBackup.this.compressionLevel, OAutomaticBackup.this.bufferSize);
                        OLogManager.instance().info((Object)this, "[OAutomaticBackup] - Backup of database '" + dbName.getValue() + "' completed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
                        ++ok;
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "[OAutomaticBackup] - Error on exporting database '" + dbName.getValue() + "' to file: " + exportFilePath, (Throwable)e, new Object[0]);
                        ++errors;
                    }
                    finally {
                        if (db == null) continue;
                        db.close();
                    }
                }
                OLogManager.instance().info((Object)this, "[OAutomaticBackup] Backup finished: %d ok, %d errors", ok, errors);
            }
        };
        if (this.firstTime == null) {
            Orient.instance().scheduleTask(timerTask, this.delay, this.delay);
        } else {
            Orient.instance().scheduleTask(timerTask, this.firstTime, this.delay);
        }
    }

    @Override
    public String getName() {
        return "automaticBackup";
    }

    public static enum VARIABLES {
        DBNAME,
        DATE;

    }
}

