/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.Date;

public class OServerCommandGetFileDownload
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|fileDownload/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String fileName;
        ODatabaseDocumentTx db = this.getProfiledDatabaseInstance(iRequest);
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: fileDownload/<database>/rid/[/<fileName>][/<fileType>].");
        String string = fileName = urlParts.length > 3 ? this.encodeResponseText(urlParts[3]) : "unknown";
        String fileType = urlParts.length > 5 ? this.encodeResponseText(urlParts[4]) + '/' + this.encodeResponseText(urlParts[5]) : (urlParts.length > 4 ? this.encodeResponseText(urlParts[4]) : "");
        String rid = urlParts[2];
        iRequest.data.commandInfo = "Download";
        iRequest.data.commandDetail = rid;
        try {
            ORecordAbstract response = (ORecordAbstract)db.load(new ORecordId(rid));
            if (response != null) {
                if (response instanceof ORecordBytes) {
                    this.sendORecordBinaryFileContent(iRequest, iResponse, 200, "OK", fileType, (ORecordBytes)response, fileName);
                } else if (response instanceof ODocument) {
                    for (OProperty prop : ODocumentInternal.getImmutableSchemaClass((ODocument)response).properties()) {
                        if (!prop.getType().equals((Object)OType.BINARY)) continue;
                        this.sendBinaryFieldFileContent(iRequest, iResponse, 200, "OK", fileType, (byte[])((ODocument)response).field(prop.getName()), fileName);
                    }
                } else {
                    iResponse.send(405, "Record requested is not a file nor has a readable schema", "text/plain", "Record requested is not a file nor has a readable schema", null);
                }
            } else {
                iResponse.send(405, "Record requested not exists", "text/plain", "Record requestes not exists", null);
            }
        }
        catch (Exception e) {
            iResponse.send(500, "Internal Server Error", "text/plain", e.getMessage(), null);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    protected void sendORecordBinaryFileContent(OHttpRequest iRequest, OHttpResponse iResponse, int iCode, String iReason, String iContentType, ORecordBytes record, String iFileName) throws IOException {
        iResponse.writeStatus(iCode, iReason);
        iResponse.writeHeaders(iContentType);
        iResponse.writeLine("Content-Disposition: attachment; filename=" + iFileName);
        iResponse.writeLine("Date: " + new Date());
        iResponse.writeLine("Content-Length: " + record.getSize());
        iResponse.writeLine(null);
        record.toOutputStream(iResponse.getOutputStream());
        iResponse.flush();
    }

    protected void sendBinaryFieldFileContent(OHttpRequest iRequest, OHttpResponse iResponse, int iCode, String iReason, String iContentType, byte[] record, String iFileName) throws IOException {
        iResponse.writeStatus(iCode, iReason);
        iResponse.writeHeaders(iContentType);
        iResponse.writeLine("Content-Disposition: attachment; filename=" + iFileName);
        iResponse.writeLine("Date: " + new Date());
        iResponse.writeLine("Content-Length: " + record.length);
        iResponse.writeLine(null);
        iResponse.getOutputStream().write(record);
        iResponse.flush();
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private String encodeResponseText(String iText) {
        iText = new String(iText.replaceAll(" ", "%20"));
        iText = new String(iText.replaceAll("&", "%26"));
        return iText;
    }
}

