/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient.asynch;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedVertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.impls.orient.asynch.OrientEdgeFuture;
import com.tinkerpop.blueprints.impls.orient.asynch.OrientVertexFuture;
import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public class OrientGraphAsynch
implements OrientExtendedGraph {
    private final Features FEATURES = new Features();
    private final String url;
    private final String userName;
    private final String userPassword;
    private OrientGraphFactory factory;
    private ConcurrentLinkedHashMap<Object, OrientVertex> vertexCache;
    private int maxPoolSize = 32;
    private int maxRetries = 16;
    private boolean transactional = false;
    private AtomicLong operationStarted = new AtomicLong();
    private AtomicLong operationCompleted = new AtomicLong();
    private String keyFieldName;
    private AtomicLong reusedCachedVertex = new AtomicLong();
    private AtomicLong indexUniqueException = new AtomicLong();
    private AtomicLong concurrentException = new AtomicLong();
    private AtomicLong unknownException = new AtomicLong();
    private AtomicLong verticesCreated = new AtomicLong();
    private AtomicLong edgesCreated = new AtomicLong();
    private AtomicLong verticesLoaded = new AtomicLong();
    private AtomicLong verticesRemoved = new AtomicLong();
    private AtomicLong verticesReloaded = new AtomicLong();
    private PrintStream outStats = null;
    private ORecordConflictStrategy conflictStrategy = null;

    public OrientGraphAsynch(String url) {
        this.url = url;
        this.userName = "admin";
        this.userPassword = "admin";
    }

    public OrientGraphAsynch(String url, String userName, String userPassword) {
        this.url = url;
        this.userName = userName;
        this.userPassword = userPassword;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }

    public void setKeyFieldName(String keyFieldName) {
        this.keyFieldName = keyFieldName;
    }

    public PrintStream getOutStats() {
        return this.outStats;
    }

    public void setOutStats(PrintStream outStats) {
        this.outStats = outStats;
    }

    public OrientGraphAsynch setCache(long iElements) {
        this.init();
        this.vertexCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(iElements).build();
        this.factory.setKeepInMemoryReferences(true);
        return this;
    }

    public Vertex addOrUpdateVertex(final Object id, final Object ... prop) {
        this.beginAsynchOperation();
        return new OrientVertexFuture(Orient.instance().submit(new Callable<OrientVertex>(){

            @Override
            public OrientVertex call() throws Exception {
                int retry2;
                OrientBaseGraph g = OrientGraphAsynch.this.acquire();
                try {
                    OrientVertex v = (OrientVertex)OrientGraphAsynch.this.getVertex(id);
                    if (v != null) {
                        retry2 = 0;
                        while (true) {
                            MERGE_RESULT result = OrientGraphAsynch.this.mergeAndSaveRecord(retry2, v.getRecord(), prop);
                            switch (result) {
                                case MERGED: {
                                    OrientVertex orientVertex = v;
                                    return orientVertex;
                                }
                                case ERROR: {
                                    throw new ORecordDuplicatedException("Cannot create a new vertices", v.getIdentity());
                                }
                                case RETRY: {
                                    if (retry2 <= OrientGraphAsynch.this.maxRetries) break;
                                }
                            }
                            ++retry2;
                        }
                    }
                    v = g.addVertex(id, prop);
                    OrientGraphAsynch.this.verticesCreated.incrementAndGet();
                    OrientVertex retry2 = v;
                    return retry2;
                }
                catch (ORecordDuplicatedException e) {
                    System.out.printf("\n*** Vertex already exists key=%d, v=%s", id, e.getRid());
                    retry2 = 0;
                    while (true) {
                        OrientGraphAsynch.this.indexUniqueException.incrementAndGet();
                        if (OLogManager.instance().isDebugEnabled()) {
                            OLogManager.instance().debug((Object)this, "Vertex %s already created, merge it and retry again (retry=%d/%d)", id, retry2, OrientGraphAsynch.this.maxRetries);
                        }
                        ODocument existent = (ODocument)e.getRid().getRecord();
                        MERGE_RESULT result = OrientGraphAsynch.this.mergeAndSaveRecord(retry2, existent, prop);
                        switch (result) {
                            case MERGED: {
                                OrientVertex v;
                                OrientVertex orientVertex = v = (OrientVertex)OrientGraphAsynch.this.getVertex(existent);
                                return orientVertex;
                            }
                            case RETRY: {
                                break;
                            }
                            case ERROR: {
                                throw e;
                            }
                        }
                        ++retry2;
                    }
                }
                finally {
                    g.shutdown();
                    OrientGraphAsynch.this.endAsynchOperation();
                }
            }
        }));
    }

    @Override
    public Vertex addVertex(final Object id, final Object ... prop) {
        this.beginAsynchOperation();
        return new OrientVertexFuture(Orient.instance().submit(new Callable<OrientVertex>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OrientVertex call() throws Exception {
                OrientBaseGraph g = OrientGraphAsynch.this.acquire();
                try {
                    OrientVertex v = g.addVertex(id, prop);
                    OrientGraphAsynch.this.verticesCreated.incrementAndGet();
                    OrientVertex orientVertex = v;
                    return orientVertex;
                }
                finally {
                    g.shutdown();
                    OrientGraphAsynch.this.endAsynchOperation();
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrientVertex getOrAddVertex(Object id) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertex v = this.getFromCache(id);
            if (v != null) {
                OrientVertex orientVertex = v;
                return orientVertex;
            }
            v = g.addVertex(id);
            this.verticesCreated.incrementAndGet();
            OrientVertex orientVertex = v;
            return orientVertex;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public Vertex addVertex(final Object id) {
        this.beginAsynchOperation();
        return new OrientVertexFuture(Orient.instance().submit(new Callable<OrientVertex>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OrientVertex call() throws Exception {
                OrientBaseGraph g = OrientGraphAsynch.this.acquire();
                try {
                    OrientVertex v = g.addVertex(id);
                    OrientGraphAsynch.this.verticesCreated.incrementAndGet();
                    OrientVertex orientVertex = v;
                    return orientVertex;
                }
                finally {
                    g.shutdown();
                    OrientGraphAsynch.this.endAsynchOperation();
                }
            }
        }));
    }

    @Override
    public void declareIntent(OIntent iIntent) {
        this.init();
        this.factory.declareIntent(iIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vertex getVertex(Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof OrientVertex) {
            return (Vertex)id;
        }
        this.init();
        if (id instanceof OIdentifiable) {
            return new OrientVertex(null, (OIdentifiable)id);
        }
        OrientVertex v = this.getFromCache(id);
        if (v != null) {
            return v;
        }
        OrientBaseGraph g = this.acquire();
        try {
            v = (OrientVertex)g.getVertexByKey(this.keyFieldName, id);
            if (v != null) {
                this.verticesLoaded.incrementAndGet();
            }
            OrientVertex orientVertex = v;
            return orientVertex;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public void removeVertex(final Vertex vertex) {
        this.beginAsynchOperation();
        Orient.instance().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OrientBaseGraph g = OrientGraphAsynch.this.acquire();
                try {
                    Object field;
                    if (OrientGraphAsynch.this.vertexCache != null && (field = vertex.getProperty(OrientGraphAsynch.this.keyFieldName)) != null) {
                        OrientGraphAsynch.this.vertexCache.remove(field);
                    }
                    g.removeVertex(vertex);
                    OrientGraphAsynch.this.verticesRemoved.incrementAndGet();
                }
                finally {
                    g.shutdown();
                    OrientGraphAsynch.this.endAsynchOperation();
                }
                return null;
            }
        });
    }

    @Override
    public Iterable<Vertex> getVertices() {
        OrientBaseGraph g = this.acquire();
        try {
            Iterable<Vertex> iterable = g.getVertices();
            return iterable;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        OrientBaseGraph g = this.acquire();
        try {
            Iterable<Vertex> iterable = g.getVertices(key, value);
            return iterable;
        }
        finally {
            g.shutdown();
        }
    }

    public Edge addEdgeByVerticesKeys(final Object iOutVertex, final Object iInVertex, final String iEdgeLabel) {
        this.beginAsynchOperation();
        return new OrientEdgeFuture(Orient.instance().submit(new Callable<OrientEdge>(){

            /*
             * Exception decompiling
             */
            @Override
            public OrientEdge call() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }));
    }

    @Override
    public Edge addEdge(final Object id, final Vertex outVertex, final Vertex inVertex, final String label) {
        this.beginAsynchOperation();
        return new OrientEdgeFuture(Orient.instance().submit(new Callable<OrientEdge>(){

            /*
             * Exception decompiling
             */
            @Override
            public OrientEdge call() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Object id) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientEdge orientEdge = g.getEdge(id);
            return orientEdge;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public void removeEdge(final Edge edge) {
        this.beginAsynchOperation();
        Orient.instance().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OrientBaseGraph g = OrientGraphAsynch.this.acquire();
                try {
                    g.removeEdge(edge);
                }
                finally {
                    g.shutdown();
                    OrientGraphAsynch.this.endAsynchOperation();
                }
                return null;
            }
        });
    }

    @Override
    public Iterable<Edge> getEdges() {
        OrientBaseGraph g = this.acquire();
        try {
            Iterable<Edge> iterable = g.getEdges();
            return iterable;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        OrientBaseGraph g = this.acquire();
        try {
            Iterable<Edge> iterable = g.getEdges(key, value);
            return iterable;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public void drop() {
        OrientBaseGraph g = this.acquire();
        try {
            g.drop();
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientVertex addTemporaryVertex(String iClassName, Object ... prop) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertex orientVertex = g.addTemporaryVertex(iClassName, prop);
            return orientVertex;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public OrientVertexType getVertexBaseType() {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertexType orientVertexType = g.getVertexBaseType();
            return orientVertexType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientVertexType getVertexType(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertexType orientVertexType = g.getVertexType(iClassName);
            return orientVertexType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientVertexType createVertexType(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertexType orientVertexType = g.createVertexType(iClassName);
            return orientVertexType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientVertexType createVertexType(String iClassName, String iSuperClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertexType orientVertexType = g.createVertexType(iClassName, iSuperClassName);
            return orientVertexType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientVertexType createVertexType(String iClassName, OClass iSuperClass) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientVertexType orientVertexType = g.createVertexType(iClassName, iSuperClass);
            return orientVertexType;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public void dropVertexType(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            g.dropVertexType(iClassName);
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public OrientEdgeType getEdgeBaseType() {
        OrientBaseGraph g = this.acquire();
        try {
            OrientEdgeType orientEdgeType = g.getEdgeBaseType();
            return orientEdgeType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientEdgeType getEdgeType(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientEdgeType orientEdgeType = g.getEdgeType(iClassName);
            return orientEdgeType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientEdgeType createEdgeType(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientEdgeType orientEdgeType = g.createEdgeType(iClassName);
            return orientEdgeType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientEdgeType createEdgeType(String iClassName, String iSuperClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientEdgeType orientEdgeType = g.createEdgeType(iClassName, iSuperClassName);
            return orientEdgeType;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientEdgeType createEdgeType(String iClassName, OClass iSuperClass) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientEdgeType orientEdgeType = g.createEdgeType(iClassName, iSuperClass);
            return orientEdgeType;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public void dropEdgeType(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            g.dropEdgeType(iClassName);
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientElement detach(OrientElement iElement) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientElement orientElement = g.detach(iElement);
            return orientElement;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientElement attach(OrientElement iElement) {
        OrientBaseGraph g = this.acquire();
        try {
            OrientElement orientElement = g.attach(iElement);
            return orientElement;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public GraphQuery query() {
        throw new UnsupportedOperationException("query");
    }

    @Override
    public OTraverse traverse() {
        throw new UnsupportedOperationException("traverse");
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        throw new UnsupportedOperationException("command");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AtomicLong atomicLong = this.operationCompleted;
        synchronized (atomicLong) {
            while (this.operationStarted.get() > this.operationCompleted.get()) {
                try {
                    this.operationCompleted.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
        }
        if (this.vertexCache != null) {
            this.vertexCache.clear();
        }
        this.dumpStats();
        this.factory.close();
    }

    @Override
    public Features getFeatures() {
        return this.FEATURES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        OrientBaseGraph g = this.acquire();
        try {
            Index<T> index = g.createIndex(indexName, indexClass, indexParameters);
            return index;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        OrientBaseGraph g = this.acquire();
        try {
            Index<T> index = g.getIndex(indexName, indexClass);
            return index;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        OrientBaseGraph g = this.acquire();
        try {
            Iterable<Index<? extends Element>> iterable = g.getIndices();
            return iterable;
        }
        finally {
            g.shutdown();
        }
    }

    @Override
    public void dropIndex(String indexName) {
        OrientBaseGraph g = this.acquire();
        try {
            g.dropIndex(indexName);
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        OrientBaseGraph g = this.acquire();
        try {
            g.dropKeyIndex(key, elementClass);
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        OrientBaseGraph g = this.acquire();
        try {
            g.createKeyIndex(key, elementClass, indexParameters);
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        OrientBaseGraph g = this.acquire();
        try {
            Set<String> set = g.getIndexedKeys(elementClass);
            return set;
        }
        finally {
            g.shutdown();
        }
    }

    public OrientBaseGraph acquire() {
        OStorage stg;
        this.init();
        OrientBaseGraph g = this.transactional ? this.factory.getTx() : this.factory.getNoTx();
        if (this.conflictStrategy != null && (stg = g.getRawGraph().getStorage().getUnderlying()) instanceof OAbstractPaginatedStorage) {
            stg.setConflictStrategy(this.conflictStrategy);
        }
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandRequest command(OCommandSQL iCommand) {
        OrientBaseGraph g = this.acquire();
        try {
            OCommandRequest oCommandRequest = g.command(iCommand);
            return oCommandRequest;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countVertices() {
        OrientBaseGraph g = this.acquire();
        try {
            long l = g.countVertices();
            return l;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countVertices(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            long l = g.countVertices(iClassName);
            return l;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countEdges() {
        OrientBaseGraph g = this.acquire();
        try {
            long l = g.countEdges();
            return l;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countEdges(String iClassName) {
        OrientBaseGraph g = this.acquire();
        try {
            long l = g.countEdges(iClassName);
            return l;
        }
        finally {
            g.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V execute(OCallable<V, OrientBaseGraph> iCallable) {
        OrientBaseGraph graph = this.acquire();
        try {
            V v = iCallable.call(graph);
            return v;
        }
        finally {
            graph.shutdown();
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    @Override
    public ODatabaseDocumentTx getRawGraph() {
        throw new UnsupportedOperationException("getRawGraph");
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.conflictStrategy;
    }

    @Override
    public OrientGraphAsynch setConflictStrategy(String iStrategyName) {
        this.conflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName);
        return this;
    }

    @Override
    public OrientGraphAsynch setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.conflictStrategy = iResolver;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.factory == null) {
            OrientGraphAsynch orientGraphAsynch = this;
            synchronized (orientGraphAsynch) {
                if (this.factory == null) {
                    this.factory = new OrientGraphFactory(this.url, this.userName, this.userPassword).setupPool(1, this.maxPoolSize);
                }
            }
        }
    }

    protected MERGE_RESULT mergeAndSaveRecord(int retry, ODocument existent, Object[] prop) throws InterruptedException {
        if (this.mergeRecords(existent, prop)) {
            try {
                existent.save();
            }
            catch (ONeedRetryException ex) {
                this.concurrentException.incrementAndGet();
                if (retry < this.maxRetries) {
                    this.verticesReloaded.incrementAndGet();
                    existent.reload(null, true);
                    return MERGE_RESULT.RETRY;
                }
                return MERGE_RESULT.ERROR;
            }
        }
        return MERGE_RESULT.MERGED;
    }

    protected void reloadVertices(OrientExtendedVertex vOut, OrientExtendedVertex vIn, String iLabel, int retry, OException e) {
        if (retry < this.maxRetries) {
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Conflict on addEdge(%s,%s,%s), retrying (retry=%d/%d). Cause: %s. Thread: %d);", (Throwable)e, vOut, vIn, iLabel, retry, this.maxRetries, e, Thread.currentThread().getId());
            }
            if (e instanceof OConcurrentModificationException) {
                if (((OConcurrentModificationException)e).getRid().equals(vOut.getIdentity())) {
                    vOut.reload();
                } else {
                    vIn.reload();
                }
                this.verticesReloaded.incrementAndGet();
            } else {
                if (!vOut.getRecord().getIdentity().isNew()) {
                    vOut.reload();
                    this.verticesReloaded.incrementAndGet();
                }
                if (!vIn.getRecord().getIdentity().isNew()) {
                    vIn.reload();
                    this.verticesReloaded.incrementAndGet();
                }
            }
        } else {
            throw e;
        }
    }

    protected void dumpStats() {
        if (this.outStats == null) {
            return;
        }
        this.outStats.printf("\n---------------------------------", new Object[0]);
        this.outStats.printf("\nOrientGraphAsynch stats", new Object[0]);
        this.outStats.printf("\n---------------------------------", new Object[0]);
        this.outStats.printf("\npool instances used.: %d", this.factory.getAvailableInstancesInPool());
        this.outStats.printf("\nverticesCreated.....: %d", this.verticesCreated.get());
        this.outStats.printf("\nedgesCreated........: %d", this.edgesCreated.get());
        this.outStats.printf("\nverticesRemoved.....: %d", this.verticesRemoved.get());
        this.outStats.printf("\nverticesLoaded......: %d", this.verticesLoaded.get());
        this.outStats.printf("\nverticesReloaded....: %d", this.verticesReloaded.get());
        this.outStats.printf("\nreusedCachedVertex..: %d", this.reusedCachedVertex.get());
        this.outStats.printf("\nindexUniqueException: %d", this.indexUniqueException.get());
        this.outStats.printf("\nconcurrentException.: %d", this.concurrentException.get());
        this.outStats.printf("\nunknownException....: %d", this.unknownException.get());
        this.outStats.println("\n");
        this.verticesCreated.set(0L);
        this.edgesCreated.set(0L);
        this.verticesLoaded.set(0L);
        this.reusedCachedVertex.set(0L);
        this.indexUniqueException.set(0L);
        this.concurrentException.set(0L);
        this.unknownException.set(0L);
    }

    protected boolean mergeRecords(ODocument iSource, Object[] prop) throws InterruptedException {
        boolean modified = false;
        for (int i = 0; i < prop.length; i += 2) {
            String pName = prop[i].toString();
            Object pValue = prop[i + 1];
            Object fieldValue = iSource.field(pName);
            if (fieldValue != null && fieldValue.equals(pValue)) continue;
            iSource.field(pName, fieldValue);
            modified = true;
        }
        return modified;
    }

    protected OrientVertex getFromCache(Object id) {
        OrientVertex v;
        if (this.vertexCache != null && (v = this.vertexCache.remove(id)) != null) {
            this.reusedCachedVertex.incrementAndGet();
            return v;
        }
        return null;
    }

    protected void addInCache(Object id, OrientVertex v) {
        if (this.vertexCache != null && id != null && v != null) {
            if (v.getRecord().getIdentity().isNew()) {
                v.getRecord().setDirty();
                v.save();
            }
            if (!v.getRecord().getIdentity().isPersistent()) {
                OLogManager.instance().warn((Object)this, "Cannot put a non persistent object in cache, key=%s, vertex=%s", id, v);
            }
            this.vertexCache.put(id, v);
        }
    }

    protected void beginAsynchOperation() {
        this.init();
        this.operationStarted.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endAsynchOperation() {
        this.operationCompleted.incrementAndGet();
        AtomicLong atomicLong = this.operationCompleted;
        synchronized (atomicLong) {
            this.operationCompleted.notifyAll();
        }
    }

    protected void config() {
        this.FEATURES.supportsDuplicateEdges = true;
        this.FEATURES.supportsSelfLoops = true;
        this.FEATURES.isPersistent = true;
        this.FEATURES.supportsVertexIteration = true;
        this.FEATURES.supportsVertexIndex = true;
        this.FEATURES.ignoresSuppliedIds = true;
        this.FEATURES.supportsTransactions = false;
        this.FEATURES.supportsVertexKeyIndex = true;
        this.FEATURES.supportsKeyIndices = true;
        this.FEATURES.isWrapper = false;
        this.FEATURES.supportsIndices = true;
        this.FEATURES.supportsVertexProperties = true;
        this.FEATURES.supportsEdgeProperties = true;
        this.FEATURES.supportsSerializableObjectProperty = true;
        this.FEATURES.supportsBooleanProperty = true;
        this.FEATURES.supportsDoubleProperty = true;
        this.FEATURES.supportsFloatProperty = true;
        this.FEATURES.supportsIntegerProperty = true;
        this.FEATURES.supportsPrimitiveArrayProperty = true;
        this.FEATURES.supportsUniformListProperty = true;
        this.FEATURES.supportsMixedListProperty = true;
        this.FEATURES.supportsLongProperty = true;
        this.FEATURES.supportsMapProperty = true;
        this.FEATURES.supportsStringProperty = true;
        this.FEATURES.supportsThreadedTransactions = false;
        this.FEATURES.supportsThreadIsolatedTransactions = false;
    }

    static /* synthetic */ AtomicLong access$600(OrientGraphAsynch x0) {
        return x0.edgesCreated;
    }

    static /* synthetic */ AtomicLong access$700(OrientGraphAsynch x0) {
        return x0.concurrentException;
    }

    static /* synthetic */ AtomicLong access$800(OrientGraphAsynch x0) {
        return x0.unknownException;
    }

    protected static enum MERGE_RESULT {
        MERGED,
        RETRY,
        ERROR;

    }
}

