/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.partition;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionEdge;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionGraph;
import java.util.Iterator;
import java.util.NoSuchElementException;

class PartitionEdgeIterable
implements CloseableIterable<Edge> {
    private final Iterable<Edge> iterable;
    private final PartitionGraph graph;

    public PartitionEdgeIterable(Iterable<Edge> iterable, PartitionGraph graph) {
        this.iterable = iterable;
        this.graph = graph;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new Iterator<Edge>(){
            private Iterator<Edge> itty;
            private PartitionEdge nextEdge;
            {
                this.itty = PartitionEdgeIterable.this.iterable.iterator();
            }

            @Override
            public void remove() {
                this.itty.remove();
            }

            @Override
            public boolean hasNext() {
                if (null != this.nextEdge) {
                    return true;
                }
                while (this.itty.hasNext()) {
                    Edge edge = this.itty.next();
                    if (!PartitionEdgeIterable.this.graph.isInPartition(edge)) continue;
                    this.nextEdge = new PartitionEdge(edge, PartitionEdgeIterable.this.graph);
                    return true;
                }
                return false;
            }

            @Override
            public Edge next() {
                if (null != this.nextEdge) {
                    PartitionEdge temp = this.nextEdge;
                    this.nextEdge = null;
                    return temp;
                }
                while (this.itty.hasNext()) {
                    Edge edge = this.itty.next();
                    if (!PartitionEdgeIterable.this.graph.isInPartition(edge)) continue;
                    return new PartitionEdge(edge, PartitionEdgeIterable.this.graph);
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void close() {
        if (this.iterable instanceof CloseableIterable) {
            ((CloseableIterable)this.iterable).close();
        }
    }
}

