/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OStorageRemoteAsynchEventListener
implements ORemoteServerEventListener {
    private Map<Integer, OLiveResultListener> liveQueryListeners = new ConcurrentHashMap<Integer, OLiveResultListener>();
    private OStorageRemote storage;

    public OStorageRemoteAsynchEventListener(OStorageRemote storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(byte iRequestCode, Object obj) {
        if (iRequestCode == 80) {
            this.storage.updateClusterConfiguration(this.storage.getCurrentServerURL(), (byte[])obj);
            if (OLogManager.instance().isDebugEnabled()) {
                ODocument oDocument = this.storage.getClusterConfiguration();
                synchronized (oDocument) {
                    OLogManager.instance().debug((Object)this, "Received new cluster configuration: %s", this.storage.getClusterConfiguration().toJSON("prettyPrint"));
                }
            }
        } else if (iRequestCode == 81) {
            byte[] bytes = (byte[])obj;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                byte op = dis.readByte();
                Integer id = dis.readInt();
                ORecord record = Orient.instance().getRecordFactoryManager().newInstance(dis.readByte());
                ORecordId rid = this.readRID(dis);
                ORecordVersion version = this.readVersion(dis);
                byte[] content = this.readBytes(dis);
                ORecordInternal.fill(record, rid, version, content, false);
                OLiveResultListener listener = this.liveQueryListeners.get(id);
                listener.onLiveResult(id, new ORecordOperation(record, op));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ORecordVersion readVersion(DataInputStream dis) throws IOException {
        ORecordVersion version = OVersionFactory.instance().createVersion();
        version.setCounter(dis.readInt());
        return version;
    }

    private ORecordId readRID(DataInputStream dis) throws IOException {
        short clusterId = dis.readShort();
        long clusterPosition = dis.readLong();
        return new ORecordId(clusterId, clusterPosition);
    }

    public byte[] readBytes(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        in.readFully(tmp);
        return tmp;
    }

    public OStorageRemote getStorage() {
        return this.storage;
    }

    @Override
    public void registerLiveListener(Integer id, OLiveResultListener listener) {
        this.liveQueryListeners.put(id, listener);
    }

    @Override
    public void unregisterLiveListener(Integer id) {
        this.liveQueryListeners.remove(id);
    }
}

