/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.Hashtable;
import java.util.Map;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class OSignalHandler
implements SignalHandler {
    private Hashtable<Signal, SignalHandler> redefinedHandlers = new Hashtable(4);

    public void listenTo(String name, SignalHandler iListener) {
        Signal signal = new Signal(name);
        SignalHandler redefinedHandler = Signal.handle(signal, iListener);
        if (redefinedHandler != null) {
            this.redefinedHandlers.put(signal, redefinedHandler);
        }
    }

    @Override
    public void handle(Signal signal) {
        OLogManager.instance().info((Object)this, "Received signal: %s", signal);
        String s = signal.toString().trim();
        if (Orient.instance().isSelfManagedShutdown() && (s.equals("SIGKILL") || s.equals("SIGHUP") || s.equals("SIGINT") || s.equals("SIGTERM"))) {
            Orient.instance().shutdown();
            System.exit(1);
        } else if (s.equals("SIGTRAP")) {
            System.out.println();
            OGlobalConfiguration.dumpConfiguration(System.out);
            System.out.println();
            Orient.instance().getProfiler().dump(System.out);
            System.out.println();
        } else {
            SignalHandler redefinedHandler = this.redefinedHandlers.get(signal);
            if (redefinedHandler != null) {
                redefinedHandler.handle(signal);
            }
        }
    }

    public void installDefaultSignals() {
        this.installDefaultSignals(this);
    }

    public void installDefaultSignals(SignalHandler iListener) {
        try {
            this.listenTo("INT", iListener);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.listenTo("TERM", iListener);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.listenTo("TRAP", iListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void cancel() {
        for (Map.Entry<Signal, SignalHandler> entry : this.redefinedHandlers.entrySet()) {
            try {
                Signal.handle(entry.getKey(), entry.getValue());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.redefinedHandlers.clear();
    }
}

