/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class ODatabaseWrapperAbstract<DB extends ODatabaseInternal, T>
implements ODatabaseInternal<T> {
    protected DB underlying;
    protected ODatabaseInternal<?> databaseOwner;

    public ODatabaseWrapperAbstract(DB iDatabase) {
        this.underlying = iDatabase;
        this.databaseOwner = this;
        Orient.instance().getDatabaseFactory().register(this.databaseOwner);
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        this.underlying.open(iUserName, iUserPassword);
        return (THISDB)this;
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(OToken iToken) {
        this.underlying.open(iToken);
        Orient.instance().getDatabaseFactory().register(this.databaseOwner);
        return (THISDB)this;
    }

    @Override
    public ODatabase activateOnCurrentThread() {
        return this.underlying.activateOnCurrentThread();
    }

    @Override
    public boolean isActiveOnCurrentThread() {
        return this.underlying.isActiveOnCurrentThread();
    }

    @Override
    public <THISDB extends ODatabase> THISDB create() {
        return this.create(null);
    }

    @Override
    public <THISDB extends ODatabase> THISDB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        this.underlying.create(iInitialSettings);
        return (THISDB)this;
    }

    @Override
    public boolean exists() {
        return this.underlying.exists();
    }

    @Override
    public void reload() {
        this.underlying.reload();
    }

    @Override
    public OContextConfiguration getConfiguration() {
        return this.underlying.getConfiguration();
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        return this.underlying.backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.underlying.restore(in, options, callable, iListener);
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.underlying.replaceStorage(iNewStorage);
    }

    @Override
    public void drop() {
        this.underlying.drop();
        Orient.instance().getDatabaseFactory().unregister(this.databaseOwner);
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.underlying.getStatus();
    }

    @Override
    public <THISDB extends ODatabase> THISDB setStatus(ODatabase.STATUS iStatus) {
        this.underlying.setStatus(iStatus);
        return (THISDB)this;
    }

    @Override
    public String getName() {
        return this.underlying.getName();
    }

    @Override
    public String getURL() {
        return this.underlying.getURL();
    }

    @Override
    public OStorage getStorage() {
        return this.underlying.getStorage();
    }

    @Override
    public OLocalRecordCache getLocalCache() {
        return this.underlying.getLocalCache();
    }

    @Override
    public boolean isClosed() {
        return this.underlying.isClosed();
    }

    @Override
    public long countClusterElements(int iClusterId) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterId);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterIds);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterName);
    }

    @Override
    public long countClusterElements(int iClusterId, boolean countTombstones) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterIds, countTombstones);
    }

    @Override
    public int getClusters() {
        this.checkOpeness();
        return this.underlying.getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        this.checkOpeness();
        return this.underlying.existsCluster(iClusterName);
    }

    @Override
    public Collection<String> getClusterNames() {
        this.checkOpeness();
        return this.underlying.getClusterNames();
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkOpeness();
        return this.underlying.getClusterIdByName(iClusterName);
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        this.checkOpeness();
        return this.underlying.getClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeById(int iClusterId) {
        return this.underlying.getClusterRecordSizeById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeByName(String iClusterName) {
        return this.underlying.getClusterRecordSizeByName(iClusterName);
    }

    @Override
    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        this.checkOpeness();
        return this.underlying.addCluster(iClusterName, iRequestedId, iParameters);
    }

    @Override
    public int addCluster(String iClusterName, Object ... iParameters) {
        this.checkOpeness();
        return this.underlying.addCluster(iClusterName, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.getLocalCache().freeCluster(this.getClusterIdByName(iClusterName));
        return this.underlying.dropCluster(iClusterName, true);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.getLocalCache().freeCluster(iClusterId);
        return this.underlying.dropCluster(iClusterId, true);
    }

    @Override
    public int getDefaultClusterId() {
        this.checkOpeness();
        return this.underlying.getDefaultClusterId();
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        return this.underlying.declareIntent(iIntent);
    }

    @Override
    public <DBTYPE extends ODatabase> DBTYPE getUnderlying() {
        return (DBTYPE)this.underlying;
    }

    @Override
    public ODatabaseInternal<?> getDatabaseOwner() {
        return this.databaseOwner;
    }

    @Override
    public ODatabaseInternal<?> setDatabaseOwner(ODatabaseInternal<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    public boolean equals(Object iOther) {
        if (!(iOther instanceof ODatabase)) {
            return false;
        }
        ODatabase other = (ODatabase)iOther;
        return other.getName().equals(this.getName());
    }

    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        return this.underlying.setProperty(iName, iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.underlying.getProperty(iName);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.underlying.getProperties();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        return this.underlying.get(iAttribute);
    }

    @Override
    public <THISDB extends ODatabase> THISDB set(ODatabase.ATTRIBUTES attribute, Object iValue) {
        return (THISDB)this.underlying.set(attribute, iValue);
    }

    @Override
    public void registerListener(ODatabaseListener iListener) {
        this.underlying.registerListener(iListener);
    }

    @Override
    public void unregisterListener(ODatabaseListener iListener) {
        this.underlying.unregisterListener(iListener);
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.getStorage().callInLock(iCallable, iExclusiveLock);
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.underlying.getRecordMetadata(rid);
    }

    @Override
    public long getSize() {
        return this.underlying.getSize();
    }

    @Override
    public void freeze(boolean throwException) {
        this.underlying.freeze(throwException);
    }

    @Override
    public void freeze() {
        this.underlying.freeze();
    }

    @Override
    public void release() {
        this.underlying.release();
    }

    @Override
    public void freezeCluster(int iClusterId, boolean throwException) {
        this.underlying.freezeCluster(iClusterId, throwException);
    }

    @Override
    public void freezeCluster(int iClusterId) {
        this.underlying.freezeCluster(iClusterId);
    }

    @Override
    public void releaseCluster(int iClusterId) {
        this.underlying.releaseCluster(iClusterId);
    }

    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }
}

