/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryPage;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public class ODirectoryFirstPage
extends ODirectoryPage {
    private static final int TREE_SIZE_OFFSET = 28;
    private static final int TOMBSTONE_OFFSET = 32;
    private static final int ITEMS_OFFSET = 36;
    public static final int NODES_PER_PAGE = (OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024 - 36) / 2051;

    public ODirectoryFirstPage(OCacheEntry cacheEntry, OWALChangesTree changesTree, OCacheEntry entry) {
        super(cacheEntry, changesTree, entry);
    }

    public void setTreeSize(int treeSize) throws IOException {
        this.setIntValue(28, treeSize);
    }

    public int getTreeSize() {
        return this.getIntValue(28);
    }

    public void setTombstone(int tombstone) throws IOException {
        this.setIntValue(32, tombstone);
    }

    public int getTombstone() {
        return this.getIntValue(32);
    }

    @Override
    protected int getItemsOffset() {
        return 36;
    }
}

