/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Comparator;

public interface OHashTable<K, V> {
    public void create(OBinarySerializer<K> var1, OBinarySerializer<V> var2, OType[] var3, boolean var4);

    public OBinarySerializer<K> getKeySerializer();

    public void setKeySerializer(OBinarySerializer<K> var1);

    public OBinarySerializer<V> getValueSerializer();

    public void setValueSerializer(OBinarySerializer<V> var1);

    public V get(K var1);

    public void put(K var1, V var2);

    public V remove(K var1);

    public void clear();

    public OHashIndexBucket.Entry<K, V>[] higherEntries(K var1);

    public OHashIndexBucket.Entry<K, V>[] higherEntries(K var1, int var2);

    public void load(String var1, OType[] var2, boolean var3);

    public void deleteWithoutLoad(String var1, OAbstractPaginatedStorage var2);

    public OHashIndexBucket.Entry<K, V>[] ceilingEntries(K var1);

    public OHashIndexBucket.Entry<K, V> firstEntry();

    public OHashIndexBucket.Entry<K, V> lastEntry();

    public OHashIndexBucket.Entry<K, V>[] lowerEntries(K var1);

    public OHashIndexBucket.Entry<K, V>[] floorEntries(K var1);

    public long size();

    public void close();

    public void delete();

    public void flush();

    public static final class KeyHashCodeComparator<K>
    implements Comparator<K> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        private final OHashFunction<K> keyHashFunction;

        public KeyHashCodeComparator(OHashFunction<K> keyHashFunction) {
            this.keyHashFunction = keyHashFunction;
        }

        @Override
        public int compare(K keyOne, K keyTwo) {
            long hashCodeTwo;
            long hashCodeOne = this.keyHashFunction.hashCode(keyOne);
            if (KeyHashCodeComparator.greaterThanUnsigned(hashCodeOne, hashCodeTwo = this.keyHashFunction.hashCode(keyTwo))) {
                return 1;
            }
            if (KeyHashCodeComparator.lessThanUnsigned(hashCodeOne, hashCodeTwo)) {
                return -1;
            }
            return this.comparator.compare(keyOne, keyTwo);
        }

        private static boolean lessThanUnsigned(long longOne, long longTwo) {
            return longOne + Long.MIN_VALUE < longTwo + Long.MIN_VALUE;
        }

        private static boolean greaterThanUnsigned(long longOne, long longTwo) {
            return longOne + Long.MIN_VALUE > longTwo + Long.MIN_VALUE;
        }
    }

    public static final class NodeSplitResult {
        public final long[] newNode;
        public final boolean allLeftHashMapsEqual;
        public final boolean allRightHashMapsEqual;

        public NodeSplitResult(long[] newNode, boolean allLeftHashMapsEqual, boolean allRightHashMapsEqual) {
            this.newNode = newNode;
            this.allLeftHashMapsEqual = allLeftHashMapsEqual;
            this.allRightHashMapsEqual = allRightHashMapsEqual;
        }
    }

    public static final class BucketSplitResult {
        public final long updatedBucketPointer;
        public final long newBucketPointer;
        public final int newDepth;

        public BucketSplitResult(long updatedBucketPointer, long newBucketPointer, int newDepth) {
            this.updatedBucketPointer = updatedBucketPointer;
            this.newBucketPointer = newBucketPointer;
            this.newDepth = newDepth;
        }
    }

    public static final class BucketPath {
        public final BucketPath parent;
        public final int hashMapOffset;
        public final int itemIndex;
        public final int nodeIndex;
        public final int nodeGlobalDepth;
        public final int nodeLocalDepth;

        public BucketPath(BucketPath parent, int hashMapOffset, int itemIndex, int nodeIndex, int nodeLocalDepth, int nodeGlobalDepth) {
            this.parent = parent;
            this.hashMapOffset = hashMapOffset;
            this.itemIndex = itemIndex;
            this.nodeIndex = nodeIndex;
            this.nodeGlobalDepth = nodeGlobalDepth;
            this.nodeLocalDepth = nodeLocalDepth;
        }
    }
}

