/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.script.OCommandExecutorFunction;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandFunction;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OFunction
extends ODocumentWrapper {
    public static final String CLASS_NAME = "OFunction";

    public OFunction() {
        super(CLASS_NAME);
        this.setLanguage("SQL");
    }

    public OFunction(ODocument iDocument) {
        super(iDocument);
    }

    public OFunction(ORecordId iRid) {
        super(iRid);
    }

    public String getName() {
        return (String)this.document.field("name");
    }

    public OFunction setName(String iName) {
        this.document.field("name", iName);
        return this;
    }

    public String getCode() {
        return (String)this.document.field("code");
    }

    public OFunction setCode(String iCode) {
        this.document.field("code", iCode);
        return this;
    }

    public String getLanguage() {
        return (String)this.document.field("language");
    }

    public OFunction setLanguage(String iLanguage) {
        this.document.field("language", iLanguage);
        return this;
    }

    public List<String> getParameters() {
        return (List)this.document.field("parameters");
    }

    public OFunction setParameters(List<String> iParameters) {
        this.document.field("parameters", iParameters);
        return this;
    }

    public boolean isIdempotent() {
        Boolean idempotent = (Boolean)this.document.field("idempotent");
        return idempotent != null && idempotent != false;
    }

    public OFunction setIdempotent(boolean iIdempotent) {
        this.document.field("idempotent", iIdempotent);
        return this;
    }

    public Object execute(Object ... iArgs) {
        return this.executeInContext(null, iArgs);
    }

    public Object executeInContext(OCommandContext iContext, Object ... iArgs) {
        OCommandExecutorFunction command = new OCommandExecutorFunction();
        command.parse(new OCommandFunction(this.getName()));
        List<String> params = this.getParameters();
        LinkedHashMap<Object, Object> args = null;
        if (iArgs.length > 0) {
            args = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < iArgs.length; ++i) {
                Object argValue = iArgs[i];
                if (params != null && i < params.size()) {
                    args.put(params.get(i), argValue);
                    continue;
                }
                args.put("param" + i, argValue);
            }
        }
        return command.executeInContext(iContext, args);
    }

    public Object executeInContext(OCommandContext iContext, Map<String, Object> iArgs) {
        OCommandExecutorFunction command = new OCommandExecutorFunction();
        command.parse(new OCommandFunction(this.getName()));
        LinkedHashMap<Object, Object> args = new LinkedHashMap<Object, Object>();
        if (iArgs.size() > 0) {
            List<String> params = this.getParameters();
            for (String p : params) {
                args.put(p, iArgs.get(p));
            }
        }
        return command.executeInContext(iContext, args);
    }

    public Object execute(Map<Object, Object> iArgs) {
        long start = Orient.instance().getProfiler().startChrono();
        OCommandExecutorScript command = new OCommandExecutorScript();
        command.parse(new OCommandScript(this.getLanguage(), this.getCode()));
        Object result = command.execute(iArgs);
        if (Orient.instance().getProfiler().isRecording()) {
            Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.INSTANCE.get().getName() + ".function.execute", "Time to execute a function", start, "db.*.function.execute");
        }
        return result;
    }

    public ORID getId() {
        return this.document.getIdentity();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

