/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.script.OCommandExecutorFunction;
import com.orientechnologies.orient.core.command.script.OCommandFunction;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OFunctionLibraryImpl
implements OFunctionLibrary {
    protected Map<String, OFunction> functions = new ConcurrentHashMap<String, OFunction>();

    @Override
    public void create() {
        this.init();
    }

    @Override
    public void load() {
        this.functions.clear();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().existsClass("OFunction")) {
            Object result = db.query(new OSQLSynchQuery("select from OFunction order by name"), new Object[0]);
            for (ODocument d : result) {
                d.reload();
                this.functions.put(d.field("name").toString().toUpperCase(), new OFunction(d));
            }
        }
    }

    @Override
    public Set<String> getFunctionNames() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    @Override
    public OFunction getFunction(String iName) {
        return this.functions.get(iName.toUpperCase());
    }

    @Override
    public synchronized OFunction createFunction(String iName) {
        this.init();
        OFunction f = new OFunction().setName(iName);
        f.save();
        this.functions.put(iName.toUpperCase(), f);
        return f;
    }

    @Override
    public void close() {
        this.functions.clear();
    }

    protected void init() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getMetadata().getSchema().existsClass("OFunction")) {
            return;
        }
        OClassImpl f = (OClassImpl)db.getMetadata().getSchema().createClass("OFunction");
        f.createProperty("name", OType.STRING, (OType)null, false);
        f.createProperty("code", OType.STRING, (OType)null, false);
        f.createProperty("language", OType.STRING, (OType)null, false);
        f.createProperty("idempotent", OType.BOOLEAN, (OType)null, false);
        f.createProperty("parameters", OType.EMBEDDEDLIST, OType.STRING, false);
    }

    static {
        OCommandManager.instance().registerExecutor(OCommandFunction.class, OCommandExecutorFunction.class);
    }
}

