/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.ONullOutputListener;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class OSecurityShared
implements OSecurity,
OCloseable {
    private final AtomicLong version = new AtomicLong();
    public static final Set<String> ALLOW_FIELDS = new HashSet<String>(){
        {
            this.add("_allow");
            this.add("_allowDelete");
            this.add("_allowRead");
            this.add("_allowUpdate");
        }
    };

    @Override
    public OIdentifiable allowUser(ODocument iDocument, String iAllowFieldName, String iUserName) {
        ORID user = this.getUserRID(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.allowIdentity(iDocument, iAllowFieldName, user);
    }

    @Override
    public OIdentifiable allowRole(ODocument iDocument, String iAllowFieldName, String iRoleName) {
        ORID role = this.getRoleRID(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.allowIdentity(iDocument, iAllowFieldName, role);
    }

    @Override
    public OIdentifiable allowIdentity(ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field == null) {
            field = new ORecordLazySet(iDocument);
            iDocument.field(iAllowFieldName, field);
        }
        field.add(iId);
        return iId;
    }

    @Override
    public OIdentifiable disallowUser(ODocument iDocument, String iAllowFieldName, String iUserName) {
        ORID user = this.getUserRID(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.disallowIdentity(iDocument, iAllowFieldName, user);
    }

    @Override
    public OIdentifiable disallowRole(ODocument iDocument, String iAllowFieldName, String iRoleName) {
        ORID role = this.getRoleRID(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.disallowIdentity(iDocument, iAllowFieldName, role);
    }

    @Override
    public OIdentifiable disallowIdentity(ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field != null) {
            field.remove(iId);
        }
        return iId;
    }

    @Override
    public boolean isAllowed(Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        if ((iAllowAll == null || iAllowAll.isEmpty()) && (iAllowOperation == null || iAllowOperation.isEmpty())) {
            return false;
        }
        OSecurityUser currentUser = ODatabaseRecordThreadLocal.INSTANCE.get().getUser();
        if (currentUser != null && !iAllowAll.contains(currentUser.getIdentity())) {
            if (iAllowOperation != null && iAllowOperation.contains(currentUser.getIdentity())) {
                return true;
            }
            for (OSecurityRole oSecurityRole : currentUser.getRoles()) {
                if (iAllowAll.contains(oSecurityRole.getIdentity())) {
                    return true;
                }
                if (iAllowOperation != null && iAllowOperation.contains(oSecurityRole.getIdentity())) {
                    return true;
                }
                for (OSecurityRole parentRole = oSecurityRole.getParentRole(); parentRole != null; parentRole = parentRole.getParentRole()) {
                    if (iAllowAll.contains(parentRole.getIdentity())) {
                        return true;
                    }
                    if (iAllowOperation == null || !iAllowOperation.contains(parentRole.getIdentity())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public OUser authenticate(String iUserName, String iUserPassword) {
        String dbName = this.getDatabase().getName();
        OUser user = this.getUser(iUserName);
        if (user == null) {
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
        }
        if (!(this.getDatabase().getStorage() instanceof OStorageProxy) && !user.checkPassword(iUserPassword)) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        return user;
    }

    @Override
    public OUser authenticate(OToken authToken) {
        String dbName = this.getDatabase().getName();
        if (!authToken.getIsValid()) {
            throw new OSecurityAccessException(dbName, "Token not valid");
        }
        OUser user = authToken.getUser(this.getDatabase());
        if (user == null && authToken.getUserName() != null) {
            user = this.getUser(authToken.getUserName());
        }
        if (user == null) {
            throw new OSecurityAccessException(dbName, "Authentication failed, could not load user from token");
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + user.getName() + "' is not active");
        }
        return user;
    }

    @Override
    public OUser getUser(ORID iRecordId) {
        if (iRecordId == null) {
            return null;
        }
        ODocument result = (ODocument)this.getDatabase().load(iRecordId, "roles:1");
        if (!result.getClassName().equals("OUser")) {
            result = null;
        }
        return new OUser(result);
    }

    @Override
    public OUser createUser(String iUserName, String iUserPassword, String ... iRoles) {
        OUser user = new OUser(iUserName, iUserPassword);
        if (iRoles != null) {
            for (String r : iRoles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public OUser createUser(String userName, String userPassword, ORole ... roles) {
        OUser user = new OUser(userName, userPassword);
        if (roles != null) {
            for (ORole r : roles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public boolean dropUser(String iUserName) {
        Number removed = (Number)this.getDatabase().command(new OCommandSQL("delete from OUser where name = ?")).execute(iUserName);
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public ORole getRole(OIdentifiable iRole) {
        ODocument doc = (ODocument)iRole.getRecord();
        if (doc != null && "ORole".equals(doc.getClassName())) {
            return new ORole(doc);
        }
        return null;
    }

    @Override
    public ORole getRole(String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole where name = ? limit 1")).execute(iRoleName);
        if (result != null && !result.isEmpty()) {
            return new ORole((ODocument)result.get(0));
        }
        return null;
    }

    public ORID getRoleRID(String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select rid from index:ORole.name where key = ? limit 1")).execute(iRoleName);
        if (result != null && !result.isEmpty()) {
            return (ORID)((ODocument)result.get(0)).rawField("rid");
        }
        return null;
    }

    @Override
    public ORole createRole(String iRoleName, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.createRole(iRoleName, null, iAllowMode);
    }

    @Override
    public ORole createRole(String iRoleName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        ORole role = new ORole(iRoleName, iParent, iAllowMode);
        return role.save();
    }

    @Override
    public boolean dropRole(String iRoleName) {
        Number removed = (Number)this.getDatabase().command(new OCommandSQL("delete from ORole where name = '" + iRoleName + "'")).execute(new Object[0]);
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public List<ODocument> getAllUsers() {
        return (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser")).execute(new Object[0]);
    }

    @Override
    public List<ODocument> getAllRoles() {
        return (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole")).execute(new Object[0]);
    }

    @Override
    public OUser create() {
        if (!this.getDatabase().getMetadata().getSchema().getClasses().isEmpty()) {
            return null;
        }
        OUser adminUser = this.createMetadata();
        ORole readerRole = this.createRole("reader", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        readerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", 0);
        readerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
        readerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
        readerRole.save();
        this.createUser("reader", "reader", readerRole.getName());
        ORole writerRole = this.createRole("writer", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        writerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
        writerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
        writerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", 0);
        writerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_ALL);
        writerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
        writerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
        writerRole.save();
        this.createUser("writer", "writer", writerRole.getName());
        return adminUser;
    }

    public OUser createMetadata() {
        OUser adminUser;
        ODatabaseDocumentInternal database = this.getDatabase();
        OClass identityClass = database.getMetadata().getSchema().getClass("OIdentity");
        if (identityClass == null) {
            identityClass = database.getMetadata().getSchema().createAbstractClass("OIdentity");
        }
        OClass roleClass = this.createOrUpdateORoleClass(database, identityClass);
        this.createOrUpdateOUserClass(database, identityClass, roleClass);
        ORole adminRole = this.getRole("admin");
        if (adminRole == null) {
            adminRole = this.createRole("admin", OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT);
            adminRole.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_ALL).save();
        }
        if ((adminUser = this.getUser("admin")) == null) {
            adminUser = this.createUser("admin", "admin", adminRole);
        }
        this.createOrUpdateORestrictedClass(database);
        return adminUser;
    }

    private void createOrUpdateORestrictedClass(ODatabaseDocument database) {
        OClass restrictedClass = database.getMetadata().getSchema().getClass("ORestricted");
        boolean checkData = true;
        if (restrictedClass == null) {
            restrictedClass = database.getMetadata().getSchema().createAbstractClass("ORestricted");
            checkData = false;
        }
        if (!restrictedClass.existsProperty("_allow")) {
            ((OClassImpl)restrictedClass).createProperty("_allow", OType.LINKSET, database.getMetadata().getSchema().getClass("OIdentity"), checkData);
        }
        if (!restrictedClass.existsProperty("_allowRead")) {
            ((OClassImpl)restrictedClass).createProperty("_allowRead", OType.LINKSET, database.getMetadata().getSchema().getClass("OIdentity"), checkData);
        }
        if (!restrictedClass.existsProperty("_allowUpdate")) {
            ((OClassImpl)restrictedClass).createProperty("_allowUpdate", OType.LINKSET, database.getMetadata().getSchema().getClass("OIdentity"), checkData);
        }
        if (!restrictedClass.existsProperty("_allowDelete")) {
            ((OClassImpl)restrictedClass).createProperty("_allowDelete", OType.LINKSET, database.getMetadata().getSchema().getClass("OIdentity"), checkData);
        }
    }

    private void createOrUpdateOUserClass(ODatabaseDocument database, OClass identityClass, OClass roleClass) {
        boolean checkData = true;
        OClass userClass = database.getMetadata().getSchema().getClass("OUser");
        if (userClass == null) {
            userClass = database.getMetadata().getSchema().createClass("OUser", identityClass);
            checkData = false;
        } else if (!userClass.getSuperClasses().contains(identityClass)) {
            userClass.setSuperClasses(Arrays.asList(identityClass));
        }
        if (!userClass.existsProperty("name")) {
            ((OClassImpl)userClass).createProperty("name", OType.STRING, (OType)null, checkData).setMandatory(true).setNotNull(true).setCollate("ci");
            userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = userClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!userClass.existsProperty("password")) {
            ((OClassImpl)userClass).createProperty("password", OType.STRING, (OType)null, checkData).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("roles")) {
            ((OClassImpl)userClass).createProperty("roles", OType.LINKSET, roleClass, checkData);
        }
        if (!userClass.existsProperty("status")) {
            ((OClassImpl)userClass).createProperty("status", OType.STRING, (OType)null, checkData).setMandatory(true).setNotNull(true);
        }
    }

    private OClass createOrUpdateORoleClass(ODatabaseDocument database, OClass identityClass) {
        OClass roleClass = database.getMetadata().getSchema().getClass("ORole");
        boolean checkData = true;
        if (roleClass == null) {
            roleClass = database.getMetadata().getSchema().createClass("ORole", identityClass);
            checkData = false;
        } else if (!roleClass.getSuperClasses().contains(identityClass)) {
            roleClass.setSuperClasses(Arrays.asList(identityClass));
        }
        if (!roleClass.existsProperty("name")) {
            ((OClassImpl)roleClass).createProperty("name", OType.STRING, (OType)null, checkData).setMandatory(true).setNotNull(true).setCollate("ci");
            roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = roleClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!roleClass.existsProperty("mode")) {
            ((OClassImpl)roleClass).createProperty("mode", OType.BYTE, (OType)null, checkData);
        }
        if (!roleClass.existsProperty("rules")) {
            ((OClassImpl)roleClass).createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE, checkData);
        }
        if (!roleClass.existsProperty("inheritedRole")) {
            ((OClassImpl)roleClass).createProperty("inheritedRole", OType.LINK, roleClass, checkData);
        }
        return roleClass;
    }

    @Override
    public void close() {
    }

    @Override
    public void close(boolean onDelete) {
    }

    @Override
    public void load() {
        OClass userClass = this.getDatabase().getMetadata().getSchema().getClass("OUser");
        if (userClass != null) {
            OClass roleClass;
            OProperty rules;
            OProperty p;
            if (!userClass.existsProperty("status")) {
                userClass.createProperty("status", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if ((p = userClass.getProperty("name")) == null) {
                p = userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if (userClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
            if ((rules = (roleClass = this.getDatabase().getMetadata().getSchema().getClass("ORole")).getProperty("rules")) != null && !OType.EMBEDDEDMAP.equals((Object)rules.getType())) {
                roleClass.dropProperty("rules");
            }
            if (!roleClass.existsProperty("inheritedRole")) {
                roleClass.createProperty("inheritedRole", OType.LINK, roleClass);
            }
            if ((p = roleClass.getProperty("name")) == null) {
                p = roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if (roleClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
        }
    }

    @Override
    public void createClassTrigger() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        OClass classTrigger = db.getMetadata().getSchema().getClass("OTriggered");
        if (classTrigger == null) {
            classTrigger = db.getMetadata().getSchema().createAbstractClass("OTriggered");
        }
    }

    @Override
    public OSecurity getUnderlying() {
        return this;
    }

    @Override
    public OUser getUser(String iUserName) {
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser where name = ? limit 1").setFetchPlan("roles:1")).execute(iUserName);
        if (result != null && !result.isEmpty()) {
            return new OUser((ODocument)result.get(0));
        }
        return null;
    }

    public ORID getUserRID(String iUserName) {
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select rid from index:OUser.name where key = ? limit 1")).execute(iUserName);
        if (result != null && !result.isEmpty()) {
            return (ORID)((ODocument)result.get(0)).rawField("rid");
        }
        return null;
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public void incrementVersion() {
        this.version.incrementAndGet();
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

