/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OUserTrigger
extends ODocumentHookAbstract {
    private OClass userClass;
    private OClass roleClass;

    public OUserTrigger(ODatabaseDocument database) {
        super(database);
        this.setIncludeClasses("OUser", "ORole");
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        this.init();
        if (iDocument.getSchemaClass().isSubClassOf(this.userClass)) {
            return this.encodePassword(iDocument);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        this.init();
        if (iDocument.getSchemaClass().isSubClassOf(this.userClass)) {
            return this.encodePassword(iDocument);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    private ORecordHook.RESULT encodePassword(ODocument iDocument) {
        if (iDocument.field("name") == null) {
            throw new OSecurityException("User name not found");
        }
        String password = (String)iDocument.field("password");
        if (password == null) {
            throw new OSecurityException("User '" + iDocument.field("name") + "' has no password");
        }
        if (!password.startsWith("{SHA-256}")) {
            iDocument.field("password", OUser.encryptPassword(password));
            return ORecordHook.RESULT.RECORD_CHANGED;
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    private void init() {
        if (this.userClass == null) {
            this.userClass = this.database.getMetadata().getSchema().getClass("OUser");
        }
        if (this.roleClass == null) {
            this.roleClass = this.database.getMetadata().getSchema().getClass("ORole");
        }
    }
}

