/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordStringable;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;

@Deprecated
public class ORecordFlat
extends ORecordAbstract
implements ORecordStringable {
    private static final long serialVersionUID = 1L;
    public static final byte RECORD_TYPE = 102;
    protected String value;

    public ORecordFlat(ODatabaseDocumentTx iDatabase) {
        this();
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordFlat() {
        this.setup();
    }

    public ORecordFlat(byte[] iSource) {
        super(iSource);
        this.setup();
    }

    public ORecordFlat(ODatabaseDocument iDatabase, ORID iRID) {
        this._recordId = (ORecordId)iRID;
    }

    @Override
    public ORecordFlat value(String iValue) {
        this.value = iValue;
        this.setDirty();
        return this;
    }

    @Override
    public ORecordFlat reset() {
        super.reset();
        this.value = null;
        return this;
    }

    @Override
    public ORecordFlat unload() {
        super.unload();
        this.value = null;
        return this;
    }

    @Override
    public ORecordFlat clear() {
        super.clear();
        this.value = null;
        return this;
    }

    public ORecordFlat copy() {
        ORecordFlat cloned = new ORecordFlat();
        cloned._source = this._source;
        cloned.value = this.value;
        cloned._recordId = this._recordId.copy();
        cloned._dirty = this._dirty;
        cloned._contentChanged = this._contentChanged;
        cloned._recordVersion = this._recordVersion.copy();
        return cloned;
    }

    @Override
    public String value() {
        if (this.value == null) {
            if (this._source == null && this.getIdentity() != null && this.getIdentity().isValid()) {
                this.reload();
            }
            this.value = OBinaryProtocol.bytes2string(this._source);
        }
        return this.value;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.value();
    }

    @Override
    public ORecord reload() {
        this.value = null;
        return super.reload();
    }

    @Override
    public ORecordAbstract fromStream(byte[] iRecordBuffer) {
        super.fromStream(iRecordBuffer);
        this.value = null;
        return this;
    }

    @Override
    public byte[] toStream() {
        if (this._source == null && this.value != null) {
            this._source = OBinaryProtocol.string2bytes(this.value);
        }
        return this._source;
    }

    public int size() {
        String v = this.value();
        return v != null ? v.length() : 0;
    }

    @Override
    public byte getRecordType() {
        return 102;
    }
}

