/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.schedule.OSchedulerListener;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OSchedulerListenerImpl
implements OSchedulerListener {
    private static Map<String, OScheduler> schedulers = new ConcurrentHashMap<String, OScheduler>();

    @Override
    public void addScheduler(OScheduler scheduler) {
        if (!schedulers.containsKey(scheduler.getSchduleName())) {
            schedulers.put(scheduler.getSchduleName(), scheduler);
        }
    }

    @Override
    public void removeScheduler(OScheduler scheduler) {
        if (scheduler.isRunning()) {
            throw new OException("Cannot delete scheduler " + scheduler.getSchduleName() + " due to it is still running");
        }
        schedulers.remove(scheduler.getSchduleName());
    }

    @Override
    public Map<String, OScheduler> getSchedulers() {
        return schedulers;
    }

    @Override
    public OScheduler getScheduler(String name) {
        return schedulers.get(name);
    }

    @Override
    public void load() {
        schedulers.clear();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getMetadata().getSchema().existsClass("OSchedule")) {
            Object result = db.query(new OSQLSynchQuery("select from OSchedule order by name"), new Object[0]);
            for (ODocument d : result) {
                d.reload();
                this.addScheduler(new OScheduler(d));
            }
        }
    }

    @Override
    public void close() {
        schedulers.clear();
    }

    @Override
    public void create() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getMetadata().getSchema().existsClass("OSchedule")) {
            return;
        }
        OClassImpl f = (OClassImpl)db.getMetadata().getSchema().createClass("OSchedule");
        f.createProperty(OScheduler.PROP_NAME, OType.STRING, (OType)null, false).setMandatory(true).setNotNull(true);
        f.createProperty(OScheduler.PROP_RULE, OType.STRING, (OType)null, false).setMandatory(true).setNotNull(true);
        f.createProperty(OScheduler.PROP_ARGUMENTS, OType.EMBEDDEDMAP, (OType)null, false);
        f.createProperty(OScheduler.PROP_STATUS, OType.STRING, (OType)null, false);
        f.createProperty(OScheduler.PROP_FUNC, OType.LINK, db.getMetadata().getSchema().getClass("OFunction"), false).setMandatory(true).setNotNull(true);
        f.createProperty(OScheduler.PROP_STARTTIME, OType.DATETIME, (OType)null, false);
        f.createProperty(OScheduler.PROP_STARTED, OType.BOOLEAN, (OType)null, false);
    }
}

