/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class OMemoryStream
extends OutputStream {
    public static final int DEF_SIZE = 1024;
    private byte[] buffer;
    private int position;
    private Charset charset = Charset.forName("utf8");
    private static final int NATIVE_COPY_THRESHOLD = 9;
    private static long metricResize = 0L;

    public OMemoryStream() {
        this(1024);
    }

    public OMemoryStream(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
    }

    public OMemoryStream(byte[] stream) {
        this.buffer = stream;
    }

    public void move(int iFrom, int iPosition) {
        if (iPosition == 0) {
            return;
        }
        int to = iFrom + iPosition;
        int size = iPosition > 0 ? this.buffer.length - to : this.buffer.length - iFrom;
        System.arraycopy(this.buffer, iFrom, this.buffer, to, size);
    }

    public void copyFrom(OMemoryStream iSource, int iSize) {
        if (iSize < 0) {
            return;
        }
        this.assureSpaceFor(this.position + iSize);
        System.arraycopy(iSource.buffer, iSource.position, this.buffer, this.position, iSize);
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.position);
    }

    public final byte[] getInternalBuffer() {
        return this.buffer;
    }

    public final byte[] toByteArray() {
        if (this.position == this.buffer.length - 1) {
            return this.buffer;
        }
        int pos = this.position;
        byte[] destinBuffer = new byte[pos];
        byte[] sourceBuffer = this.buffer;
        if (pos < 9) {
            for (int i = 0; i < pos; ++i) {
                destinBuffer[i] = sourceBuffer[i];
            }
        } else {
            System.arraycopy(sourceBuffer, 0, destinBuffer, 0, pos);
        }
        return destinBuffer;
    }

    public final void reset() {
        this.position = 0;
    }

    @Override
    public final void write(int b) {
        this.assureSpaceFor(1);
        this.buffer[this.position++] = (byte)b;
    }

    @Override
    public final void write(byte[] iBuffer, int iOffset, int iLength) {
        int pos = this.position;
        int tot = pos + iLength;
        this.assureSpaceFor(iLength);
        byte[] localBuffer = this.buffer;
        if (iLength < 9) {
            for (int i = 0; i < iLength; ++i) {
                localBuffer[pos + i] = iBuffer[iOffset + i];
            }
        } else {
            System.arraycopy(iBuffer, iOffset, localBuffer, pos, iLength);
        }
        this.position = tot;
    }

    @Override
    public final void close() {
        this.reset();
    }

    public final void setAsFixed(byte[] iContent) {
        if (iContent == null) {
            return;
        }
        this.write(iContent, 0, iContent.length);
    }

    public int set(byte[] iContent) {
        if (iContent == null) {
            return -1;
        }
        int begin = this.position;
        this.assureSpaceFor(4 + iContent.length);
        OBinaryProtocol.int2bytes(iContent.length, this.buffer, this.position);
        this.position += 4;
        this.write(iContent, 0, iContent.length);
        return begin;
    }

    public void remove(int iBegin, int iEnd) {
        if (iBegin > iEnd) {
            throw new IllegalArgumentException("Begin is bigger than end");
        }
        if (iEnd > this.buffer.length) {
            throw new IndexOutOfBoundsException("Position " + iEnd + " is greater than the buffer length (" + this.buffer.length + ")");
        }
        System.arraycopy(this.buffer, iEnd, this.buffer, iBegin, this.buffer.length - iEnd);
    }

    public void set(byte iContent) {
        this.write(iContent);
    }

    public final int setCustom(String iContent) {
        return this.set(OBinaryProtocol.string2bytes(iContent));
    }

    public final int setUtf8(String iContent) {
        return this.set(iContent.getBytes(this.charset));
    }

    public int set(boolean iContent) {
        int begin = this.position;
        this.write((byte)(iContent ? 1 : 0));
        return begin;
    }

    public int set(char iContent) {
        this.assureSpaceFor(2);
        int begin = this.position;
        OBinaryProtocol.char2bytes(iContent, this.buffer, this.position);
        this.position += 2;
        return begin;
    }

    public int set(int iContent) {
        this.assureSpaceFor(4);
        int begin = this.position;
        OBinaryProtocol.int2bytes(iContent, this.buffer, this.position);
        this.position += 4;
        return begin;
    }

    public int set(long iContent) {
        this.assureSpaceFor(8);
        int begin = this.position;
        OBinaryProtocol.long2bytes(iContent, this.buffer, this.position);
        this.position += 8;
        return begin;
    }

    public int set(short iContent) {
        this.assureSpaceFor(2);
        int begin = this.position;
        OBinaryProtocol.short2bytes(iContent, this.buffer, this.position);
        this.position += 2;
        return begin;
    }

    public int getPosition() {
        return this.position;
    }

    private void assureSpaceFor(int iLength) {
        byte[] localBuffer = this.buffer;
        int pos = this.position;
        int bufferLength = localBuffer.length;
        int capacity = this.position + iLength;
        if (bufferLength < capacity) {
            ++metricResize;
            byte[] newbuf = new byte[Math.max(bufferLength << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = localBuffer[i];
                }
            } else {
                System.arraycopy(localBuffer, 0, newbuf, 0, pos);
            }
            this.buffer = newbuf;
        }
    }

    public void fill(int iLength) {
        this.assureSpaceFor(iLength);
        this.position += iLength;
    }

    public void fill(int iLength, byte iFiller) {
        this.assureSpaceFor(iLength);
        Arrays.fill(this.buffer, this.position, this.position + iLength, iFiller);
        this.position += iLength;
    }

    public OMemoryStream jump(int iOffset) {
        if (iOffset > this.buffer.length) {
            throw new IndexOutOfBoundsException("Offset " + iOffset + " is greater than the buffer size " + this.buffer.length);
        }
        this.position = iOffset;
        return this;
    }

    public byte[] getAsByteArrayFixed(int iSize) {
        if (this.position >= this.buffer.length) {
            return null;
        }
        byte[] portion = OArrays.copyOfRange(this.buffer, this.position, this.position + iSize);
        this.position += iSize;
        return portion;
    }

    public int getAsByteArrayOffset() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        int begin = this.position;
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4 + size;
        return begin;
    }

    public int read() {
        return this.buffer[this.position++];
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        if (this.position >= this.buffer.length) {
            return 0;
        }
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
        return len;
    }

    public byte[] getAsByteArray(int iOffset) {
        if (this.buffer == null || iOffset >= this.buffer.length) {
            return null;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, iOffset);
        if (size == 0) {
            return null;
        }
        return OArrays.copyOfRange(this.buffer, iOffset += 4, iOffset + size);
    }

    public byte[] getAsByteArray() {
        if (this.position >= this.buffer.length) {
            return null;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        byte[] portion = OArrays.copyOfRange(this.buffer, this.position, this.position + size);
        this.position += size;
        return portion;
    }

    public String getAsString() {
        if (this.position >= this.buffer.length) {
            return null;
        }
        int size = this.getVariableSize();
        String str = new String(this.buffer, this.position, size, this.charset);
        this.position += size;
        return str;
    }

    public String getAsStringCustom() {
        int size = this.getVariableSize();
        if (size < 0) {
            return null;
        }
        return OBinaryProtocol.bytes2string(this, size);
    }

    public boolean getAsBoolean() {
        return this.buffer[this.position++] == 1;
    }

    public char getAsChar() {
        char value = OBinaryProtocol.bytes2char(this.buffer, this.position);
        this.position += 2;
        return value;
    }

    public byte getAsByte() {
        return this.buffer[this.position++];
    }

    public long getAsLong() {
        long value = OBinaryProtocol.bytes2long(this.buffer, this.position);
        this.position += 8;
        return value;
    }

    public int getAsInteger() {
        int value = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        return value;
    }

    public short getAsShort() {
        short value = OBinaryProtocol.bytes2short(this.buffer, this.position);
        this.position += 2;
        return value;
    }

    public byte peek() {
        return this.buffer[this.position];
    }

    public void setSource(byte[] iBuffer) {
        this.buffer = iBuffer;
        this.position = 0;
    }

    public byte[] copy() {
        if (this.buffer == null) {
            return null;
        }
        int size = this.position > 0 ? this.position : this.buffer.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.buffer, 0, copy, 0, size);
        return copy;
    }

    public int getVariableSize() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        return size;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public final int size() {
        return this.position;
    }

    static {
        Orient.instance().getProfiler().registerHookValue("system.memory.stream.resize", "Number of resizes of memory stream buffer", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return metricResize;
            }
        });
    }
}

