/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OReturnHandler;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class ORecordsReturnHandler
implements OReturnHandler {
    private final Object returnExpression;
    private final OCommandContext context;
    private List<Object> results;

    protected ORecordsReturnHandler(Object returnExpression, OCommandContext context) {
        this.returnExpression = returnExpression;
        this.context = context;
    }

    @Override
    public void reset() {
        this.results = new ArrayList<Object>();
    }

    @Override
    public Object ret() {
        return this.results;
    }

    protected void storeResult(ODocument result) {
        ODocument processedResult = this.preprocess(result);
        this.results.add(this.evaluateExpression(processedResult));
    }

    protected abstract ODocument preprocess(ODocument var1);

    private Object evaluateExpression(ODocument record) {
        if (this.returnExpression == null) {
            return record;
        }
        this.context.setVariable("current", record);
        Object itemResult = OSQLHelper.getValue(this.returnExpression, (ODocument)record.getRecord(), this.context);
        if (itemResult instanceof OIdentifiable) {
            return itemResult;
        }
        return new ODocument("value", itemResult, new Object[0]);
    }
}

