/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.stat;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OSQLFunctionPercentile
extends OSQLFunctionAbstract {
    public static final String NAME = "percentile";
    protected List<Double> quantiles = new ArrayList<Double>();
    private List<Number> values = new ArrayList<Number>();

    public OSQLFunctionPercentile() {
        this(NAME, 2, -1);
    }

    public OSQLFunctionPercentile(String iName, int iMinParams, int iMaxParams) {
        super(iName, iMaxParams, iMaxParams);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (this.quantiles.isEmpty()) {
            for (int i = 1; i < iParams.length; ++i) {
                this.quantiles.add(Double.parseDouble(iParams[i].toString()));
            }
        }
        if (iParams[0] instanceof Number) {
            this.addValue((Number)iParams[0]);
        } else if (OMultiValue.isMultiValue(iParams[0])) {
            for (Object n : OMultiValue.getMultiValueIterable(iParams[0])) {
                this.addValue((Number)n);
            }
        }
        return null;
    }

    @Override
    public boolean aggregateResults() {
        return true;
    }

    @Override
    public Object getResult() {
        if (this.returnDistributedResult()) {
            return this.values;
        }
        return this.evaluate(this.values);
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        if (this.returnDistributedResult()) {
            ArrayList<Number> dValues = new ArrayList<Number>();
            for (Object iParameter : resultsToMerge) {
                dValues.addAll((List)iParameter);
            }
            return this.evaluate(dValues);
        }
        return resultsToMerge.get(0);
    }

    @Override
    public String getSyntax() {
        return "percentile(<field>, <quantile> [,<quantile>*])";
    }

    private void addValue(Number value) {
        if (value != null) {
            this.values.add(value);
        }
    }

    private Object evaluate(List<Number> iValues) {
        if (iValues.isEmpty()) {
            return null;
        }
        if (this.quantiles.size() > 1) {
            ArrayList<Number> results = new ArrayList<Number>();
            for (Double q : this.quantiles) {
                results.add(this.evaluate(iValues, q));
            }
            return results;
        }
        return this.evaluate(iValues, this.quantiles.get(0));
    }

    private Number evaluate(List<Number> iValues, double iQuantile) {
        Collections.sort(iValues, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                Double d1 = o1.doubleValue();
                Double d2 = o2.doubleValue();
                return d1.compareTo(d2);
            }
        });
        double n = iValues.size();
        double pos = iQuantile * (n + 1.0);
        if (pos < 1.0) {
            return iValues.get(0);
        }
        if (pos >= n) {
            return iValues.get((int)n - 1);
        }
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double lower = iValues.get(intPos - 1).doubleValue();
        double upper = iValues.get(intPos).doubleValue();
        return lower + dif * (upper - lower);
    }
}

