/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.List;

public class OQueryOperatorMajorEquals
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorMajorEquals() {
        super(">=", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        Object right = OType.convert(iRight, iLeft.getClass());
        if (right == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(right) >= 0;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators() || !internalIndex.hasRangeQuerySupport()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            cursor = index.iterateEntriesMajor(key, true, ascSortOrder);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams.subList(0, keyParams.size() - 1));
            if (keyTwo == null) {
                return null;
            }
            cursor = index.iterateEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof ORID) {
                return (ORID)iRight;
            }
            if (iRight instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iRight).getValue(null, null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iRight).getValue(null, null, null);
            }
        }
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

