/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OInCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OBinaryCompareOperator operator;
    protected OSelectStatement rightStatement;
    protected OInputParameter rightParam;
    protected OMathExpression rightMathExpression;
    protected Object right;
    private static final Object UNSET = new Object();
    private Object inputFinalValue = UNSET;

    public OInCondition(int id) {
        super(id);
    }

    public OInCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord) {
        return false;
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        Object result;
        this.left.replaceParameters(params);
        if (this.rightStatement != null) {
            this.rightStatement.replaceParameters(params);
        }
        if (this.rightParam != null && this.rightParam != (result = this.rightParam.bindFromInputParams(params))) {
            this.inputFinalValue = result;
        }
        if (this.rightMathExpression != null) {
            this.rightMathExpression.replaceParameters(params);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.left.toString());
        result.append(" IN ");
        if (this.rightStatement != null) {
            result.append("(");
            result.append(this.rightStatement.toString());
            result.append(")");
        } else if (this.right != null) {
            result.append(this.convertToString(this.right));
        } else if (this.rightParam != null) {
            if (this.inputFinalValue == UNSET) {
                result.append(this.rightParam.toString());
            } else if (this.inputFinalValue == null) {
                result.append("NULL");
            } else {
                result.append(this.inputFinalValue.toString());
            }
        } else if (this.rightMathExpression != null) {
            result.append(this.rightMathExpression.toString());
        }
        return result.toString();
    }

    private String convertToString(Object o) {
        if (o instanceof String) {
            return "\"" + ((String)o).replaceAll("\"", "\\\"") + "\"";
        }
        return o.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (!this.left.supportsBasicCalculation()) {
            return false;
        }
        if (!this.rightMathExpression.supportsBasicCalculation()) {
            return false;
        }
        return this.operator.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.operator != null) {
            result.add(this);
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            result.add(this.rightMathExpression);
        }
        return result;
    }
}

