/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertSetExpression;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.List;
import java.util.Map;

public class OInsertBody
extends SimpleNode {
    protected List<OIdentifier> identifierList;
    protected List<List<OExpression>> valueExpressions;
    protected List<OInsertSetExpression> setExpressions;
    protected OSelectStatement selectStatement;
    protected boolean selectInParentheses;
    protected OJson content;
    protected OProjection returnProjection;

    public OInsertBody(int id) {
        super(id);
    }

    public OInsertBody(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void replaceParameters(Map<Object, Object> params) {
        if (this.valueExpressions != null) {
            for (List list : this.valueExpressions) {
                for (OExpression expr : list) {
                    expr.replaceParameters(params);
                }
            }
        }
        if (this.setExpressions != null) {
            for (OInsertSetExpression oInsertSetExpression : this.setExpressions) {
                oInsertSetExpression.replaceParameters(params);
            }
        }
        if (this.selectStatement != null) {
            this.selectStatement.replaceParameters(params);
        }
        if (this.content != null) {
            this.content.replaceParameters(params);
        }
        if (this.returnProjection != null) {
            this.returnProjection.replaceParameters(params);
        }
    }

    @Override
    public String toString() {
        boolean first;
        StringBuilder result = new StringBuilder();
        if (this.identifierList != null) {
            result.append("(");
            first = true;
            for (OIdentifier oIdentifier : this.identifierList) {
                if (!first) {
                    result.append(", ");
                }
                result.append(oIdentifier.toString());
                first = false;
            }
            result.append(") VALUES ");
            if (this.valueExpressions != null) {
                boolean firstList = true;
                for (List<OExpression> itemList : this.valueExpressions) {
                    if (firstList) {
                        result.append("(");
                    } else {
                        result.append("),(");
                    }
                    first = true;
                    for (OExpression item : itemList) {
                        if (!first) {
                            result.append(", ");
                        }
                        result.append(item.toString());
                        first = false;
                    }
                    firstList = false;
                }
            }
            result.append(")");
        }
        if (this.setExpressions != null) {
            result.append("SET ");
            first = true;
            for (OInsertSetExpression oInsertSetExpression : this.setExpressions) {
                if (!first) {
                    result.append(", ");
                }
                result.append(oInsertSetExpression.toString());
                first = false;
            }
        }
        if (this.selectStatement != null) {
            result.append("FROM ");
            if (this.selectInParentheses) {
                result.append("( ");
            }
            result.append(this.selectStatement.toString());
            if (this.selectInParentheses) {
                result.append(")");
            }
        }
        if (this.content != null) {
            result.append("CONTENT ");
            result.append(this.content.toString());
        }
        if (this.returnProjection != null) {
            result.append(" RETURN ");
            result.append(this.returnProjection.toString());
        }
        return result.toString();
    }
}

