/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTraverseProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OTraverseStatement
extends OStatement {
    protected List<OTraverseProjectionItem> projections = new ArrayList<OTraverseProjectionItem>();
    protected OFromClause target;
    protected OWhereClause whereClause;
    protected OLimit limit;
    protected Strategy strategy;
    protected OInteger maxDepth;

    public OTraverseStatement(int id) {
        super(id);
    }

    public OTraverseStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TRAVERSE ");
        boolean first = true;
        for (OTraverseProjectionItem item : this.projections) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(item.toString());
            first = false;
        }
        if (this.target != null) {
            builder.append(" FROM ");
            builder.append(this.target.toString());
        }
        if (this.maxDepth != null) {
            builder.append(" MAXDEPTH ");
            builder.append(this.maxDepth.toString());
        }
        if (this.whereClause != null) {
            builder.append(" WHILE ");
            builder.append(this.whereClause.toString());
        }
        if (this.limit != null) {
            builder.append(" ");
            builder.append(this.limit);
        }
        if (this.strategy != null) {
            builder.append(" strategy ");
            switch (this.strategy) {
                case BREADTH_FIRST: {
                    builder.append("breadth_first");
                    break;
                }
                case DEPTH_FIRST: {
                    builder.append("depth_first");
                }
            }
        }
        return builder.toString();
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        if (this.target != null) {
            this.target.replaceParameters(params);
        }
        if (this.projections != null) {
            for (OTraverseProjectionItem item : this.projections) {
                item.replaceParameters(params);
            }
        }
        if (this.whereClause != null) {
            this.whereClause.replaceParameters(params);
        }
        if (this.limit != null) {
            this.limit.replaceParameters(params);
        }
    }

    public static enum Strategy {
        DEPTH_FIRST,
        BREADTH_FIRST;

    }
}

