/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OResultSet<T>
implements List<T>,
Externalizable {
    protected final transient Object waitForNextItem = new Object();
    protected final transient Object waitForCompletion = new Object();
    protected List<T> underlying;
    protected volatile transient boolean completed = false;
    protected transient int limit = -1;

    public OResultSet() {
        this.underlying = Collections.synchronizedList(new ArrayList());
    }

    public OResultSet(int iCapacity) {
        this.underlying = Collections.synchronizedList(new ArrayList(iCapacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OResultSet<T> setCompleted() {
        this.completed = true;
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
        object = this.waitForCompletion;
        synchronized (object) {
            this.waitForCompletion.notifyAll();
        }
        return this;
    }

    @Override
    public T set(int index, T element) {
        return this.underlying.set(index, element);
    }

    @Override
    public int size() {
        this.waitForCompletion();
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        boolean empty = this.underlying.isEmpty();
        if (empty) {
            this.waitForCompletion();
            empty = this.underlying.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean contains(Object o) {
        this.waitForCompletion();
        return this.underlying.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (!OResultSet.this.completed) {
                    if (this.index < OResultSet.this.size()) {
                        return true;
                    }
                    OResultSet.this.waitForNewItemOrCompleted();
                }
                return this.index < OResultSet.this.size();
            }

            @Override
            public T next() {
                while (!OResultSet.this.completed && this.index >= OResultSet.this.size()) {
                    OResultSet.this.waitForNewItemOrCompleted();
                }
                if (this.index > OResultSet.this.size() || OResultSet.this.size() == 0) {
                    throw new NoSuchElementException("Error on browsing at element " + this.index + " while the resultset contains only " + OResultSet.this.size() + " items");
                }
                return OResultSet.this.underlying.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("OResultSet.iterator.remove()");
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.underlying.toArray(a);
    }

    @Override
    public boolean add(T t) {
        if (this.limit > -1 && this.underlying.size() >= this.limit) {
            return false;
        }
        boolean result = this.underlying.add(t);
        this.notifyNewItem();
        return result;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.underlying.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.underlying.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void clear() {
        this.underlying.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.underlying.equals(o);
    }

    @Override
    public int hashCode() {
        return this.underlying.hashCode();
    }

    @Override
    public T get(int index) {
        return this.underlying.get(index);
    }

    @Override
    public void add(int index, T element) {
        this.underlying.add(index, element);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("indexOf");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("lastIndexOf");
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.underlying.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.underlying.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.underlying.subList(fromIndex, toIndex);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.underlying);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.underlying = (List)in.readObject();
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCompletion() {
        Object object = this.waitForCompletion;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.waitForCompletion.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNewItemOrCompleted() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            try {
                this.waitForNextItem.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNewItem() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
    }

    public OResultSet<T> copy() {
        OResultSet<T> newValue = new OResultSet<T>();
        newValue.underlying.addAll(this.underlying);
        return newValue;
    }
}

