/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.ONewLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OWOWCacheMXBean;
import com.orientechnologies.orient.core.storage.cache.local.PageGroup;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener,
OWOWCacheMXBean {
    private final int MAX_PAGES_PER_FLUSH;
    public static final int PAGE_PADDING = 8;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP = "name_id_map.cm";
    public static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER = 4207608830L;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final long diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL.getValueAsInteger() * 1000;
    private final List<WeakReference<OLowDiskSpaceListener>> listeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(System.currentTimeMillis());
    private final String storagePath;
    private final ConcurrentSkipListMap<PagedKey, PageGroup> writeCachePages = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<PagedKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final OBinarySerializer<String> stringSerializer;
    private final Map<Integer, OFileClassic> files;
    private final boolean syncOnPageFlush;
    private final int pageSize;
    private final long groupTTL;
    private final OWriteAheadLog writeAheadLog;
    private final ODistributedCounter writeCacheSize = new ODistributedCounter();
    private final ODistributedCounter exclusiveWriteCacheSize = new ODistributedCounter();
    private final ONewLockManager<PagedKey> lockManager = new ONewLockManager();
    private final OLocalPaginatedStorage storageLocal;
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ScheduledExecutorService commitExecutor;
    private final ExecutorService lowSpaceEventsPublisher;
    private Map<String, Integer> nameIdMap;
    private RandomAccessFile nameIdMapHolder;
    private final int writeCacheMaxSize;
    private final int cacheMaxSize;
    private int fileCounter = 1;
    private PagedKey lastPageKey = new PagedKey(0, -1L);
    private PagedKey lastWritePageKey = new PagedKey(0, -1L);
    private File nameIdMapHolderFile;
    private final ODistributedCounter allocatedSpace = new ODistributedCounter();
    private final int id;
    private final AtomicReference<Date> lastFuzzyCheckpointDate = new AtomicReference();
    private final AtomicLong lastAmountOfFlushedPages = new AtomicLong();
    private final AtomicLong durationOfLastFlush = new AtomicLong();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    public static final String MBEAN_NAME = "com.orientechnologies.orient.core.storage.cache.local:type=OWOWCacheMXBean";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(boolean syncOnPageFlush, int pageSize, long groupTTL, OWriteAheadLog writeAheadLog, long pageFlushInterval, long writeCacheMaxSize, long cacheMaxSize, OLocalPaginatedStorage storageLocal, boolean checkMinSize, int id) {
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = new ConcurrentHashMap<Integer, OFileClassic>();
            this.syncOnPageFlush = syncOnPageFlush;
            this.pageSize = pageSize;
            this.groupTTL = groupTTL;
            this.writeAheadLog = writeAheadLog;
            int writeNormalizedSize = this.normalizeMemory(writeCacheMaxSize, pageSize);
            if (checkMinSize && writeNormalizedSize < 16) {
                writeNormalizedSize = 16;
            }
            int normalizedSize = this.normalizeMemory(cacheMaxSize, pageSize);
            if (checkMinSize && normalizedSize < 16) {
                normalizedSize = 16;
            }
            this.writeCacheMaxSize = writeNormalizedSize;
            this.cacheMaxSize = normalizedSize;
            this.storageLocal = storageLocal;
            this.storagePath = storageLocal.getVariableParser().resolveVariables(storageLocal.getStoragePath());
            OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
            this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
            this.commitExecutor = Executors.newSingleThreadScheduledExecutor(new FlushThreadFactory(storageLocal.getName()));
            this.lowSpaceEventsPublisher = Executors.newCachedThreadPool(new LowSpaceEventsPublisherFactory(storageLocal.getName()));
            this.MAX_PAGES_PER_FLUSH = (int)(4000.0 / (1000.0 / (double)pageFlushInterval));
            if (pageFlushInterval > 0L) {
                this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)(pageSize + 16);
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public void startFuzzyCheckpoints() {
        if (this.writeAheadLog != null) {
            long fuzzyCheckPointInterval = OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger();
            this.commitExecutor.scheduleWithFixedDelay(new PeriodicalFuzzyCheckpointTask(), fuzzyCheckPointInterval, fuzzyCheckPointInterval, TimeUnit.SECONDS);
        }
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.listeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.listeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OLowDiskSpaceListener> ref : itemsToRemove) {
            this.listeners.remove(ref);
        }
    }

    private void addAllocatedSpace(long diff) {
        if (diff == 0L) {
            return;
        }
        this.allocatedSpace.add(diff);
        long ts = System.currentTimeMillis();
        long lastSpaceCheck = this.lastDiskSpaceCheck.get();
        if (ts - lastSpaceCheck > this.diskSizeCheckInterval) {
            File storageDir = new File(this.storagePath);
            long freeSpace = storageDir.getFreeSpace();
            long effectiveFreeSpace = freeSpace - this.allocatedSpace.get();
            if (effectiveFreeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(effectiveFreeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(ts);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        this.lowSpaceEventsPublisher.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.listeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during notification of low disk space for storage " + OWOWCache.this.storageLocal.getName(), (Throwable)e, new Object[0]);
                    }
                }
                return null;
            }
        });
    }

    private static int calculatePageCrc(byte[] pageData) {
        int systemSize = 12;
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, systemSize, pageData.length - systemSize);
        return (int)crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = this.nameIdMap.get(fileName);
            if (fileId != null && fileId < 0) {
                long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                return l;
            }
            ++this.fileCounter;
            long l = OWOWCache.composeFileId(this.id, this.fileCounter);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = this.nameIdMap.get(fileName);
            OFileClassic fileClassic = fileId == null || fileId < 0 ? null : this.files.get(fileId);
            if (fileClassic == null) {
                fileClassic = this.createFile(fileName);
                if (!fileClassic.exists()) {
                    throw new OStorageException("File with name '" + fileName + "' does not exist in storage '" + this.storageLocal.getName() + "'");
                }
                OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
                if (fileId == null) {
                    ++this.fileCounter;
                    fileId = this.fileCounter;
                } else {
                    fileId = -fileId.intValue();
                }
                this.files.put(fileId, fileClassic);
                this.nameIdMap.put(fileName, fileId);
                this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            }
            this.openFile(fileClassic);
            long l = OWOWCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name '" + fileName + "' already exists in storage '" + this.storageLocal.getName() + "'");
            }
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFile(fileName);
            this.files.put(fileId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            this.addFile(fileClassic);
            long l = OWOWCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer existingFileId = this.nameIdMap.get(fileName);
            if (existingFileId != null && fileId >= 0L) {
                if (existingFileId != OWOWCache.extractFileId(fileId)) {
                    throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
                }
            } else {
                throw new OStorageException("File with name '" + fileName + "' does not exist in storage '" + this.storageLocal.getName() + "'");
            }
            OFileClassic fileClassic = this.files.get(existingFileId);
            this.openFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer existingFileId = this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageLocal.getName() + "'");
                }
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            OFileClassic fileClassic = this.files.get(intId);
            if (fileClassic != null) {
                throw new OStorageException("File with given id exists but has different name '" + fileClassic.getName() + "' vs. proposed " + fileName);
            }
            if (this.fileCounter < intId) {
                this.fileCounter = intId;
            }
            fileClassic = this.createFile(fileName);
            this.files.put(intId, fileClassic);
            this.nameIdMap.put(fileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId), true);
            this.addFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() {
        File storageDir = new File(this.storagePath);
        long freeSpace = storageDir.getFreeSpace();
        long effectiveFreeSpace = freeSpace - this.allocatedSpace.get();
        return effectiveFreeSpace < this.freeSpaceLimit;
    }

    @Override
    public void makeFuzzyCheckpoint() {
        if (this.writeAheadLog != null) {
            this.writeAheadLog.flush();
            Future<?> future = this.commitExecutor.submit(new PeriodicalFuzzyCheckpointTask());
            try {
                future.get();
            }
            catch (Exception e) {
                throw new OStorageException("Error during fuzzy checkpoint execution for storage '" + this.storageLocal.getName() + "'", e);
            }
        }
    }

    @Override
    public void lock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.lock();
        }
    }

    @Override
    public void unlock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            int intId = OWOWCache.extractFileId(fileId);
            OFileClassic fileClassic = this.files.get(intId);
            if (fileClassic == null) {
                throw new OStorageException("File with id " + fileId + " does not exist.");
            }
            this.openFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer fileId;
            if (this.nameIdMap != null && (fileId = this.nameIdMap.get(fileName)) != null && fileId >= 0) {
                boolean bl = true;
                return bl;
            }
            File file = new File(this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName));
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            OFileClassic file = this.files.get(intId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        Future<?> future = null;
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PagedKey pagedKey = new PagedKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pagedKey);
            try {
                PageGroup pageGroup = this.writeCachePages.get(pagedKey);
                if (pageGroup == null) {
                    pageGroup = new PageGroup(System.currentTimeMillis(), dataPointer);
                    this.writeCachePages.put(pagedKey, pageGroup);
                    this.writeCacheSize.increment();
                    dataPointer.setWritersListener(this);
                    dataPointer.incrementWritersReferrer();
                }
                assert (pageGroup.page.equals(dataPointer));
                pageGroup.recencyBit = true;
            }
            finally {
                this.lockManager.releaseLock(groupLock);
            }
            if (this.exclusiveWriteCacheSize.get() > (long)this.writeCacheMaxSize) {
                future = this.commitExecutor.submit(new PeriodicFlushTask());
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCachePointer load(long fileId, long pageIndex, boolean addNewPages) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageGroup pageGroup;
            Lock groupLock;
            block10: {
                OCachePointer pagePointer;
                block11: {
                    PagedKey pagedKey = new PagedKey(intId, pageIndex);
                    groupLock = this.lockManager.acquireSharedLock(pagedKey);
                    try {
                        pageGroup = this.writeCachePages.get(pagedKey);
                        if (pageGroup != null) break block10;
                        pagePointer = this.cacheFileContent(fileId, intId, pageIndex, addNewPages);
                        if (pagePointer != null) break block11;
                        OCachePointer oCachePointer = null;
                        this.lockManager.releaseLock(groupLock);
                        return oCachePointer;
                    }
                    catch (Throwable throwable) {
                        this.lockManager.releaseLock(groupLock);
                        throw throwable;
                    }
                }
                pagePointer.incrementReadersReferrer();
                OCachePointer oCachePointer = pagePointer;
                this.lockManager.releaseLock(groupLock);
                return oCachePointer;
            }
            OCachePointer pagePointer = pageGroup.page;
            pagePointer.incrementReadersReferrer();
            OCachePointer oCachePointer = pagePointer;
            this.lockManager.releaseLock(groupLock);
            return oCachePointer;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.increment();
        this.exclusiveWritePages.add(new PagedKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrement();
        this.exclusiveWritePages.remove(new PagedKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(OWOWCache.extractFileId(fileId)));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OException("File flush was interrupted", e);
        }
        catch (Exception e) {
            throw new OException("File flush was abnormally terminated", e);
        }
    }

    @Override
    public void flush() {
        Iterator<Integer> iterator = this.files.keySet().iterator();
        while (iterator.hasNext()) {
            long fileId = iterator.next().intValue();
            this.flush(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            long l = this.files.get(intId).getFileSize() / (long)this.pageSize;
            return l;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            OFileClassic fileClassic = this.files.get(intId);
            if (fileClassic != null) {
                boolean bl = fileClassic.isOpen();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long isOpen(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = this.nameIdMap.get(fileName);
            if (fileId == null || fileId < 0) {
                Long l = null;
                return l;
            }
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                Long l = null;
                return l;
            }
            Long l = OWOWCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            String name = this.doDeleteFile(intId);
            if (name != null) {
                this.nameIdMap.put(name, -intId);
                this.writeNameIdEntry(new NameFileIdEntry(name, -intId), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            if (!this.isOpen(fileId)) {
                return;
            }
            this.removeCachedPages(intId);
            this.files.get(intId).shrink(0L);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            if (!this.files.containsKey(intId)) {
                return;
            }
            OFileClassic file = this.files.get(intId);
            String osFileName = file.getName();
            if (osFileName.startsWith(oldFileName)) {
                File newFile = new File(this.storageLocal.getStoragePath() + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                boolean renamed = file.renameTo(newFile);
                while (!renamed) {
                    renamed = file.renameTo(newFile);
                }
            }
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId), true);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OException("Data flush thread was interrupted", e);
            }
        }
        this.filesLock.acquireWriteLock();
        try {
            long[] result = new long[this.files.size()];
            int counter = 0;
            for (Map.Entry<Integer, OFileClassic> fileEntry : this.files.entrySet()) {
                OFileClassic fileClassic = fileEntry.getValue();
                if (fileClassic.isOpen()) {
                    fileClassic.close();
                }
                result[counter++] = OWOWCache.composeFileId(this.id, fileEntry.getKey());
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.setLength(0L);
                for (Map.Entry<String, Integer> entry : this.nameIdMap.entrySet()) {
                    this.writeNameIdEntry(new NameFileIdEntry(entry.getKey(), entry.getValue()), false);
                }
                this.nameIdMapHolder.getFD().sync();
                this.nameIdMapHolder.close();
            }
            Iterator<Map.Entry<String, Integer>> iterator = (Iterator<Map.Entry<String, Integer>>)result;
            return iterator;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            if (!this.isOpen(intId)) {
                return;
            }
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            this.files.get(intId).close();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        this.filesLock.acquireWriteLock();
        try {
            OPageDataVerificationError[] oPageDataVerificationErrorArray = this.files.keySet().iterator();
            while (oPageDataVerificationErrorArray.hasNext()) {
                boolean fileIsCorrect;
                int fileId = oPageDataVerificationErrorArray.next();
                OFileClassic fileClassic = this.files.get(fileId);
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flush(fileId);
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFileSize();
                    fileIsCorrect = true;
                    for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not much !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if ((storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8)) != (calculatedCRC32 = OWOWCache.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file '" + fileClassic.getName() + "' is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener == null || System.currentTimeMillis() - time <= 5000L) continue;
                        time = 5000L;
                        commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed ...");
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file '" + fileClassic.getName() + "'. " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file '" + fileClassic.getName() + "' is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file '" + fileClassic.getName() + "' is successfully finished.");
            }
            oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[errors.size()]);
            return oPageDataVerificationErrorArray;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        long[] result = null;
        this.filesLock.acquireWriteLock();
        try {
            result = new long[this.files.size()];
            int counter = 0;
            for (int fileId : this.files.keySet()) {
                this.doDeleteFile(fileId);
                result[counter++] = OWOWCache.composeFileId(this.id, fileId);
            }
            if (this.nameIdMapHolderFile != null) {
                if (this.nameIdMapHolderFile.exists()) {
                    this.nameIdMapHolder.close();
                    if (!this.nameIdMapHolderFile.delete()) {
                        throw new OStorageException("Cannot delete disk cache file which contains name-id mapping.");
                    }
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderFile = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OException("Data flush thread was interrupted", e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            String string = this.files.get(intId).getName();
            return string;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName());
                server.registerMBean(this, mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new OStorageException("Error during registration of write cache MBean.", e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new OStorageException("Error during registration of write cache MBean.", e);
            }
            catch (MBeanRegistrationException e) {
                throw new OStorageException("Error during registration of write cache MBean.", e);
            }
            catch (NotCompliantMBeanException e) {
                throw new OStorageException("Error during registration of write cache MBean.", e);
            }
        }
    }

    private String getMBeanName() {
        return "com.orientechnologies.orient.core.storage.cache.local:type=OWOWCacheMXBean,name=" + ObjectName.quote(this.storageLocal.getName()) + ",id=" + this.storageLocal.getId();
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName());
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new OStorageException("Error during unregistration of write cache MBean.", e);
            }
            catch (InstanceNotFoundException e) {
                throw new OStorageException("Error during unregistration of write cache MBean.", e);
            }
            catch (MBeanRegistrationException e) {
                throw new OStorageException("Error during unregistration of write cache MBean.", e);
            }
        }
    }

    @Override
    public long getWriteCacheSize() {
        return this.writeCacheSize.get();
    }

    @Override
    public long getWriteCacheSizeInMB() {
        return this.getWriteCacheSize() / 0x100000L;
    }

    @Override
    public double getWriteCacheSizeInGB() {
        return Math.ceil((double)this.getWriteCacheSize() * 100.0 / 1.262485504E9) / 100.0;
    }

    @Override
    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    @Override
    public long getExclusiveWriteCacheSizeInMB() {
        return this.getExclusiveWriteCacheSize() / 0x100000L;
    }

    @Override
    public double getExclusiveWriteCacheSizeInGB() {
        return Math.ceil((double)this.getExclusiveWriteCacheSize() * 100.0 / 1.073741824E9) / 100.0;
    }

    @Override
    public Date getLastFuzzyCheckpointDate() {
        return this.lastFuzzyCheckpointDate.get();
    }

    @Override
    public long getLastAmountOfFlushedPages() {
        return this.lastAmountOfFlushedPages.get();
    }

    @Override
    public long getDurationOfLastFlush() {
        return this.durationOfLastFlush.get();
    }

    private void openFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File '" + fileClassic + "' does not exist.");
        }
    }

    private void addFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            throw new OStorageException("File '" + fileClassic.getName() + "' already exists.");
        }
        fileClassic.create();
        fileClassic.synch();
    }

    private void initNameIdMapping() throws IOException {
        if (this.nameIdMapHolder == null) {
            File storagePath = new File(this.storageLocal.getStoragePath());
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Cannot create directories for the path '" + storagePath + "'");
            }
            this.nameIdMapHolderFile = new File(storagePath, NAME_ID_MAP);
            this.nameIdMapHolder = new RandomAccessFile(this.nameIdMapHolderFile, "rw");
            this.readNameIdMap();
        }
    }

    private OFileClassic createFile(String fileName) {
        String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName);
        OFileClassic fileClassic = new OFileClassic(path, this.storageLocal.getMode());
        return fileClassic;
    }

    private void readNameIdMap() throws IOException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap = new ConcurrentHashMap<String, Integer>();
        long localFileCounter = -1L;
        this.nameIdMapHolder.seek(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntry()) != null) {
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
        }
        if (localFileCounter > 0L) {
            this.fileCounter = (int)localFileCounter;
        }
        for (Map.Entry<String, Integer> nameIdEntry : this.nameIdMap.entrySet()) {
            if (nameIdEntry.getValue() < 0 || this.files.containsKey(nameIdEntry.getValue())) continue;
            OFileClassic fileClassic = this.createFile(nameIdEntry.getKey());
            if (fileClassic.exists()) {
                this.files.put(nameIdEntry.getValue(), fileClassic);
                continue;
            }
            Integer fileId = this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put(nameIdEntry.getKey(), -fileId.intValue());
        }
    }

    private NameFileIdEntry readNextNameIdEntry() throws IOException {
        try {
            int nameSize = this.nameIdMapHolder.readInt();
            byte[] serializedName = new byte[nameSize];
            this.nameIdMapHolder.readFully(serializedName);
            String name = this.stringSerializer.deserialize(serializedName, 0);
            int fileId = (int)this.nameIdMapHolder.readLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.nameIdMapHolder.seek(this.nameIdMapHolder.length());
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        byte[] serializedName = new byte[nameSize];
        this.stringSerializer.serialize(nameFileIdEntry.name, serializedName, 0, new Object[0]);
        this.nameIdMapHolder.writeInt(nameSize);
        this.nameIdMapHolder.write(serializedName);
        this.nameIdMapHolder.writeLong(nameFileIdEntry.fileId);
        if (sync) {
            this.nameIdMapHolder.getFD().sync();
        }
    }

    private String doDeleteFile(int fileId) throws IOException {
        if (this.isOpen(fileId)) {
            this.truncateFile(fileId);
        }
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(int fileId) {
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OException("File data removal was interrupted", e);
        }
        catch (Exception e) {
            throw new OException("File data removal was abnormally terminated", e);
        }
    }

    private OCachePointer cacheFileContent(long fileId, int intId, long pageIndex, boolean addNewPages) throws IOException {
        OCachePointer dataPointer;
        long startPosition = pageIndex * (long)this.pageSize;
        long endPosition = startPosition + (long)this.pageSize;
        byte[] content = new byte[this.pageSize + 16];
        OFileClassic fileClassic = this.files.get(intId);
        if (fileClassic == null) {
            throw new IllegalArgumentException("File with id " + intId + " not found in WOW Cache");
        }
        OLogSequenceNumber lastLsn = this.writeAheadLog != null ? this.writeAheadLog.getFlushedLSN() : new OLogSequenceNumber(-1L, -1L);
        if (fileClassic.getFileSize() >= endPosition) {
            fileClassic.read(startPosition, content, content.length - 16, 8);
            ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
            dataPointer = new OCachePointer(pointer, lastLsn, fileId, pageIndex);
        } else if (addNewPages) {
            int space = (int)(endPosition - fileClassic.getFileSize());
            fileClassic.allocateSpace(space);
            this.addAllocatedSpace(space);
            ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
            dataPointer = new OCachePointer(pointer, lastLsn, fileId, pageIndex);
        } else {
            return null;
        }
        return dataPointer;
    }

    private void flushPage(int fileId, long pageIndex, ODirectMemoryPointer dataPointer) throws IOException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(dataPointer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLSN();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = dataPointer.get(8L, this.pageSize);
        OLongSerializer.INSTANCE.serializeNative(4207608830L, content, 0, new Object[0]);
        int crc32 = OWOWCache.calculatePageCrc(content);
        OIntegerSerializer.INSTANCE.serializeNative(crc32, content, 8, new Object[0]);
        OFileClassic fileClassic = this.files.get(fileId);
        long spaceDiff = fileClassic.write(pageIndex * (long)this.pageSize, content);
        assert (spaceDiff >= 0L);
        this.addAllocatedSpace(-spaceDiff);
        if (this.syncOnPageFlush) {
            fileClassic.synch();
        }
    }

    private static class LowSpaceEventsPublisherFactory
    implements ThreadFactory {
        private final String storageName;

        private LowSpaceEventsPublisherFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Low Disk Space Publisher (" + this.storageName + ")");
            return thread;
        }
    }

    private static class FlushThreadFactory
    implements ThreadFactory {
        private final String storageName;

        private FlushThreadFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.setName("OrientDB Write Cache Flush Task (" + this.storageName + ")");
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() throws Exception {
            PagedKey firstKey = new PagedKey(this.fileId, 0L);
            PagedKey lastKey = new PagedKey(this.fileId, Long.MAX_VALUE);
            this.removeFromRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromRing(NavigableMap<PagedKey, PageGroup> subMap) {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PagedKey pagedKey = (PagedKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pagedKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    pagePointer.acquireExclusiveLock();
                    try {
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        OWOWCache.this.writeCacheSize.decrement();
                    }
                    finally {
                        pagePointer.releaseExclusiveLock();
                    }
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final int fileId;

        private FileFlushTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() throws Exception {
            PagedKey firstKey = new PagedKey(this.fileId, 0L);
            PagedKey lastKey = new PagedKey(this.fileId, Long.MAX_VALUE);
            this.flushRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            ((OFileClassic)OWOWCache.this.files.get(this.fileId)).synch();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushRing(NavigableMap<PagedKey, PageGroup> subMap) throws IOException {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PagedKey pagedKey = (PagedKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pagedKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        OWOWCache.this.flushPage(pagedKey.fileId, pagedKey.pageIndex, pagePointer.getDataPointer());
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    OWOWCache.this.writeCacheSize.decrement();
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
        }
    }

    private final class PeriodicalFuzzyCheckpointTask
    implements Runnable {
        private PeriodicalFuzzyCheckpointTask() {
        }

        @Override
        public void run() {
            OLogSequenceNumber minLsn = OWOWCache.this.writeAheadLog.getFlushedLSN();
            minLsn = this.findMinLsn(minLsn, OWOWCache.this.writeCachePages);
            OLogManager.instance().debug((Object)this, "Start fuzzy checkpoint flushed LSN is %s", minLsn);
            try {
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointStart(minLsn);
                for (OFileClassic fileClassic : OWOWCache.this.files.values()) {
                    fileClassic.synch();
                }
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointEnd();
                OWOWCache.this.writeAheadLog.flush();
                if (minLsn.compareTo(new OLogSequenceNumber(-1L, -1L)) > 0) {
                    OWOWCache.this.writeAheadLog.cutTill(minLsn);
                }
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Error during fuzzy checkpoint", (Throwable)ioe, new Object[0]);
            }
            OLogManager.instance().debug((Object)this, "End fuzzy checkpoint", new Object[0]);
            OWOWCache.this.lastFuzzyCheckpointDate.lazySet(new Date());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OLogSequenceNumber findMinLsn(OLogSequenceNumber minLsn, ConcurrentSkipListMap<PagedKey, PageGroup> ring) {
            for (Map.Entry<PagedKey, PageGroup> entry : ring.entrySet()) {
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    PageGroup group = entry.getValue();
                    OCachePointer pagePointer = group.page;
                    if (pagePointer.getLastFlushedLsn() == null || minLsn.compareTo(pagePointer.getLastFlushedLsn()) <= 0) continue;
                    minLsn = pagePointer.getLastFlushedLsn();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
            return minLsn;
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                double cacheThreshold;
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    OWOWCache.this.lastAmountOfFlushedPages.lazySet(0L);
                    return;
                }
                int writePagesToFlush = 0;
                long wcs = OWOWCache.this.exclusiveWriteCacheSize.get();
                long cs = OWOWCache.this.writeCacheSize.get();
                boolean iterateByWritePagesFirst = false;
                boolean forceFlush = false;
                double writeCacheThreshold = (double)wcs / (double)OWOWCache.this.writeCacheMaxSize;
                if (writeCacheThreshold > 0.3) {
                    writePagesToFlush = (int)Math.floor((writeCacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    iterateByWritePagesFirst = true;
                    if (writeCacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                if ((cacheThreshold = (double)cs / (double)OWOWCache.this.cacheMaxSize) > 0.3) {
                    int pagesToFlush = (int)Math.floor((cacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    writePagesToFlush = Math.max(pagesToFlush, writePagesToFlush);
                    if (cacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                writePagesToFlush = Math.max(4, Math.min(OWOWCache.this.MAX_PAGES_PER_FLUSH, writePagesToFlush));
                int flushedPages = 0;
                if ((flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst)) < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst);
                }
                if (flushedPages < writePagesToFlush && iterateByWritePagesFirst) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, false);
                }
                if (flushedPages < writePagesToFlush && forceFlush && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, iterateByWritePagesFirst)) < writePagesToFlush && iterateByWritePagesFirst && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false)) < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false);
                }
                OWOWCache.this.lastAmountOfFlushedPages.lazySet(flushedPages);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Exception during data flush.", (Throwable)e, new Object[0]);
            }
            finally {
                long end = System.currentTimeMillis();
                OWOWCache.this.durationOfLastFlush.lazySet(end - start);
            }
        }

        private int flushRing(int writePagesToFlush, int flushedPages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException {
            NavigableMap subMap = null;
            NavigableSet<PagedKey> writePagesSubset = null;
            if (iterateByWritePagesFirst) {
                writePagesSubset = OWOWCache.this.exclusiveWritePages.tailSet(OWOWCache.this.lastWritePageKey, false);
            } else {
                subMap = OWOWCache.this.writeCachePages.tailMap(OWOWCache.this.lastPageKey, false);
            }
            flushedPages = this.iterateBySubRing(subMap, writePagesSubset, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            if (flushedPages < writePagesToFlush) {
                flushedPages = this.iterateBySubRing(OWOWCache.this.writeCachePages, OWOWCache.this.exclusiveWritePages, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            }
            return flushedPages;
        }

        private int iterateBySubRing(NavigableMap<PagedKey, PageGroup> subMap, NavigableSet<PagedKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException {
            if (!iterateByWritePagesFirst) {
                return this.iterateByCacheSubRing(subMap, writePagesToFlush, flushedWritePages, forceFlush);
            }
            return this.iterateByWritePagesSubRing(subSet, writePagesToFlush, flushedWritePages, forceFlush);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByWritePagesSubRing(NavigableSet<PagedKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException {
            Iterator<PagedKey> entriesIterator = subSet.iterator();
            long currentTime = System.currentTimeMillis();
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                PagedKey entry;
                block12: {
                    entry = entriesIterator.next();
                    if (lastPageIndex >= 0L && entry.pageIndex != lastPageIndex + 1L) {
                        ++flushedRegions;
                    }
                    if (flushedWritePages > writePagesToFlush && flushedRegions >= 4) break;
                    Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry);
                    try {
                        boolean weakLockMode;
                        PageGroup group = (PageGroup)OWOWCache.this.writeCachePages.get(entry);
                        if (group == null) {
                            entriesIterator.remove();
                            continue;
                        }
                        boolean bl = weakLockMode = group.creationTime - currentTime < OWOWCache.this.groupTTL && !forceFlush;
                        if (group.recencyBit && weakLockMode) {
                            group.recencyBit = false;
                            break block12;
                        }
                        group.recencyBit = false;
                        OCachePointer pagePointer = group.page;
                        if (!pagePointer.tryAcquireSharedLock()) continue;
                        try {
                            OWOWCache.this.flushPage(entry.fileId, entry.pageIndex, pagePointer.getDataPointer());
                            OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(pagePointer.getDataPointer());
                            pagePointer.setLastFlushedLsn(flushedLSN);
                        }
                        finally {
                            pagePointer.releaseSharedLock();
                        }
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        entriesIterator.remove();
                        OWOWCache.this.writeCachePages.remove(entry);
                    }
                    finally {
                        OWOWCache.this.lockManager.releaseLock(groupLock);
                        continue;
                    }
                }
                OWOWCache.this.lastWritePageKey = entry;
                ++flushedWritePages;
                lastPageIndex = entry.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByCacheSubRing(NavigableMap<PagedKey, PageGroup> subMap, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException {
            Iterator entriesIterator = subMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                PagedKey pagedKey;
                block10: {
                    boolean weakLockMode;
                    Map.Entry entry = entriesIterator.next();
                    PageGroup group = (PageGroup)entry.getValue();
                    pagedKey = (PagedKey)entry.getKey();
                    if (lastPageIndex >= 0L && pagedKey.pageIndex != lastPageIndex + 1L && flushedWritePages > writePagesToFlush && ++flushedRegions >= 4) break;
                    boolean bl = weakLockMode = group.creationTime - currentTime < OWOWCache.this.groupTTL && !forceFlush;
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                        continue;
                    }
                    Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                    try {
                        if (group.recencyBit && weakLockMode) {
                            group.recencyBit = false;
                            break block10;
                        }
                        group.recencyBit = false;
                        OCachePointer pagePointer = group.page;
                        if (!pagePointer.tryAcquireSharedLock()) continue;
                        try {
                            OWOWCache.this.flushPage(pagedKey.fileId, pagedKey.pageIndex, pagePointer.getDataPointer());
                            OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(pagePointer.getDataPointer());
                            pagePointer.setLastFlushedLsn(flushedLSN);
                        }
                        finally {
                            pagePointer.releaseSharedLock();
                        }
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        entriesIterator.remove();
                    }
                    finally {
                        OWOWCache.this.lockManager.releaseLock(groupLock);
                        continue;
                    }
                }
                OWOWCache.this.lastPageKey = pagedKey;
                ++flushedWritePages;
                lastPageIndex = pagedKey.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }
    }

    private static final class PagedKey
    implements Comparable<PagedKey> {
        private final int fileId;
        private final long pageIndex;

        private PagedKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PagedKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PagedKey pagedKey = (PagedKey)o;
            if (this.fileId != pagedKey.fileId) {
                return false;
            }
            return this.pageIndex == pagedKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PagedKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            return result;
        }
    }
}

