/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OClusterPage
extends ODurablePage {
    private static final int VERSION_SIZE = OVersionFactory.instance().getVersionSize();
    private static final int NEXT_PAGE_OFFSET = 28;
    private static final int PREV_PAGE_OFFSET = 36;
    private static final int FREELIST_HEADER_OFFSET = 44;
    private static final int FREE_POSITION_OFFSET = 48;
    private static final int FREE_SPACE_COUNTER_OFFSET = 52;
    private static final int ENTRIES_COUNT_OFFSET = 56;
    private static final int PAGE_INDEXES_LENGTH_OFFSET = 60;
    private static final int PAGE_INDEXES_OFFSET = 64;
    private static final int INDEX_ITEM_SIZE = 4 + VERSION_SIZE;
    private static final int MARKED_AS_DELETED_FLAG = 65536;
    private static final int POSITION_MASK = 65535;
    public static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    public static final int MAX_ENTRY_SIZE = PAGE_SIZE - 64 - INDEX_ITEM_SIZE;
    public static final int MAX_RECORD_SIZE = MAX_ENTRY_SIZE - 12;

    public OClusterPage(OCacheEntry cacheEntry, boolean newPage, OWALChangesTree changesTree) throws IOException {
        super(cacheEntry, changesTree);
        if (newPage) {
            this.setLongValue(28, -1L);
            this.setLongValue(36, -1L);
            this.setIntValue(48, PAGE_SIZE);
            this.setIntValue(52, PAGE_SIZE - 64);
        }
    }

    public int appendRecord(ORecordVersion recordVersion, byte[] record) throws IOException {
        int entryIndex;
        int freePosition = this.getIntValue(48);
        int indexesLength = this.getIntValue(60);
        int lastEntryIndexPosition = 64 + indexesLength * INDEX_ITEM_SIZE;
        int entrySize = record.length + 12;
        int freeListHeader = this.getIntValue(44);
        if (!this.checkSpace(entrySize, freeListHeader)) {
            return -1;
        }
        if (freeListHeader > 0) {
            if (freePosition - entrySize < lastEntryIndexPosition) {
                this.doDefragmentation();
            }
        } else if (freePosition - entrySize < lastEntryIndexPosition + INDEX_ITEM_SIZE) {
            this.doDefragmentation();
        }
        freePosition = this.getIntValue(48);
        freePosition -= entrySize;
        if (freeListHeader > 0) {
            entryIndex = freeListHeader - 1;
            int tombstonePointer = this.getIntValue(64 + INDEX_ITEM_SIZE * entryIndex);
            int nextEntryPosition = tombstonePointer & 0xFFFF;
            if (nextEntryPosition > 0) {
                this.setIntValue(44, nextEntryPosition);
            } else {
                this.setIntValue(44, 0);
            }
            this.setIntValue(52, this.getFreeSpace() - entrySize);
            int entryIndexPosition = 64 + entryIndex * INDEX_ITEM_SIZE;
            this.setIntValue(entryIndexPosition, freePosition);
            byte[] serializedVersion = new byte[OVersionFactory.instance().getVersionSize()];
            recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, recordVersion);
            this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
        } else {
            entryIndex = indexesLength;
            this.setIntValue(60, indexesLength + 1);
            this.setIntValue(52, this.getFreeSpace() - entrySize - INDEX_ITEM_SIZE);
            int entryIndexPosition = 64 + entryIndex * INDEX_ITEM_SIZE;
            this.setIntValue(entryIndexPosition, freePosition);
            byte[] serializedVersion = new byte[OVersionFactory.instance().getVersionSize()];
            recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, recordVersion);
            this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
        }
        int entryPosition = freePosition;
        this.setIntValue(entryPosition, entrySize);
        this.setIntValue(entryPosition += 4, entryIndex);
        this.setIntValue(entryPosition += 4, record.length);
        this.setBinaryValue(entryPosition += 4, record);
        this.setIntValue(48, freePosition);
        this.incrementEntriesCount();
        return entryIndex;
    }

    public int replaceRecord(int entryIndex, byte[] record, ORecordVersion recordVersion) throws IOException {
        int writtenBytes;
        int entryPointer;
        int entryPosition;
        int recordSize;
        int entryIndexPosition = 64 + entryIndex * INDEX_ITEM_SIZE;
        if (recordVersion != null) {
            byte[] serializedVersion = this.getBinaryValue(entryIndexPosition + 4, OVersionFactory.instance().getVersionSize());
            ORecordVersion storedRecordVersion = OVersionFactory.instance().createVersion();
            storedRecordVersion.getSerializer().fastReadFrom(serializedVersion, 0, storedRecordVersion);
            if (recordVersion.compareTo(storedRecordVersion) > 0) {
                recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, recordVersion);
                this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
            }
        }
        if (record.length <= (recordSize = this.getIntValue(entryPosition = (entryPointer = this.getIntValue(entryIndexPosition)) & 0xFFFF) - 12)) {
            this.setIntValue(entryPointer + 8, record.length);
            this.setBinaryValue(entryPointer + 12, record);
            writtenBytes = record.length;
        } else {
            byte[] newRecord = new byte[recordSize];
            System.arraycopy(record, 0, newRecord, 0, newRecord.length);
            this.setBinaryValue(entryPointer + 12, newRecord);
            writtenBytes = newRecord.length;
        }
        return writtenBytes;
    }

    public ORecordVersion getRecordVersion(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return null;
        }
        int entryIndexPosition = 64 + position * INDEX_ITEM_SIZE;
        byte[] serializedVersion = this.getBinaryValue(entryIndexPosition + 4, OVersionFactory.instance().getVersionSize());
        ORecordVersion recordVersion = OVersionFactory.instance().createVersion();
        recordVersion.getSerializer().fastReadFrom(serializedVersion, 0, recordVersion);
        return recordVersion;
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == PAGE_SIZE - 64;
    }

    private boolean checkSpace(int entrySize, int freeListHeader) {
        return !(freeListHeader > 0 ? this.getFreeSpace() - entrySize < 0 : this.getFreeSpace() - entrySize - INDEX_ITEM_SIZE < 0);
    }

    public boolean deleteRecord(int position) throws IOException {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return false;
        }
        int entryIndexPosition = 64 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) > 0) {
            return false;
        }
        int entryPosition = entryPointer & 0xFFFF;
        int freeListHeader = this.getIntValue(44);
        if (freeListHeader <= 0) {
            this.setIntValue(entryIndexPosition, 65536);
        } else {
            this.setIntValue(entryIndexPosition, freeListHeader | 0x10000);
        }
        this.setIntValue(44, position + 1);
        int entrySize = this.getIntValue(entryPosition);
        assert (entrySize > 0);
        this.setIntValue(entryPosition, -entrySize);
        this.setIntValue(52, this.getFreeSpace() + entrySize);
        this.decrementEntriesCount();
        return true;
    }

    public boolean isDeleted(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return true;
        }
        int entryIndexPosition = 64 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        return (entryPointer & 0x10000) > 0;
    }

    public int getRecordSize(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 64 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) > 0) {
            return -1;
        }
        int entryPosition = entryPointer & 0xFFFF;
        return this.getIntValue(entryPosition + 8);
    }

    public int findFirstDeletedRecord(int position) {
        int indexesLength = this.getIntValue(60);
        for (int i = position; i < indexesLength; ++i) {
            int entryIndexPosition = 64 + INDEX_ITEM_SIZE * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) <= 0) continue;
            return i;
        }
        return -1;
    }

    public int findFirstRecord(int position) {
        int indexesLength = this.getIntValue(60);
        for (int i = position; i < indexesLength; ++i) {
            int entryIndexPosition = 64 + INDEX_ITEM_SIZE * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) != 0) continue;
            return i;
        }
        return -1;
    }

    public int findLastRecord(int position) {
        int endIndex;
        int indexesLength = this.getIntValue(60);
        for (int i = endIndex = Math.min(indexesLength - 1, position); i >= 0; --i) {
            int entryIndexPosition = 64 + INDEX_ITEM_SIZE * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getFreeSpace() {
        return this.getIntValue(52);
    }

    public int getMaxRecordSize() {
        int freeListHeader = this.getIntValue(44);
        int maxEntrySize = freeListHeader > 0 ? this.getFreeSpace() : this.getFreeSpace() - INDEX_ITEM_SIZE;
        int result = maxEntrySize - 12;
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getRecordsCount() {
        return this.getIntValue(56);
    }

    public long getNextPage() {
        return this.getLongValue(28);
    }

    public void setNextPage(long nextPage) throws IOException {
        this.setLongValue(28, nextPage);
    }

    public long getPrevPage() {
        return this.getLongValue(36);
    }

    public void setPrevPage(long prevPage) throws IOException {
        this.setLongValue(36, prevPage);
    }

    public void setRecordLongValue(int recordPosition, int offset, long value) throws IOException {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * INDEX_ITEM_SIZE;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 8));
            this.setLongValue(entryPosition + offset + 12, value);
        } else {
            int recordSize = this.getIntValue(entryPosition + 8);
            assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
            this.setLongValue(entryPosition + 12 + recordSize + offset, value);
        }
    }

    public long getRecordLongValue(int recordPosition, int offset) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * INDEX_ITEM_SIZE;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 8));
            return this.getLongValue(entryPosition + offset + 12);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
        return this.getLongValue(entryPosition + 12 + recordSize + offset);
    }

    public byte[] getRecordBinaryValue(int recordPosition, int offset, int size) throws IOException {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * INDEX_ITEM_SIZE;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, size));
            return this.getBinaryValue(entryPosition + offset + 12, size);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
        return this.getBinaryValue(entryPosition + 12 + recordSize + offset, size);
    }

    public byte getRecordByteValue(int recordPosition, int offset) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * INDEX_ITEM_SIZE;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 1));
            return this.getByteValue(entryPosition + offset + 12);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 1));
        return this.getByteValue(entryPosition + 12 + recordSize + offset);
    }

    private boolean insideRecordBounds(int entryPosition, int offset, int contentSize) {
        int recordSize = this.getIntValue(entryPosition + 8);
        if (offset < 0) {
            return false;
        }
        return offset + contentSize <= recordSize;
    }

    private void incrementEntriesCount() throws IOException {
        this.setIntValue(56, this.getRecordsCount() + 1);
    }

    private void decrementEntriesCount() throws IOException {
        this.setIntValue(56, this.getRecordsCount() - 1);
    }

    private boolean isPositionInsideInterval(int recordPosition) {
        int indexesLength = this.getIntValue(60);
        return recordPosition < indexesLength;
    }

    private void doDefragmentation() throws IOException {
        int freePosition;
        int currentPosition = freePosition = this.getIntValue(48);
        ArrayList<Integer> processedPositions = new ArrayList<Integer>();
        while (currentPosition < PAGE_SIZE) {
            int entrySize = this.getIntValue(currentPosition);
            if (entrySize > 0) {
                int positionIndex = this.getIntValue(currentPosition + 4);
                processedPositions.add(positionIndex);
                currentPosition += entrySize;
                continue;
            }
            entrySize = -entrySize;
            this.moveData(freePosition, freePosition + entrySize, currentPosition - freePosition);
            currentPosition += entrySize;
            freePosition += entrySize;
            this.shiftPositions(processedPositions, entrySize);
        }
        this.setIntValue(48, freePosition);
    }

    private void shiftPositions(List<Integer> processedPositions, int entrySize) throws IOException {
        for (int positionIndex : processedPositions) {
            int entryIndexPosition = 64 + INDEX_ITEM_SIZE * positionIndex;
            int entryPosition = this.getIntValue(entryIndexPosition);
            this.setIntValue(entryIndexPosition, entryPosition + entrySize);
        }
    }
}

