/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPageDebug;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMap;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterDebug;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterState;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class OPaginatedCluster
extends ODurableComponent
implements OCluster {
    public static final String DEF_EXTENSION = ".pcl";
    private static final int DISK_PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
    private static final int LOWEST_FREELIST_BOUNDARY = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int FREE_LIST_SIZE = DISK_PAGE_SIZE - LOWEST_FREELIST_BOUNDARY;
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private final OModificationLock externalModificationLock = new OModificationLock();
    private final boolean systemCluster;
    private volatile OCompression compression;
    private OClusterPositionMap clusterPositionMap;
    private OAbstractPaginatedStorage storageLocal;
    private volatile int id;
    private long fileId;
    private OStoragePaginatedClusterConfiguration config;
    private long pinnedStateEntryIndex;
    private ORecordConflictStrategy recordConflictStrategy;

    public OPaginatedCluster(String name, OAbstractPaginatedStorage storage) {
        super(storage, name, DEF_EXTENSION);
        this.systemCluster = OMetadata.SYSTEM_CLUSTER.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, int id, String clusterName, Object ... parameters) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                OContextConfiguration ctxCfg = storage.getConfiguration().getContextConfiguration();
                String cfgCompression = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
                this.config = new OStoragePaginatedClusterConfiguration(storage.getConfiguration(), id, clusterName, null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, cfgCompression, null, OStorageClusterConfiguration.STATUS.ONLINE);
                this.config.name = clusterName;
                this.init((OAbstractPaginatedStorage)storage, this.config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.init((OAbstractPaginatedStorage)storage, config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean exists() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            boolean bl;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                bl = this.isFileExists(atomicOperation, this.getFullName());
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return bl;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int startSize) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.initCusterState(atomicOperation);
                if (this.config.root.clusters.size() <= this.config.id) {
                    this.config.root.clusters.add(this.config);
                } else {
                    this.config.root.clusters.set(this.config.id, this.config);
                }
                this.clusterPositionMap.create();
                this.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw new OStorageException("Error during creation of cluster with name " + this.getName(), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileId = this.openFile(atomicOperation, this.getFullName());
                OCacheEntry pinnedStateEntry = this.loadPage(atomicOperation, this.fileId, 0L, false);
                try {
                    this.pinPage(atomicOperation, pinnedStateEntry);
                    this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
                }
                finally {
                    this.releasePage(atomicOperation, pinnedStateEntry);
                }
                this.clusterPositionMap.open();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFile(File file) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                String newFileName = file.getName() + "$temp";
                File rootDir = new File(this.storageLocal.getConfiguration().getDirectory());
                File newFile = new File(rootDir, newFileName);
                OFileUtils.copyFile(file, newFile);
                long newFileId = this.readCache.openFile(newFileName, this.writeCache);
                this.readCache.deleteFile(this.fileId, this.writeCache);
                this.fileId = newFileId;
                this.writeCache.renameFile(this.fileId, newFileName, this.getFullName());
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean flush) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                if (flush) {
                    this.synch();
                }
                this.readCache.closeFile(this.fileId, flush, this.writeCache);
                this.clusterPositionMap.close(flush);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.clusterPositionMap.delete();
                this.endAtomicOperation(false, null);
            }
            catch (IOException ioe) {
                this.endAtomicOperation(true, ioe);
                throw ioe;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw new OStorageException("Error during deletion of cluset " + this.getName(), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = value != null ? value.toString() : null;
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                switch (attribute) {
                    case NAME: {
                        this.setNameInternal(stringValue);
                        return null;
                    }
                    case USE_WAL: {
                        this.setUseWalInternal(stringValue);
                        return null;
                    }
                    case RECORD_GROW_FACTOR: {
                        this.setRecordGrowFactorInternal(stringValue);
                        return null;
                    }
                    case RECORD_OVERFLOW_GROW_FACTOR: {
                        this.setRecordOverflowGrowFactorInternal(stringValue);
                        return null;
                    }
                    case COMPRESSION: {
                        if (this.getEntries() > 0L) {
                            throw new IllegalArgumentException("Cannot change compression setting on cluster '" + this.getName() + "' because it is not empty");
                        }
                        this.setCompressionInternal(stringValue);
                        return null;
                    }
                    case CONFLICTSTRATEGY: {
                        this.setRecordConflictStrategy(stringValue);
                        return null;
                    }
                    case STATUS: {
                        Boolean bl = this.storageLocal.setClusterStatus(this.id, OStorageClusterConfiguration.STATUS.valueOf(stringValue.toUpperCase()));
                        return bl;
                    }
                    default: {
                        throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)attribute) + " is not supported");
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean useWal() {
        this.acquireSharedLock();
        try {
            boolean bl = this.config.useWal;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isSystemCluster() {
        return this.systemCluster;
    }

    @Override
    public float recordGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordOverflowGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordOverflowGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = this.config.compression;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void convertToTombstone(long iPosition) throws IOException {
        throw new UnsupportedOperationException("convertToTombstone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OPhysicalPosition createRecord(byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        content = this.compression.compress(content);
        this.externalModificationLock.requestModificationLock();
        atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        entryContentLength = OPaginatedCluster.getEntryContentLength(content.length);
        if (entryContentLength < OClusterPage.MAX_RECORD_SIZE) {
            try {
                entryContent = new byte[entryContentLength];
                entryPosition = 0;
                entryContent[entryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(content.length, entryContent, ++entryPosition, new Object[0]);
                System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                entryContent[entryPosition += content.length] = 1;
                OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, ++entryPosition, new Object[0]);
                addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                this.updateClusterState(1L, AddEntryResult.access$000(addEntryResult), atomicOperation);
                clusterPosition = this.clusterPositionMap.add(AddEntryResult.access$100(addEntryResult), AddEntryResult.access$200(addEntryResult));
                this.endAtomicOperation(false, null);
                var11_16 = this.createPhysicalPosition(recordType, clusterPosition, AddEntryResult.access$300(addEntryResult));
                return var11_16;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw new OStorageException(null, e);
            }
        }
        ** try [egrp 5[TRYBLOCK] [3 : 221->647)] { 
lbl-1000:
        // 1 sources

        {
            entrySize = content.length + 4 + 1;
            fullEntryPosition = 0;
            fullEntry = new byte[entrySize];
            fullEntry[fullEntryPosition] = recordType;
            OIntegerSerializer.INSTANCE.serializeNative(content.length, fullEntry, ++fullEntryPosition, new Object[0]);
            System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
            prevPageRecordPointer = -1L;
            firstPageIndex = -1L;
            firstPagePosition = -1;
            version = null;
            from = 0;
            to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
            recordsSizeDiff = 0;
            do {
                entryContent = new byte[to - from + 1 + 8];
                System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                entryContent[entryContent.length - 8 - 1] = from > 0 ? 0 : 1;
                OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                recordsSizeDiff += AddEntryResult.access$000(addEntryResult);
                if (firstPageIndex == -1L) {
                    firstPageIndex = AddEntryResult.access$100(addEntryResult);
                    firstPagePosition = AddEntryResult.access$200(addEntryResult);
                    version = AddEntryResult.access$300(addEntryResult);
                }
                addedPagePointer = OPaginatedCluster.createPagePointer(AddEntryResult.access$100(addEntryResult), AddEntryResult.access$200(addEntryResult));
                if (prevPageRecordPointer >= 0L) {
                    prevPageIndex = OPaginatedCluster.getPageIndex(prevPageRecordPointer);
                    prevPageRecordPosition = OPaginatedCluster.getRecordPosition(prevPageRecordPointer);
                    prevPageCacheEntry = this.loadPage(atomicOperation, this.fileId, prevPageIndex, false);
                    prevPageCacheEntry.acquireExclusiveLock();
                    try {
                        prevPage = new OClusterPage(prevPageCacheEntry, false, this.getChangesTree(atomicOperation, prevPageCacheEntry));
                        prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                    }
                    finally {
                        prevPageCacheEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, prevPageCacheEntry);
                    }
                }
                prevPageRecordPointer = addedPagePointer;
                from = to;
                if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                to = fullEntry.length;
            } while (from < to);
            this.updateClusterState(1L, recordsSizeDiff, atomicOperation);
            clusterPosition = this.clusterPositionMap.add(firstPageIndex, firstPagePosition);
            this.endAtomicOperation(false, null);
            var20_27 = this.createPhysicalPosition(recordType, clusterPosition, version);
            return var20_27;
        }
lbl76:
        // 1 sources

        catch (Exception e) {
            this.endAtomicOperation(true, e);
            throw new OStorageException(null, e);
        }
        {
            finally {
                this.releaseExclusiveLock();
            }
        }
        {
            catch (Throwable var29_34) {
                throw var29_34;
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private static int getEntryContentLength(int grownContentSize) {
        int entryContentLength = grownContentSize + 2 + 4 + 8;
        return entryContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ORawBuffer readRecord(long clusterPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            byte[] fullContent;
            ORecordVersion recordVersion;
            block22: {
                long pageIndex;
                int recordPosition;
                OAtomicOperation atomicOperation;
                block21: {
                    OClusterPage localPage;
                    OCacheEntry cacheEntry;
                    block20: {
                        block19: {
                            OClusterPositionMapBucket.PositionEntry positionEntry;
                            block18: {
                                ORawBuffer oRawBuffer;
                                this.acquireSharedLock();
                                try {
                                    atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                                    positionEntry = this.clusterPositionMap.get(clusterPosition);
                                    if (positionEntry != null) break block18;
                                    oRawBuffer = null;
                                }
                                catch (Throwable throwable) {
                                    this.releaseSharedLock();
                                    throw throwable;
                                }
                                this.releaseSharedLock();
                                return oRawBuffer;
                            }
                            recordPosition = positionEntry.getRecordPosition();
                            pageIndex = positionEntry.getPageIndex();
                            if (this.getFilledUpTo(atomicOperation, this.fileId) > pageIndex) break block19;
                            ORawBuffer oRawBuffer = null;
                            this.releaseSharedLock();
                            return oRawBuffer;
                        }
                        recordVersion = null;
                        cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
                        localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                        if (!localPage.isDeleted(recordPosition)) break block20;
                        ORawBuffer oRawBuffer = null;
                        this.releasePage(atomicOperation, cacheEntry);
                        this.releaseSharedLock();
                        return oRawBuffer;
                    }
                    recordVersion = localPage.getRecordVersion(recordPosition);
                    break block21;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        this.releasePage(atomicOperation, cacheEntry);
                    }
                }
                fullContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition, atomicOperation);
                if (fullContent != null) break block22;
                ORawBuffer oRawBuffer = null;
                this.releaseSharedLock();
                return oRawBuffer;
            }
            int fullContentPosition = 0;
            byte recordType = fullContent[fullContentPosition];
            int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
            byte[] recordContent = this.compression.uncompress(fullContent, fullContentPosition += 4, readContentSize);
            ORawBuffer oRawBuffer = new ORawBuffer(recordContent, recordVersion, recordType);
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORawBuffer readRecordIfVersionIsNotLatest(long clusterPosition, ORecordVersion recordVersion) throws IOException, ORecordNotFoundException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            ORawBuffer oRawBuffer;
            block15: {
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
                    if (positionEntry == null) {
                        throw new ORecordNotFoundException("Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                    }
                    int recordPosition = positionEntry.getRecordPosition();
                    long pageIndex = positionEntry.getPageIndex();
                    if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
                        throw new ORecordNotFoundException("Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                    }
                    ORecordVersion loadedRecordVersion = null;
                    OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                        if (localPage.isDeleted(recordPosition)) {
                            throw new ORecordNotFoundException("Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                        }
                        loadedRecordVersion = localPage.getRecordVersion(recordPosition);
                    }
                    finally {
                        this.releasePage(atomicOperation, cacheEntry);
                    }
                    if (loadedRecordVersion.compareTo(recordVersion) <= 0) break block15;
                    oRawBuffer = this.readRecord(clusterPosition);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oRawBuffer;
            }
            oRawBuffer = null;
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteRecord(long clusterPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hideRecord(long position) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(position);
                if (positionEntry == null) {
                    this.endAtomicOperation(false, null);
                    boolean bl = false;
                    return bl;
                }
                long pageIndex = positionEntry.getPageIndex();
                if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
                    this.endAtomicOperation(false, null);
                    boolean bl = false;
                    return bl;
                }
                this.updateClusterState(-1L, 0L, atomicOperation);
                this.clusterPositionMap.remove(position);
                this.endAtomicOperation(false, null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(long clusterPosition, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        content = this.compression.compress(content);
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                int to;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
                if (positionEntry == null) {
                    this.endAtomicOperation(false, null);
                    return;
                }
                int nextRecordPosition = positionEntry.getRecordPosition();
                long nextPageIndex = positionEntry.getPageIndex();
                int newRecordPosition = -1;
                long newPageIndex = -1L;
                long prevPageIndex = -1L;
                int prevRecordPosition = -1;
                long nextEntryPointer = -1L;
                int from = 0;
                long sizeDiff = 0L;
                byte[] updateEntry = null;
                do {
                    int updatedEntryPosition;
                    int entrySize;
                    if (updateEntry == null) {
                        if (from == 0) {
                            entrySize = Math.min(OPaginatedCluster.getEntryContentLength(content.length), OClusterPage.MAX_RECORD_SIZE);
                            to = entrySize - 14;
                        } else {
                            entrySize = Math.min(content.length - from + 1 + 8, OClusterPage.MAX_RECORD_SIZE);
                            to = from + entrySize - 9;
                        }
                        updateEntry = new byte[entrySize];
                        int entryPosition = 0;
                        if (from == 0) {
                            updateEntry[entryPosition] = recordType;
                            OIntegerSerializer.INSTANCE.serializeNative(content.length, updateEntry, ++entryPosition, new Object[0]);
                            entryPosition += 4;
                        }
                        System.arraycopy(content, from, updateEntry, entryPosition, to - from);
                        entryPosition += to - from;
                        if (nextPageIndex == positionEntry.getPageIndex()) {
                            updateEntry[entryPosition] = 1;
                        }
                        OLongSerializer.INSTANCE.serializeNative(-1L, updateEntry, ++entryPosition, new Object[0]);
                        if (to < content.length) assert (entrySize == OClusterPage.MAX_RECORD_SIZE);
                    } else {
                        entrySize = updateEntry.length;
                        to = from == 0 ? entrySize - 14 : from + entrySize - 9;
                    }
                    int freePageIndex = -1;
                    if (nextPageIndex < 0L) {
                        FindFreePageResult findFreePageResult = this.findFreePage(entrySize, atomicOperation);
                        nextPageIndex = findFreePageResult.pageIndex;
                        freePageIndex = findFreePageResult.freePageIndex;
                    }
                    boolean isNew = false;
                    OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, nextPageIndex, false);
                    if (cacheEntry == null) {
                        cacheEntry = this.addPage(atomicOperation, this.fileId);
                        nextPageIndex = cacheEntry.getPageIndex();
                        isNew = true;
                    }
                    cacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, isNew, this.getChangesTree(atomicOperation, cacheEntry));
                        int pageFreeSpace = localPage.getFreeSpace();
                        if (freePageIndex < 0) {
                            freePageIndex = this.calculateFreePageIndex(localPage);
                        } else assert (isNew || freePageIndex == this.calculateFreePageIndex(localPage));
                        if (nextRecordPosition >= 0) {
                            if (localPage.isDeleted(nextRecordPosition)) {
                                throw new OStorageException("Record with rid : " + new ORecordId(this.id, clusterPosition) + " was deleted.");
                            }
                            int currentEntrySize = localPage.getRecordSize(nextRecordPosition);
                            nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, currentEntrySize - 8);
                            if (currentEntrySize == entrySize) {
                                localPage.replaceRecord(nextRecordPosition, updateEntry, recordVersion);
                                updatedEntryPosition = nextRecordPosition;
                            } else {
                                localPage.deleteRecord(nextRecordPosition);
                                updatedEntryPosition = localPage.getFreeSpace() >= entrySize ? localPage.appendRecord(recordVersion, updateEntry) : -1;
                            }
                            if (nextEntryPointer >= 0L) {
                                nextRecordPosition = OPaginatedCluster.getRecordPosition(nextEntryPointer);
                                nextPageIndex = OPaginatedCluster.getPageIndex(nextEntryPointer);
                            } else {
                                nextPageIndex = -1L;
                                nextRecordPosition = -1;
                            }
                        } else {
                            assert (localPage.getFreeSpace() >= entrySize);
                            updatedEntryPosition = localPage.appendRecord(recordVersion, updateEntry);
                            assert (updatedEntryPosition >= 0);
                            nextPageIndex = -1L;
                            nextRecordPosition = -1;
                        }
                        sizeDiff += (long)(pageFreeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        cacheEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePageIndex, cacheEntry.getPageIndex(), atomicOperation);
                    if (updatedEntryPosition < 0) continue;
                    if (from == 0) {
                        newPageIndex = cacheEntry.getPageIndex();
                        newRecordPosition = updatedEntryPosition;
                    }
                    from = to;
                    if (prevPageIndex >= 0L) {
                        OCacheEntry prevCacheEntry = this.loadPage(atomicOperation, this.fileId, prevPageIndex, false);
                        prevCacheEntry.acquireExclusiveLock();
                        try {
                            OClusterPage prevPage = new OClusterPage(prevCacheEntry, false, this.getChangesTree(atomicOperation, prevCacheEntry));
                            prevPage.setRecordLongValue(prevRecordPosition, -8, OPaginatedCluster.createPagePointer(cacheEntry.getPageIndex(), updatedEntryPosition));
                        }
                        finally {
                            prevCacheEntry.releaseExclusiveLock();
                            this.releasePage(atomicOperation, prevCacheEntry);
                        }
                    }
                    prevPageIndex = cacheEntry.getPageIndex();
                    prevRecordPosition = updatedEntryPosition;
                    updateEntry = null;
                } while (to < content.length || updateEntry != null);
                while (nextEntryPointer >= 0L) {
                    int freePagesIndex;
                    nextPageIndex = OPaginatedCluster.getPageIndex(nextEntryPointer);
                    nextRecordPosition = OPaginatedCluster.getRecordPosition(nextEntryPointer);
                    OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, nextPageIndex, false);
                    cacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                        int freeSpace = localPage.getFreeSpace();
                        freePagesIndex = this.calculateFreePageIndex(localPage);
                        nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, -8);
                        localPage.deleteRecord(nextRecordPosition);
                        sizeDiff += (long)(freeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        cacheEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePagesIndex, nextPageIndex, atomicOperation);
                }
                assert (newPageIndex >= 0L);
                assert (newRecordPosition >= 0);
                if (newPageIndex != positionEntry.getPageIndex() || newRecordPosition != positionEntry.getRecordPosition()) {
                    this.clusterPositionMap.update(clusterPosition, new OClusterPositionMapBucket.PositionEntry(newPageIndex, newRecordPosition));
                }
                this.updateClusterState(0L, sizeDiff, atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw new OStorageException("Error during record update.", e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public boolean hasTombstonesSupport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws IOException {
        this.storageLocal.checkForClusterPermissions(this.getName());
        this.externalModificationLock.requestModificationLock();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation();
            this.acquireExclusiveLock();
            try {
                this.truncateFile(atomicOperation, this.fileId);
                this.clusterPositionMap.truncate();
                this.initCusterState(atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw new OStorageException(null, e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long getFirstPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                l = this.clusterPositionMap.getFirstPosition();
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public long getLastPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                l = this.clusterPositionMap.getLastPosition();
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public String getFileName() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            String string;
            this.acquireSharedLock();
            try {
                string = this.writeCache.fileNameById(this.fileId);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return string;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getFileId() {
        return this.fileId;
    }

    @Override
    public void synch() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.writeCache.flush(this.fileId);
                this.clusterPositionMap.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getRecordsSize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OClusterEntryIterator oClusterEntryIterator;
            this.acquireSharedLock();
            try {
                oClusterEntryIterator = new OClusterEntryIterator(this);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oClusterEntryIterator;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.higherPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.ceilingPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.lowerPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                long[] clusterPositions = this.clusterPositionMap.floorPositions(position.clusterPosition);
                oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public OModificationLock getExternalModificationLock() {
        return this.externalModificationLock;
    }

    @Override
    public ORecordConflictStrategy getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    private void setRecordConflictStrategy(String stringValue) {
        this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(stringValue);
        this.config.conflictStrategy = stringValue;
        this.storageLocal.getConfiguration().update();
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, !this.config.useWal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterState(long sizeDiff, long recordsSizeDiff, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry, this.getChangesTree(atomicOperation, pinnedStateEntry));
            paginatedClusterState.setSize(paginatedClusterState.getSize() + sizeDiff);
            paginatedClusterState.setRecordsSize(paginatedClusterState.getRecordsSize() + recordsSizeDiff);
        }
        finally {
            pinnedStateEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, pinnedStateEntry);
        }
    }

    private void init(OAbstractPaginatedStorage storage, OStorageClusterConfiguration config) throws IOException {
        OFileUtils.checkValidName(config.getName());
        this.config = (OStoragePaginatedClusterConfiguration)config;
        this.compression = OCompressionFactory.INSTANCE.getCompression(this.config.compression);
        if (((OStoragePaginatedClusterConfiguration)config).conflictStrategy != null) {
            this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(((OStoragePaginatedClusterConfiguration)config).conflictStrategy);
        }
        this.storageLocal = storage;
        this.id = config.getId();
        this.clusterPositionMap = new OClusterPositionMap(storage, this.getName(), this.config.useWal);
    }

    private void setCompressionInternal(String stringValue) {
        try {
            this.compression = OCompressionFactory.INSTANCE.getCompression(stringValue);
            this.config.compression = stringValue;
            this.storageLocal.getConfiguration().update();
        }
        catch (IllegalArgumentException e) {
            throw new OStorageException("Invalid value for " + (Object)((Object)OCluster.ATTRIBUTES.COMPRESSION) + " attribute. ", e);
        }
    }

    private void setRecordOverflowGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " cannot be less than 1");
            }
            this.config.recordOverflowGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setRecordGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " cannot be less than 1");
            }
            this.config.recordGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setUseWalInternal(String stringValue) {
        if (!stringValue.equals("true") && !stringValue.equals("false")) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.USE_WAL) + " was passed [" + stringValue + "].");
        }
        this.config.useWal = Boolean.valueOf(stringValue);
        this.clusterPositionMap.setUseWal(this.config.useWal);
        this.storageLocal.getConfiguration().update();
    }

    private void setNameInternal(String newName) throws IOException {
        this.writeCache.renameFile(this.fileId, this.getFullName(), newName + this.getExtension());
        this.clusterPositionMap.rename(newName);
        this.config.name = newName;
        this.storageLocal.renameCluster(this.getName(), newName);
        this.setName(newName);
        this.storageLocal.getConfiguration().update();
    }

    private OPhysicalPosition createPhysicalPosition(byte recordType, long clusterPosition, ORecordVersion version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.clusterPosition = clusterPosition;
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFullEntry(long clusterPosition, long pageIndex, int recordPosition, OAtomicOperation atomicOperation) throws IOException {
        byte[] fullContent;
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            return null;
        }
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>();
        int contentSize = 0;
        long nextPagePointer = -1L;
        boolean firstEntry = true;
        do {
            OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                if (localPage.isDeleted(recordPosition)) {
                    if (recordChunks.isEmpty()) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    throw new OStorageException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken.");
                }
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, localPage.getRecordSize(recordPosition));
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePage(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedCluster.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedCluster.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        if (recordChunks.size() == 1) {
            fullContent = (byte[])recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    private static long createPagePointer(long pageIndex, int pagePosition) {
        return pageIndex << 16 | (long)pagePosition;
    }

    private static int getRecordPosition(long nextPagePointer) {
        return (int)(nextPagePointer & 0xFFFFL);
    }

    private static long getPageIndex(long nextPagePointer) {
        return nextPagePointer >>> 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddEntryResult addEntry(ORecordVersion recordVersion, byte[] entryContent, OAtomicOperation atomicOperation) throws IOException {
        int recordSizesDiff;
        ORecordVersion finalVersion;
        int position;
        FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, atomicOperation);
        int freePageIndex = findFreePageResult.freePageIndex;
        long pageIndex = findFreePageResult.pageIndex;
        boolean newRecord = freePageIndex >= FREE_LIST_SIZE;
        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
        if (cacheEntry == null) {
            cacheEntry = this.addPage(atomicOperation, this.fileId);
        }
        cacheEntry.acquireExclusiveLock();
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, newRecord, this.getChangesTree(atomicOperation, cacheEntry));
            assert (newRecord || freePageIndex == this.calculateFreePageIndex(localPage));
            int initialFreeSpace = localPage.getFreeSpace();
            position = localPage.appendRecord(recordVersion, entryContent);
            assert (position >= 0);
            finalVersion = localPage.getRecordVersion(position);
            int freeSpace = localPage.getFreeSpace();
            recordSizesDiff = initialFreeSpace - freeSpace;
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, cacheEntry);
        }
        this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        return new AddEntryResult(pageIndex, position, finalVersion, recordSizesDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindFreePageResult findFreePage(int contentSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        try {
            long pageIndex;
            int freePageIndex;
            while (true) {
                int realFreePageIndex;
                freePageIndex = contentSize / 1024;
                if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
                    freePageIndex = 0;
                }
                OPaginatedClusterState freePageLists = new OPaginatedClusterState(pinnedStateEntry, this.getChangesTree(atomicOperation, pinnedStateEntry));
                while ((pageIndex = freePageLists.getFreeListPage(freePageIndex)) < 0L && ++freePageIndex < FREE_LIST_SIZE) {
                }
                if (pageIndex < 0L) {
                    pageIndex = this.getFilledUpTo(atomicOperation, this.fileId);
                } else {
                    --freePageIndex;
                }
                if (freePageIndex >= FREE_LIST_SIZE) break;
                OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
                try {
                    OClusterPage localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                    realFreePageIndex = this.calculateFreePageIndex(localPage);
                }
                finally {
                    this.releasePage(atomicOperation, cacheEntry);
                }
                if (realFreePageIndex == freePageIndex) break;
                OLogManager.instance().warn((Object)this, "Page in file %s with index %d was placed in wrong free list, this error will be fixed automatically.", this.getFullName(), pageIndex);
                this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
            }
            FindFreePageResult findFreePageResult = new FindFreePageResult(pageIndex, freePageIndex);
            return findFreePageResult;
        }
        finally {
            this.releasePage(atomicOperation, pinnedStateEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        block29: {
            OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
            cacheEntry.acquireExclusiveLock();
            try {
                long oldFreePage;
                OClusterPage localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                int newFreePageIndex = this.calculateFreePageIndex(localPage);
                if (prevFreePageIndex == newFreePageIndex) {
                    return;
                }
                long nextPageIndex = localPage.getNextPage();
                long prevPageIndex = localPage.getPrevPage();
                if (prevPageIndex >= 0L) {
                    OCacheEntry prevPageCacheEntry = this.loadPage(atomicOperation, this.fileId, prevPageIndex, false);
                    prevPageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, this.getChangesTree(atomicOperation, prevPageCacheEntry));
                        assert (this.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                        prevPage.setNextPage(nextPageIndex);
                    }
                    finally {
                        prevPageCacheEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, prevPageCacheEntry);
                    }
                }
                if (nextPageIndex >= 0L) {
                    OCacheEntry nextPageCacheEntry = this.loadPage(atomicOperation, this.fileId, nextPageIndex, false);
                    nextPageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage nextPage = new OClusterPage(nextPageCacheEntry, false, this.getChangesTree(atomicOperation, nextPageCacheEntry));
                        if (this.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                            this.calculateFreePageIndex(nextPage);
                        }
                        assert (this.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                        nextPage.setPrevPage(prevPageIndex);
                    }
                    finally {
                        nextPageCacheEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, nextPageCacheEntry);
                    }
                }
                localPage.setNextPage(-1L);
                localPage.setPrevPage(-1L);
                if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                    return;
                }
                if (prevFreePageIndex >= 0 && prevFreePageIndex < FREE_LIST_SIZE && prevPageIndex < 0L) {
                    this.updateFreePagesList(prevFreePageIndex, nextPageIndex, atomicOperation);
                }
                if (newFreePageIndex < 0) break block29;
                OCacheEntry pinnedStateEntry = this.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
                try {
                    OPaginatedClusterState clusterFreeList = new OPaginatedClusterState(pinnedStateEntry, this.getChangesTree(atomicOperation, pinnedStateEntry));
                    oldFreePage = clusterFreeList.getFreeListPage(newFreePageIndex);
                }
                finally {
                    this.releasePage(atomicOperation, pinnedStateEntry);
                }
                if (oldFreePage >= 0L) {
                    OCacheEntry oldFreePageCacheEntry = this.loadPage(atomicOperation, this.fileId, oldFreePage, false);
                    oldFreePageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage oldFreeLocalPage = new OClusterPage(oldFreePageCacheEntry, false, this.getChangesTree(atomicOperation, oldFreePageCacheEntry));
                        assert (this.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                    }
                    finally {
                        oldFreePageCacheEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, oldFreePageCacheEntry);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex, atomicOperation);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesList(int freeListIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPage(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry, this.getChangesTree(atomicOperation, pinnedStateEntry));
            paginatedClusterState.setFreeListPage(freeListIndex, pageIndex);
        }
        finally {
            pinnedStateEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, pinnedStateEntry);
        }
    }

    private int calculateFreePageIndex(OClusterPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = FREE_LIST_SIZE - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= LOWEST_FREELIST_BOUNDARY;
        }
        return newFreePageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCusterState(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.addPage(atomicOperation, this.fileId);
        pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry, this.getChangesTree(atomicOperation, pinnedStateEntry));
            this.pinPage(atomicOperation, pinnedStateEntry);
            paginatedClusterState.setSize(0L);
            paginatedClusterState.setRecordsSize(0L);
            for (int i = 0; i < FREE_LIST_SIZE; ++i) {
                paginatedClusterState.setFreeListPage(i, -1L);
            }
            this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
        }
        finally {
            pinnedStateEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, pinnedStateEntry);
        }
    }

    private OPhysicalPosition[] convertToPhysicalPositions(long[] clusterPositions) {
        OPhysicalPosition[] positions = new OPhysicalPosition[clusterPositions.length];
        for (int i = 0; i < positions.length; ++i) {
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.clusterPosition = clusterPositions[i];
            positions[i] = physicalPosition;
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPaginatedClusterDebug readDebug(long clusterPosition) throws IOException {
        OPaginatedClusterDebug debug = new OPaginatedClusterDebug();
        debug.clusterPosition = clusterPosition;
        debug.fileId = this.fileId;
        OAtomicOperation atomicOperation = null;
        OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
        if (positionEntry == null) {
            debug.empty = true;
            return debug;
        }
        long pageIndex = positionEntry.getPageIndex();
        int recordPosition = positionEntry.getRecordPosition();
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            debug.empty = true;
            return debug;
        }
        debug.pages = new ArrayList<OClusterPageDebug>();
        int contentSize = 0;
        long nextPagePointer = -1L;
        boolean firstEntry = true;
        do {
            OClusterPageDebug debugPage = new OClusterPageDebug();
            debugPage.pageIndex = pageIndex;
            OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false, this.getChangesTree(atomicOperation, cacheEntry));
                if (localPage.isDeleted(recordPosition)) {
                    if (debug.pages.isEmpty()) {
                        debug.empty = true;
                        OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                        return oPaginatedClusterDebug;
                    }
                    throw new OStorageException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken.");
                }
                debugPage.inPagePosition = recordPosition;
                debugPage.inPageSize = localPage.getRecordSize(recordPosition);
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, debugPage.inPageSize);
                debugPage.content = content;
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    debug.empty = true;
                    OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                    return oPaginatedClusterDebug;
                }
                debug.pages.add(debugPage);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePage(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedCluster.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedCluster.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        debug.contentSize = contentSize;
        return debug;
    }

    public String toString() {
        return "plocal cluster: " + this.getName();
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;

        private FindFreePageResult(long pageIndex, int freePageIndex) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
        }
    }

    private static final class AddEntryResult {
        private final long pageIndex;
        private final int pagePosition;
        private final ORecordVersion recordVersion;
        private final int recordsSizeDiff;

        public AddEntryResult(long pageIndex, int pagePosition, ORecordVersion recordVersion, int recordsSizeDiff) {
            this.pageIndex = pageIndex;
            this.pagePosition = pagePosition;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }

        static /* synthetic */ int access$000(AddEntryResult x0) {
            return x0.recordsSizeDiff;
        }

        static /* synthetic */ long access$100(AddEntryResult x0) {
            return x0.pageIndex;
        }

        static /* synthetic */ int access$200(AddEntryResult x0) {
            return x0.pagePosition;
        }

        static /* synthetic */ ORecordVersion access$300(AddEntryResult x0) {
            return x0.recordVersion;
        }
    }
}

