/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public abstract class ODurableComponent
extends OSharedResourceAdaptive {
    protected final OAtomicOperationsManager atomicOperationsManager;
    protected final OAbstractPaginatedStorage storage;
    protected final OReadCache readCache;
    protected final OWriteCache writeCache;
    private volatile String name;
    private volatile String fullName;
    protected final String extension;

    public ODurableComponent(OAbstractPaginatedStorage storage, String name, String extension) {
        super(true);
        assert (name != null);
        this.extension = extension;
        this.storage = storage;
        this.fullName = name + extension;
        this.name = name;
        this.atomicOperationsManager = storage.getAtomicOperationsManager();
        this.readCache = storage.getReadCache();
        this.writeCache = storage.getWriteCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fullName = name + this.extension;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    protected void acquireExclusiveLock() {
        super.acquireExclusiveLock();
    }

    protected void endAtomicOperation(boolean rollback, Exception e) throws IOException {
        this.atomicOperationsManager.endAtomicOperation(rollback, e);
    }

    protected OAtomicOperation startAtomicOperation() throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, false);
    }

    protected OWALChangesTree getChangesTree(OAtomicOperation atomicOperation, OCacheEntry entry) {
        if (atomicOperation == null) {
            return null;
        }
        return atomicOperation.getChangesTree(entry.getFileId(), entry.getPageIndex());
    }

    protected long getFilledUpTo(OAtomicOperation atomicOperation, long fileId) throws IOException {
        if (atomicOperation == null) {
            return this.writeCache.getFilledUpTo(fileId);
        }
        return atomicOperation.filledUpTo(fileId);
    }

    protected OCacheEntry loadPage(OAtomicOperation atomicOperation, long fileId, long pageIndex, boolean checkPinnedPages) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.load(fileId, pageIndex, checkPinnedPages, this.writeCache);
        }
        return atomicOperation.loadPage(fileId, pageIndex, checkPinnedPages);
    }

    protected void pinPage(OAtomicOperation atomicOperation, OCacheEntry cacheEntry) throws IOException {
        if (atomicOperation == null) {
            this.readCache.pinPage(cacheEntry);
        } else {
            atomicOperation.pinPage(cacheEntry);
        }
    }

    protected OCacheEntry addPage(OAtomicOperation atomicOperation, long fileId) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.allocateNewPage(fileId, this.writeCache);
        }
        return atomicOperation.addPage(fileId);
    }

    protected void releasePage(OAtomicOperation atomicOperation, OCacheEntry cacheEntry) {
        if (atomicOperation == null) {
            this.readCache.release(cacheEntry, this.writeCache);
        } else {
            atomicOperation.releasePage(cacheEntry);
        }
    }

    protected long addFile(OAtomicOperation atomicOperation, String fileName) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.addFile(fileName, this.writeCache);
        }
        return atomicOperation.addFile(fileName);
    }

    protected long openFile(OAtomicOperation atomicOperation, String fileName) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.openFile(fileName, this.writeCache);
        }
        return atomicOperation.openFile(fileName);
    }

    protected void openFile(OAtomicOperation atomicOperation, long fileId) throws IOException {
        if (atomicOperation == null) {
            this.readCache.openFile(fileId, this.writeCache);
        } else {
            atomicOperation.openFile(fileId);
        }
    }

    protected void deleteFile(OAtomicOperation atomicOperation, long fileId) throws IOException {
        if (atomicOperation == null) {
            this.readCache.deleteFile(fileId, this.writeCache);
        } else {
            atomicOperation.deleteFile(fileId);
        }
    }

    protected boolean isFileExists(OAtomicOperation atomicOperation, String fileName) {
        if (atomicOperation == null) {
            return this.writeCache.exists(fileName);
        }
        return atomicOperation.isFileExists(fileName);
    }

    protected boolean isFileExists(OAtomicOperation atomicOperation, long fileId) {
        if (atomicOperation == null) {
            return this.writeCache.exists(fileId);
        }
        return atomicOperation.isFileExists(fileId);
    }

    protected String fileNameById(OAtomicOperation atomicOperation, long fileId) {
        if (atomicOperation == null) {
            return this.writeCache.fileNameById(fileId);
        }
        return atomicOperation.fileNameById(fileId);
    }

    protected void truncateFile(OAtomicOperation atomicOperation, long filedId) throws IOException {
        if (atomicOperation == null) {
            this.readCache.truncateFile(filedId, this.writeCache);
        } else {
            atomicOperation.truncateFile(filedId);
        }
    }
}

