/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;

public class OUpdatePageRecord
extends OAbstractPageWALRecord {
    private OWALChangesTree changesTree;

    public OUpdatePageRecord() {
    }

    public OUpdatePageRecord(long pageIndex, long fileId, OOperationUnitId operationUnitId, OWALChangesTree changesTree, OLogSequenceNumber startLsn) {
        super(pageIndex, fileId, operationUnitId, startLsn);
        this.changesTree = changesTree;
    }

    public OWALChangesTree getChanges() {
        return this.changesTree;
    }

    @Override
    public int serializedSize() {
        int serializedSize = super.serializedSize();
        return serializedSize += this.changesTree.serializedSize();
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        offset = this.changesTree.toStream(offset, content);
        return offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.changesTree = new OWALChangesTree();
        offset = this.changesTree.fromStream(offset, content);
        return offset;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OUpdatePageRecord that = (OUpdatePageRecord)o;
        if (this.lsn == null && that.lsn == null) {
            return true;
        }
        if (this.lsn == null) {
            return false;
        }
        if (that.lsn == null) {
            return false;
        }
        return this.lsn.equals(that.lsn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lsn.hashCode();
        return result;
    }
}

