/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageMemoryConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OMemoryWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.memory.ODirectMemoryOnlyDiskCache;
import com.orientechnologies.orient.core.version.OSimpleVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ODirectMemoryStorage
extends OAbstractPaginatedStorage {
    private static final int ONE_KB = 1024;

    public ODirectMemoryStorage(String name, String filePath, String mode, int id) {
        super(name, filePath, mode, id);
        this.configuration = new OStorageMemoryConfiguration(this);
    }

    @Override
    protected void initWalAndDiskCache() throws IOException {
        if (this.configuration.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.USE_WAL)) {
            if (this.writeAheadLog == null) {
                this.writeAheadLog = new OMemoryWriteAheadLog();
            }
        } else {
            this.writeAheadLog = null;
        }
        ODirectMemoryOnlyDiskCache diskCache = new ODirectMemoryOnlyDiskCache(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, 1);
        if (this.readCache == null) {
            this.readCache = diskCache;
        }
        if (this.writeCache == null) {
            this.writeCache = diskCache;
        }
    }

    @Override
    protected void postCreateSteps() {
        ORecordId recordId = new ORecordId();
        recordId.clusterId = 0;
        this.createRecord(recordId, OCommonConst.EMPTY_BYTE_ARRAY, new OSimpleVersion(), (byte)98, ODatabase.OPERATION_MODE.SYNCHRONOUS.ordinal(), null);
    }

    @Override
    public boolean exists() {
        return this.readCache != null && this.writeCache.exists("default.pcl");
    }

    @Override
    public String getType() {
        return "memory";
    }

    @Override
    public String getURL() {
        return "memory:" + this.url;
    }

    @Override
    public void makeFullCheckpoint() throws IOException {
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException();
    }
}

