/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProviderAbstract;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDProvider;
import java.io.IOException;
import java.util.Arrays;

public class OMVRBTreeRIDEntryProvider
extends OMVRBTreeEntryDataProviderAbstract<OIdentifiable, OIdentifiable> {
    private static final long serialVersionUID = 1L;
    protected static final int OFFSET_TREESIZE = 0;
    protected static final int OFFSET_NODESIZE = 4;
    protected static final int OFFSET_COLOR = 8;
    protected static final int OFFSET_PARENT = 9;
    protected static final int OFFSET_LEFT = 19;
    protected static final int OFFSET_RIGHT = 29;
    protected static final int OFFSET_RIDLIST = 39;
    private int treeSize;
    private final OIdentifiable[] rids;

    public OMVRBTreeRIDEntryProvider(OMVRBTreeRIDProvider iTreeDataProvider) {
        super(iTreeDataProvider, 39 + iTreeDataProvider.getDefaultPageSize() * 10);
        this.rids = OGlobalConfiguration.MVRBTREE_RID_NODE_SAVE_MEMORY.getValueAsBoolean() ? null : new OIdentifiable[this.pageSize];
    }

    public OMVRBTreeRIDEntryProvider(OMVRBTreeRIDProvider iTreeDataProvider, ORID iRID) {
        super(iTreeDataProvider, iRID);
        this.pageSize = this.treeDataProvider.getDefaultPageSize();
        this.rids = OGlobalConfiguration.MVRBTREE_RID_NODE_SAVE_MEMORY.getValueAsBoolean() ? null : new OIdentifiable[this.pageSize];
    }

    @Override
    public OIdentifiable getKeyAt(int iIndex) {
        if (this.rids != null && this.rids[iIndex] != null) {
            return this.rids[iIndex];
        }
        ORecordId rid = this.itemFromStream(iIndex);
        if (this.rids != null) {
            this.rids[iIndex] = rid;
        }
        return rid;
    }

    @Override
    public OIdentifiable getValueAt(int iIndex) {
        return this.getKeyAt(iIndex);
    }

    @Override
    public boolean setValueAt(int iIndex, OIdentifiable iValue) {
        if (iValue == null) {
            return false;
        }
        try {
            this.itemToStream(iValue, iIndex);
        }
        catch (IOException e) {
            throw new OSerializationException("Cannot serialize entryRID object: " + this, e);
        }
        if (this.rids != null) {
            this.rids[iIndex] = iValue;
        }
        return this.setDirty();
    }

    @Override
    public boolean insertAt(int iIndex, OIdentifiable iKey, OIdentifiable iValue) {
        if (iIndex < this.size) {
            this.stream.move(this.getKeyPositionInStream(iIndex), 10);
            if (this.rids != null) {
                System.arraycopy(this.rids, iIndex, this.rids, iIndex + 1, this.size - iIndex - 1);
            }
        }
        try {
            this.itemToStream(iKey, iIndex);
        }
        catch (IOException e) {
            throw new OSerializationException("Cannot serialize entryRID object: " + this, e);
        }
        if (this.rids != null) {
            this.rids[iIndex] = iKey;
        }
        ++this.size;
        return this.setDirty();
    }

    @Override
    public boolean removeAt(int iIndex) {
        if (iIndex > -1 && iIndex < this.size - 1) {
            this.stream.move(this.getKeyPositionInStream(iIndex + 1), -10);
            if (this.rids != null) {
                System.arraycopy(this.rids, iIndex + 1, this.rids, iIndex, this.size - iIndex - 1);
            }
        }
        --this.size;
        if (this.rids != null) {
            this.rids[this.size] = null;
        }
        return this.setDirty();
    }

    @Override
    public boolean copyDataFrom(OMVRBTreeEntryDataProvider<OIdentifiable, OIdentifiable> iFrom, int iStartPosition) {
        this.size = iFrom.getSize() - iStartPosition;
        OMVRBTreeRIDEntryProvider from = (OMVRBTreeRIDEntryProvider)iFrom;
        this.moveToIndex(0).copyFrom(from.moveToIndex(iStartPosition), this.size * 10);
        if (this.rids != null) {
            System.arraycopy(from.rids, iStartPosition, this.rids, 0, this.size);
        }
        return this.setDirty();
    }

    @Override
    public boolean truncate(int iNewSize) {
        this.moveToIndex(iNewSize).fill((this.size - iNewSize) * 10, (byte)0);
        if (this.rids != null) {
            Arrays.fill(this.rids, iNewSize, this.size, null);
        }
        this.size = iNewSize;
        return this.setDirty();
    }

    @Override
    public boolean copyFrom(OMVRBTreeEntryDataProvider<OIdentifiable, OIdentifiable> iSource) {
        OMVRBTreeRIDEntryProvider source = (OMVRBTreeRIDEntryProvider)iSource;
        this.stream = source.stream;
        this.size = source.size;
        return this.setDirty();
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        if (this.stream == null) {
            this.stream = new OMemoryStream(iStream);
        } else {
            this.stream.setSource(iStream);
        }
        this.treeSize = this.stream.jump(0).getAsInteger();
        this.size = this.stream.jump(4).getAsInteger();
        this.color = this.stream.jump(8).getAsBoolean();
        this.parentRid.fromStream(this.stream.jump(9));
        this.leftRid.fromStream(this.stream.jump(19));
        this.rightRid.fromStream(this.stream.jump(29));
        if (this.rids != null) {
            Arrays.fill(this.rids, null);
        }
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        if (this.stream == null) {
            this.stream = new OMemoryStream();
        }
        try {
            this.stream.jump(0).set(this.treeSize);
            this.stream.jump(4).set(this.size);
            this.stream.jump(8).set(this.color);
            this.parentRid.toStream(this.stream.jump(9));
            this.leftRid.toStream(this.stream.jump(19));
            this.rightRid.toStream(this.stream.jump(29));
            if (this.rids != null) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.rids[i] == null) continue;
                    this.itemToStream(this.rids[i], i);
                }
            }
        }
        catch (IOException e) {
            throw new OSerializationException("Cannot serialize tree entry RID node: " + this, e);
        }
        byte[] buffer = this.stream.getInternalBuffer();
        this.record.fromStream(buffer);
        return buffer;
    }

    protected OMemoryStream moveToIndex(int iIndex) {
        return this.stream.jump(this.getKeyPositionInStream(iIndex));
    }

    protected int getKeyPositionInStream(int iIndex) {
        return 39 + iIndex * 10;
    }

    public int getTreeSize() {
        return this.treeSize;
    }

    public boolean setTreeSize(int treeSize) {
        if (this.treeSize != treeSize) {
            this.treeSize = treeSize;
            this.setDirty();
            return true;
        }
        return false;
    }

    protected ORecordId itemFromStream(int iIndex) {
        return new ORecordId().fromStream(this.moveToIndex(iIndex));
    }

    protected int itemToStream(OIdentifiable iKey, int iIndex) throws IOException {
        return iKey.getIdentity().toStream(this.moveToIndex(iIndex));
    }
}

