/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class OSocketFactory {
    SocketFactory socketFactory;
    boolean useSSL = false;
    SSLContext context = null;
    OContextConfiguration config;
    private String keyStorePath = null;
    private String keyStorePassword = null;
    private String keyStoreType = KeyStore.getDefaultType();
    private String trustStorePath = null;
    private String trustStorePassword = null;
    private String trustStoreType = KeyStore.getDefaultType();

    private OSocketFactory(OContextConfiguration iConfig) {
        this.config = iConfig;
        this.useSSL = iConfig.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL);
        this.keyStorePath = (String)iConfig.getValue(OGlobalConfiguration.CLIENT_SSL_KEYSTORE);
        this.keyStorePassword = (String)iConfig.getValue(OGlobalConfiguration.CLIENT_SSL_KEYSTORE_PASSWORD);
        this.trustStorePath = (String)iConfig.getValue(OGlobalConfiguration.CLIENT_SSL_TRUSTSTORE);
        this.trustStorePassword = (String)iConfig.getValue(OGlobalConfiguration.CLIENT_SSL_TRUSTSTORE_PASSWORD);
    }

    public static OSocketFactory instance(OContextConfiguration iConfig) {
        return new OSocketFactory(iConfig);
    }

    private SocketFactory getBackingFactory() {
        if (this.socketFactory == null) {
            this.socketFactory = this.useSSL ? this.getSSLContext().getSocketFactory() : SocketFactory.getDefault();
        }
        return this.socketFactory;
    }

    protected SSLContext getSSLContext() {
        if (this.context == null) {
            this.context = this.createSSLContext();
        }
        return this.context;
    }

    protected SSLContext createSSLContext() {
        try {
            if (this.keyStorePath != null && this.trustStorePath != null) {
                if (this.keyStorePassword == null || this.keyStorePassword.equals("")) {
                    throw new OConfigurationException("Please provide a keystore password");
                }
                if (this.trustStorePassword == null || this.trustStorePassword.equals("")) {
                    throw new OConfigurationException("Please provide a truststore password");
                }
                SSLContext context = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                char[] keyStorePass = this.keyStorePassword.toCharArray();
                keyStore.load(this.getAsStream(this.keyStorePath), keyStorePass);
                kmf.init(keyStore, keyStorePass);
                TrustManagerFactory tmf = null;
                if (this.trustStorePath != null) {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                    char[] trustStorePass = this.trustStorePassword.toCharArray();
                    trustStore.load(this.getAsStream(this.trustStorePath), trustStorePass);
                    tmf.init(trustStore);
                }
                context.init(kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), null);
                return context;
            }
            return SSLContext.getDefault();
        }
        catch (Exception e) {
            throw new OConfigurationException("Failed to create ssl context", e);
        }
    }

    protected InputStream getAsStream(String path) throws IOException {
        InputStream input = null;
        try {
            URL url = new URL(path);
            input = url.openStream();
        }
        catch (MalformedURLException ignore) {
            input = null;
        }
        if (input == null) {
            input = this.getClass().getResourceAsStream(path);
        }
        if (input == null) {
            input = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        if (input == null) {
            try {
                input = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                input = null;
            }
        }
        if (input == null) {
            throw new IOException("Could not load resource from path: " + path);
        }
        return input;
    }

    private Socket configureSocket(Socket socket) throws SocketException {
        return socket;
    }

    public Socket createSocket() throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.configureSocket(this.getBackingFactory().createSocket(host, port));
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket(host, port));
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.configureSocket(this.getBackingFactory().createSocket(host, port, localHost, localPort));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket(address, port, localAddress, localPort));
    }
}

