/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRetryAbstract;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLCreateEdge
extends OCommandExecutorSQLRetryAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "CREATE EDGE";
    private static final String KEYWORD_BATCH = "BATCH";
    private String from;
    private String to;
    private OClass clazz;
    private String clusterName;
    private List<OPair<String, Object>> fields;
    private int batch = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateEdge parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLCreateEdge.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword("CREATE");
            this.parserRequiredKeyword("EDGE");
            String className = null;
            String temp = this.parseOptionalWord(true, new String[0]);
            while (temp != null) {
                if (temp.equals("CLUSTER")) {
                    this.clusterName = this.parserRequiredWord(false);
                } else if (temp.equals("FROM")) {
                    this.from = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                } else if (temp.equals("TO")) {
                    this.to = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                } else if (temp.equals("SET")) {
                    this.fields = new ArrayList<OPair<String, Object>>();
                    this.parseSetFields(this.clazz, this.fields);
                } else if (temp.equals("CONTENT")) {
                    this.parseContent();
                } else if (temp.equals("RETRY")) {
                    this.parseRetry();
                } else if (temp.equals(KEYWORD_BATCH)) {
                    temp = this.parserNextWord(true);
                    if (temp != null) {
                        this.batch = Integer.parseInt(temp);
                    }
                } else if (className == null && temp.length() > 0) {
                    className = temp;
                    this.clazz = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot().getClass(className);
                }
                temp = this.parseOptionalWord(true, new String[0]);
                if (!this.parserIsEnded()) continue;
            }
            if (className == null) {
                className = "E";
                this.clazz = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot().getClass(className);
            }
            if (this.clazz == null) {
                throw new OCommandSQLParsingException("Class '" + className + "' was not found");
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(final Map<Object, Object> iArgs) {
        if (this.clazz == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        return OGraphCommandExecutorSQLFactory.runInTx(new OGraphCommandExecutorSQLFactory.GraphCallBack<List<Object>>(){

            @Override
            public List<Object> call(OrientBaseGraph graph) {
                Set<OIdentifiable> fromIds = OSQLEngine.getInstance().parseRIDTarget(graph.getRawGraph(), OCommandExecutorSQLCreateEdge.this.from, OCommandExecutorSQLCreateEdge.this.context, iArgs);
                Set<OIdentifiable> toIds = OSQLEngine.getInstance().parseRIDTarget(graph.getRawGraph(), OCommandExecutorSQLCreateEdge.this.to, OCommandExecutorSQLCreateEdge.this.context, iArgs);
                ArrayList<Object> edges = new ArrayList<Object>();
                for (OIdentifiable from : fromIds) {
                    OrientVertex fromVertex = graph.getVertex(from);
                    if (fromVertex == null) {
                        throw new OCommandExecutionException("Source vertex '" + from + "' not exists");
                    }
                    for (OIdentifiable to : toIds) {
                        OrientVertex toVertex = from.equals(to) ? fromVertex : graph.getVertex(to);
                        String clsName = OCommandExecutorSQLCreateEdge.this.clazz.getName();
                        if (OCommandExecutorSQLCreateEdge.this.fields != null) {
                            for (OPair f : OCommandExecutorSQLCreateEdge.this.fields) {
                                if (!(f.getValue() instanceof OSQLFunctionRuntime)) continue;
                                f.setValue(((OSQLFunctionRuntime)f.getValue()).getValue(to, null, OCommandExecutorSQLCreateEdge.this.context));
                            }
                        }
                        OrientEdge edge = null;
                        for (int r = 0; r < OCommandExecutorSQLCreateEdge.this.retry; ++r) {
                            try {
                                if (OCommandExecutorSQLCreateEdge.this.content != null) {
                                    if (OCommandExecutorSQLCreateEdge.this.fields != null) {
                                        OCommandExecutorSQLCreateEdge.this.fields.addAll(OPair.convertFromMap(OCommandExecutorSQLCreateEdge.this.content.toMap()));
                                    } else {
                                        OCommandExecutorSQLCreateEdge.this.fields = OPair.convertFromMap(OCommandExecutorSQLCreateEdge.this.content.toMap());
                                    }
                                }
                                edge = fromVertex.addEdge(null, toVertex, clsName, OCommandExecutorSQLCreateEdge.this.clusterName, OCommandExecutorSQLCreateEdge.this.fields);
                                if (OCommandExecutorSQLCreateEdge.this.fields != null && !OCommandExecutorSQLCreateEdge.this.fields.isEmpty()) {
                                    if (edge.isLightweight()) {
                                        edge.convertToDocument();
                                    }
                                    OSQLHelper.bindParameters(edge.getRecord(), OCommandExecutorSQLCreateEdge.this.fields, new OCommandParameters(iArgs), OCommandExecutorSQLCreateEdge.this.context);
                                }
                                edge.save(OCommandExecutorSQLCreateEdge.this.clusterName);
                                break;
                            }
                            catch (OConcurrentModificationException e) {
                                if (r + 1 >= OCommandExecutorSQLCreateEdge.this.retry) {
                                    throw e;
                                }
                                if (OCommandExecutorSQLCreateEdge.this.wait > 0) {
                                    try {
                                        Thread.sleep(OCommandExecutorSQLCreateEdge.this.wait);
                                    }
                                    catch (InterruptedException e1) {
                                        OLogManager.instance().error((Object)this, "Wait was interrupted.", new Object[0]);
                                    }
                                }
                                fromVertex.getRecord().reload(null, true);
                                toVertex.getRecord().reload(null, true);
                                continue;
                            }
                        }
                        edges.add(edge);
                        if (OCommandExecutorSQLCreateEdge.this.batch <= 0 || edges.size() % OCommandExecutorSQLCreateEdge.this.batch != 0) continue;
                        graph.commit();
                        ((OrientGraph)graph).begin();
                    }
                }
                if (edges.isEmpty()) {
                    if (fromIds.isEmpty()) {
                        throw new OCommandExecutionException("No edge has been created because no source vertices");
                    }
                    if (toIds.isEmpty()) {
                        throw new OCommandExecutionException("No edge has been created because no target vertices");
                    }
                    throw new OCommandExecutionException("No edge has been created between " + fromIds + " and " + toIds);
                }
                return edges;
            }
        });
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        if (this.clazz != null) {
            return Collections.singleton(OCommandExecutorSQLCreateEdge.getDatabase().getClusterNameById(this.clazz.getClusterSelection().getCluster(this.clazz, null)));
        }
        if (this.clusterName != null) {
            return this.getInvolvedClustersOfClusters(Collections.singleton(this.clusterName));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    @Override
    public String getSyntax() {
        return "CREATE EDGE [<class>] [CLUSTER <cluster>] FROM <rid>|(<query>|[<rid>]*) TO <rid>|(<query>|[<rid>]*) [SET <field> = <expression>[,]*]|CONTENT {<JSON>} [RETRY <retry> [WAIT <pauseBetweenRetriesInMs]] [BATCH <batch-size>]";
    }
}

