/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSQLFunctionShortestPath
extends OSQLFunctionMathAbstract {
    public static final String NAME = "shortestPath";
    protected static final float DISTANCE = 1.0f;

    public OSQLFunctionShortestPath() {
        super(NAME, 2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ORID> execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
        try {
            ORecord record = iCurrentRecord != null ? (ORecord)iCurrentRecord.getRecord() : null;
            OShortestPathContext ctx = new OShortestPathContext();
            Object source = iParams[0];
            if (OMultiValue.isMultiValue(source)) {
                if (OMultiValue.getSize(source) > 1) {
                    throw new IllegalArgumentException("Only one sourceVertex is allowed");
                }
                source = OMultiValue.getFirstValue(source);
            }
            ctx.sourceVertex = graph.getVertex(OSQLHelper.getValue(source, record, iContext));
            Object dest = iParams[1];
            if (OMultiValue.isMultiValue(dest)) {
                if (OMultiValue.getSize(dest) > 1) {
                    throw new IllegalArgumentException("Only one destinationVertex is allowed");
                }
                dest = OMultiValue.getFirstValue(dest);
            }
            ctx.destinationVertex = graph.getVertex(OSQLHelper.getValue(dest, record, iContext));
            if (ctx.sourceVertex.equals(ctx.destinationVertex)) {
                ArrayList<ORID> result = new ArrayList<ORID>(1);
                result.add(ctx.destinationVertex.getIdentity());
                ArrayList<ORID> arrayList = result;
                return arrayList;
            }
            if (iParams.length > 2 && iParams[2] != null) {
                ctx.directionLeft = Direction.valueOf(iParams[2].toString().toUpperCase());
            }
            if (ctx.directionLeft == Direction.OUT) {
                ctx.directionRight = Direction.IN;
            } else if (ctx.directionLeft == Direction.IN) {
                ctx.directionRight = Direction.OUT;
            }
            ctx.edgeType = null;
            if (iParams.length > 3) {
                ctx.edgeType = iParams[3] == null ? null : "" + iParams[3];
            }
            ctx.edgeTypeParam = new String[]{ctx.edgeType};
            ctx.queueLeft.add(ctx.sourceVertex);
            ctx.leftVisited.add(ctx.sourceVertex.getIdentity());
            ctx.queueRight.add(ctx.destinationVertex);
            ctx.rightVisited.add(ctx.destinationVertex.getIdentity());
            while (!ctx.queueLeft.isEmpty() && !ctx.queueRight.isEmpty()) {
                List<ORID> neighborIdentity;
                if (Thread.interrupted()) {
                    throw new OCommandExecutionException("The shortestPath() function has been interrupted");
                }
                if (!OCommandExecutorAbstract.checkInterruption(iContext)) break;
                if (ctx.queueLeft.size() <= ctx.queueRight.size()) {
                    neighborIdentity = this.walkLeft(ctx);
                    if (neighborIdentity != null) {
                        List<ORID> list = neighborIdentity;
                        return list;
                    }
                    if (ctx.queueLeft.isEmpty()) break;
                    neighborIdentity = this.walkRight(ctx);
                    if (neighborIdentity == null) continue;
                    List<ORID> list = neighborIdentity;
                    return list;
                }
                neighborIdentity = this.walkRight(ctx);
                if (neighborIdentity != null) {
                    List<ORID> list = neighborIdentity;
                    return list;
                }
                if (ctx.queueRight.isEmpty()) break;
                neighborIdentity = this.walkLeft(ctx);
                if (neighborIdentity == null) continue;
                List<ORID> list = neighborIdentity;
                return list;
            }
            ArrayList<ORID> arrayList = new ArrayList<ORID>();
            return arrayList;
        }
        finally {
            if (shutdownFlag.getValue()) {
                graph.shutdown(false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
        }
    }

    @Override
    public String getSyntax() {
        return "shortestPath(<sourceVertex>, <destinationVertex>, [<direction>, [ <edgeTypeAsString> ]])";
    }

    protected List<ORID> walkLeft(OShortestPathContext ctx) {
        ArrayDeque<OrientVertex> nextLevelQueue = new ArrayDeque<OrientVertex>();
        while (!ctx.queueLeft.isEmpty()) {
            ctx.current = ctx.queueLeft.poll();
            Iterable<Vertex> neighbors = ctx.edgeType == null ? ctx.current.getVertices(ctx.directionLeft, new String[0]) : ctx.current.getVertices(ctx.directionLeft, ctx.edgeTypeParam);
            for (Vertex neighbor : neighbors) {
                OrientVertex v = (OrientVertex)neighbor;
                ORID neighborIdentity = v.getIdentity();
                if (ctx.rightVisited.contains(neighborIdentity)) {
                    ctx.previouses.put(neighborIdentity, ctx.current.getIdentity());
                    return this.computePath(ctx.previouses, ctx.nexts, neighborIdentity);
                }
                if (ctx.leftVisited.contains(neighborIdentity)) continue;
                ctx.previouses.put(neighborIdentity, ctx.current.getIdentity());
                nextLevelQueue.offer(v);
                ctx.leftVisited.add(neighborIdentity);
            }
        }
        ctx.queueLeft = nextLevelQueue;
        return null;
    }

    protected List<ORID> walkRight(OShortestPathContext ctx) {
        ArrayDeque<OrientVertex> nextLevelQueue = new ArrayDeque<OrientVertex>();
        while (!ctx.queueRight.isEmpty()) {
            ctx.currentRight = ctx.queueRight.poll();
            Iterable<Vertex> neighbors = ctx.edgeType == null ? ctx.currentRight.getVertices(ctx.directionRight, new String[0]) : ctx.currentRight.getVertices(ctx.directionRight, ctx.edgeTypeParam);
            for (Vertex neighbor : neighbors) {
                OrientVertex v = (OrientVertex)neighbor;
                ORID neighborIdentity = v.getIdentity();
                if (ctx.leftVisited.contains(neighborIdentity)) {
                    ctx.nexts.put(neighborIdentity, ctx.currentRight.getIdentity());
                    return this.computePath(ctx.previouses, ctx.nexts, neighborIdentity);
                }
                if (ctx.rightVisited.contains(neighborIdentity)) continue;
                ctx.nexts.put(neighborIdentity, ctx.currentRight.getIdentity());
                nextLevelQueue.offer(v);
                ctx.rightVisited.add(neighborIdentity);
            }
        }
        ctx.queueRight = nextLevelQueue;
        return null;
    }

    private List<ORID> computePath(Map<ORID, ORID> leftDistances, Map<ORID, ORID> rightDistances, ORID neighbor) {
        ArrayList<ORID> result = new ArrayList<ORID>();
        ORID current = neighbor;
        while (current != null) {
            result.add(0, current);
            current = leftDistances.get(current);
        }
        current = neighbor;
        while (current != null) {
            if ((current = rightDistances.get(current)) == null) continue;
            result.add(current);
        }
        return result;
    }

    private class OShortestPathContext {
        OrientVertex sourceVertex;
        OrientVertex destinationVertex;
        Direction directionLeft = Direction.BOTH;
        Direction directionRight = Direction.BOTH;
        String edgeType;
        String[] edgeTypeParam;
        ArrayDeque<OrientVertex> queueLeft = new ArrayDeque();
        ArrayDeque<OrientVertex> queueRight = new ArrayDeque();
        final Set<ORID> leftVisited = new HashSet<ORID>();
        final Set<ORID> rightVisited = new HashSet<ORID>();
        final Map<ORID, ORID> previouses = new HashMap<ORID, ORID>();
        final Map<ORID, ORID> nexts = new HashMap<ORID, ORID>();
        OrientVertex current;
        OrientVertex currentRight;

        private OShortestPathContext() {
        }
    }
}

