/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import java.util.ArrayList;
import java.util.Collection;

public class OCommandSQLPojoWrapper
implements OCommandRequest {
    private OCommandRequest command;
    private ODatabasePojoAbstract<?> database;

    public OCommandSQLPojoWrapper(ODatabasePojoAbstract<?> iDatabase, OCommandRequest iCommand) {
        this.database = iDatabase;
        this.command = iCommand;
    }

    @Override
    public <RET> RET execute(Object ... iArgs) {
        this.database.convertParameters(iArgs);
        Object result = this.command.execute(iArgs);
        if (result instanceof Collection) {
            ArrayList<ODocument> resultPojo = new ArrayList<ODocument>();
            Collection coll = (Collection)result;
            for (ODocument doc : coll) {
                ODocument obj = doc.getClassName() == null ? doc : this.database.getUserObjectByRecord(doc, this.getFetchPlan(), true);
                resultPojo.add(obj);
            }
            result = resultPojo;
        } else if (result instanceof ODocument && ((ODocument)result).getClassName() != null) {
            result = this.database.getUserObjectByRecord((ODocument)result, this.getFetchPlan(), true);
        }
        return result;
    }

    @Override
    public int getLimit() {
        return this.command.getLimit();
    }

    @Override
    public OCommandRequest setLimit(int iLimit) {
        this.command.setLimit(iLimit);
        return this;
    }

    @Override
    public boolean isIdempotent() {
        return this.command.isIdempotent();
    }

    @Override
    public String getFetchPlan() {
        return this.command.getFetchPlan();
    }

    @Override
    public <RET extends OCommandRequest> RET setFetchPlan(String iFetchPlan) {
        this.command.setFetchPlan(iFetchPlan);
        return null;
    }

    @Override
    public void setUseCache(boolean iUseCache) {
        this.command.setUseCache(iUseCache);
    }

    @Override
    public OCommandContext getContext() {
        return this.command.getContext();
    }

    @Override
    public OCommandRequest setContext(OCommandContext iContext) {
        this.command.setContext(iContext);
        return this;
    }

    @Override
    public long getTimeoutTime() {
        return this.command.getTimeoutTime();
    }

    @Override
    public OCommandContext.TIMEOUT_STRATEGY getTimeoutStrategy() {
        return this.command.getTimeoutStrategy();
    }

    @Override
    public void setTimeout(long timeout, OCommandContext.TIMEOUT_STRATEGY strategy) {
        this.command.setTimeout(timeout, strategy);
    }
}

