/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class OClientConnectionManager {
    protected ConcurrentMap<Integer, OClientConnection> connections = new ConcurrentHashMap<Integer, OClientConnection>();
    protected AtomicInteger connectionSerial = new AtomicInteger(0);

    public OClientConnectionManager() {
        int delay = OGlobalConfiguration.SERVER_CHANNEL_CLEAN_DELAY.getValueAsInteger();
        Orient.instance().scheduleTask(new TimerTask(){

            @Override
            public void run() {
                OClientConnectionManager.this.cleanExpiredConnections();
            }
        }, delay, (long)delay);
        Orient.instance().getProfiler().registerHookValue("server.connections.actives", "Number of active network connections", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return OClientConnectionManager.this.connections.size();
            }
        });
    }

    public void cleanExpiredConnections() {
        Iterator iterator = this.connections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Socket socket = ((OClientConnection)entry.getValue()).protocol == null || ((OClientConnection)entry.getValue()).protocol.getChannel() == null ? null : ((OClientConnection)entry.getValue()).protocol.getChannel().socket;
            if (socket != null && !socket.isClosed() && !socket.isInputShutdown()) continue;
            OLogManager.instance().debug((Object)this, "[OClientConnectionManager] found and removed pending closed channel %d (%s)", entry.getKey(), socket);
            try {
                OCommandRequestText command = ((OClientConnection)entry.getValue()).data.command;
                if (command != null && command.isIdempotent()) {
                    ((OClientConnection)entry.getValue()).protocol.sendShutdown();
                    ((OClientConnection)entry.getValue()).protocol.interrupt();
                }
                ((OClientConnection)entry.getValue()).close();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during close of connection for close channel", (Throwable)e, new Object[0]);
            }
            iterator.remove();
        }
    }

    public OClientConnection connect(ONetworkProtocol iProtocol) throws IOException {
        OClientConnection connection = new OClientConnection(this.connectionSerial.incrementAndGet(), iProtocol);
        this.connections.put(connection.id, connection);
        OLogManager.instance().config(this, "Remote client connected from: " + connection, new Object[0]);
        return connection;
    }

    public OClientConnection getConnection(int iChannelId, ONetworkProtocol protocol) {
        OClientConnection connection = (OClientConnection)this.connections.get(iChannelId);
        if (connection != null) {
            connection.protocol = protocol;
        }
        return connection;
    }

    public OClientConnection getConnection(String iAddress) {
        for (OClientConnection conn : this.connections.values()) {
            if (!iAddress.equals(conn.getRemoteAddress())) continue;
            return conn;
        }
        return null;
    }

    public void kill(int iChannelId) {
        this.kill((OClientConnection)this.connections.get(iChannelId));
    }

    public void kill(OClientConnection connection) {
        if (connection != null) {
            ONetworkProtocol protocol = connection.protocol;
            try {
                protocol.interrupt();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during interruption of binary protocol.", (Throwable)e, new Object[0]);
            }
            this.disconnect(connection);
            protocol.sendShutdown();
        }
    }

    public boolean has(int id) {
        return this.connections.containsKey(id);
    }

    public void interrupt(int iChannelId) {
        ONetworkProtocol protocol;
        OClientConnection connection = (OClientConnection)this.connections.get(iChannelId);
        if (connection != null && (protocol = connection.protocol) != null) {
            protocol.interruptCurrentOperation();
        }
    }

    public boolean disconnect(int iChannelId) {
        OLogManager.instance().debug((Object)this, "Disconnecting connection with id=%d", iChannelId);
        OClientConnection connection = (OClientConnection)this.connections.remove(iChannelId);
        if (connection != null) {
            connection.close();
            for (Map.Entry entry : this.connections.entrySet()) {
                if (!((OClientConnection)entry.getValue()).getProtocol().equals(connection.getProtocol())) continue;
                OLogManager.instance().debug((Object)this, "Disconnected connection with id=%d but are present other active channels", iChannelId);
                return false;
            }
            OLogManager.instance().debug((Object)this, "Disconnected connection with id=%d, no other active channels found", iChannelId);
            return true;
        }
        OLogManager.instance().debug((Object)this, "Cannot find connection with id=%d", iChannelId);
        return false;
    }

    public void disconnect(OClientConnection iConnection) {
        OLogManager.instance().debug((Object)this, "Disconnecting connection %s...", iConnection);
        iConnection.close();
        int totalRemoved = 0;
        for (Map.Entry<Integer, OClientConnection> entry : new HashMap<Integer, OClientConnection>(this.connections).entrySet()) {
            OClientConnection conn = entry.getValue();
            if (conn == null || !conn.equals(iConnection)) continue;
            this.connections.remove(entry.getKey());
            ++totalRemoved;
        }
        OLogManager.instance().debug((Object)this, "Disconnected connection %s found %d channels", iConnection, totalRemoved);
    }

    public List<OClientConnection> getConnections() {
        return new ArrayList<OClientConnection>(this.connections.values());
    }

    public int getTotal() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDistribCfg2Clients(ODocument iConfig) {
        if (iConfig == null) {
            return;
        }
        HashSet<String> pushed = new HashSet<String>();
        for (OClientConnection c : this.connections.values()) {
            try {
                String remoteAddress = c.getRemoteAddress();
                if (pushed.contains(remoteAddress)) {
                }
            }
            catch (Exception e) {}
            continue;
            if (!(c.protocol instanceof ONetworkProtocolBinary) || c.data.serializationImpl == null) continue;
            ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.protocol;
            OChannelBinary channel = (OChannelBinary)p.getChannel();
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(c.data.serializationImpl);
            if (ser == null) {
                return;
            }
            byte[] content = ser.toStream(iConfig, false);
            try {
                channel.acquireWriteLock();
                try {
                    channel.writeByte((byte)3);
                    channel.writeInt(Integer.MIN_VALUE);
                    channel.writeByte((byte)80);
                    channel.writeBytes(content);
                    channel.flush();
                    pushed.add(c.getRemoteAddress());
                    OLogManager.instance().info((Object)this, "Sent updated cluster configuration to the remote client %s", c.getRemoteAddress());
                }
                finally {
                    channel.releaseWriteLock();
                }
            }
            catch (IOException e) {
                this.disconnect(c);
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Cannot push cluster configuration to the client %s", e, c.getRemoteAddress());
                this.disconnect(c);
            }
        }
    }

    public void shutdown() {
        for (Map.Entry entry : this.connections.entrySet()) {
            ONetworkProtocol protocol = ((OClientConnection)entry.getValue()).protocol;
            protocol.sendShutdown();
            OCommandRequestText command = ((OClientConnection)entry.getValue()).data.command;
            if (command != null && command.isIdempotent()) {
                protocol.interrupt();
                continue;
            }
            if (protocol instanceof ONetworkProtocolBinary && ((ONetworkProtocolBinary)protocol).getRequestType() == 1) continue;
            try {
                Socket socket = protocol == null || protocol.getChannel() == null ? null : protocol.getChannel().socket;
                if (socket != null && !socket.isClosed() && !socket.isInputShutdown()) {
                    try {
                        socket.shutdownInput();
                    }
                    catch (IOException e) {
                        OLogManager.instance().debug((Object)this, "Error on closing connection of %s client during shutdown", (Throwable)e, ((OClientConnection)entry.getValue()).getRemoteAddress());
                    }
                }
                if (!protocol.isAlive()) continue;
                if (protocol instanceof ONetworkProtocolBinary && ((ONetworkProtocolBinary)protocol).getRequestType() == -1) {
                    try {
                        protocol.getChannel().close();
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Error during chanel close at shutdown", (Throwable)e, new Object[0]);
                    }
                    protocol.interrupt();
                }
                protocol.join();
            }
            catch (InterruptedException e) {}
        }
    }

    public void killAllChannels() {
        for (Map.Entry entry : this.connections.entrySet()) {
            try {
                ONetworkProtocol protocol = ((OClientConnection)entry.getValue()).protocol;
                protocol.getChannel().close();
                Socket socket = protocol == null || protocol.getChannel() == null ? null : protocol.getChannel().socket;
                if (socket == null || socket.isClosed() || socket.isInputShutdown()) continue;
                socket.shutdownInput();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on killing connection to %s client", (Throwable)e, ((OClientConnection)entry.getValue()).getRemoteAddress());
            }
        }
    }
}

