/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.TimerTask;

public class ORestartNodeTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;

    @Override
    public Object execute(final OServer iServer, final ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "restarting server...", new Object[0]);
        Orient.instance().scheduleTask(new TimerTask(){

            @Override
            public void run() {
                try {
                    iServer.restart();
                }
                catch (Exception e) {
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), ORestartNodeTask.this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "error on restarting server", e, new Object[0]);
                }
            }
        }, 1L, 0L);
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public String getName() {
        return "unjoin_node";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

