/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public abstract class OrientElement
implements Element,
OSerializableStream,
Externalizable,
OIdentifiable {
    public static final String LABEL_FIELD_NAME = "label";
    public static final Object DEF_ORIGINAL_ID_FIELDNAME = "origId";
    private static final long serialVersionUID = 1L;
    protected boolean classicDetachMode = false;
    protected transient OrientConfigurableGraph.Settings settings;
    protected OIdentifiable rawElement;
    private transient OrientBaseGraph graph;

    protected OrientElement(OrientBaseGraph rawGraph, OIdentifiable iRawElement) {
        this.graph = this.classicDetachMode ? rawGraph : null;
        this.rawElement = iRawElement;
        OrientBaseGraph graph = this.getGraph();
        if (graph != null) {
            this.settings = graph.settings;
        }
    }

    public abstract String getLabel();

    public abstract String getBaseClassName();

    public abstract String getElementType();

    @Override
    public void remove() {
        this.checkIfAttached();
        OrientBaseGraph graph = this.getGraph();
        graph.setCurrentGraphInThreadLocal();
        graph.autoStartTransaction();
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The elements " + this.getIdentity() + " has already been deleted");
        }
        try {
            this.getRecord().load();
        }
        catch (ORecordNotFoundException e) {
            throw new IllegalStateException("The elements " + this.getIdentity() + " has already been deleted", e);
        }
        this.getRecord().delete();
    }

    protected boolean checkDeletedInTx() {
        OrientBaseGraph curGraph = this.getGraph();
        if (curGraph == null) {
            return false;
        }
        if (this.getRecord() == null) {
            return false;
        }
        ORID id = this.getRecord().getIdentity();
        ORecordOperation oper = curGraph.getRawGraph().getTransaction().getRecordEntry(id);
        if (oper == null) {
            return id.isTemporary();
        }
        return oper.type == 2;
    }

    public <T extends OrientElement> T setProperties(Object ... fields) {
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        this.setPropertiesInternal(fields);
        this.save();
        return (T)this;
    }

    public Map<String, Object> getProperties() {
        if (this.rawElement == null) {
            return null;
        }
        ODocument raw = (ODocument)this.rawElement.getRecord();
        if (raw == null) {
            return null;
        }
        return raw.toMap();
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        this.validateProperty(this, key, value);
        OrientBaseGraph graph = this.getGraph();
        if (graph != null) {
            graph.autoStartTransaction();
        }
        this.getRecord().field(key, value);
        if (graph != null) {
            this.save();
        }
    }

    public void setProperty(String key, Object value, OType iType) {
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        this.validateProperty(this, key, value);
        OrientBaseGraph graph = this.getGraph();
        if (graph != null) {
            graph.autoStartTransaction();
        }
        this.getRecord().field(key, value, iType);
        if (graph != null) {
            this.save();
        }
    }

    @Override
    public <T> T removeProperty(String key) {
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        OrientBaseGraph graph = this.getGraph();
        if (graph != null) {
            graph.autoStartTransaction();
        }
        Object oldValue = this.getRecord().removeField(key);
        if (graph != null) {
            this.save();
        }
        return (T)oldValue;
    }

    @Override
    public <T> T getProperty(String key) {
        if (key == null) {
            return null;
        }
        OrientBaseGraph graph = this.getGraph();
        if (key.equals("_class")) {
            return (T)ODocumentInternal.getImmutableSchemaClass(this.getRecord()).getName();
        }
        if (key.equals("_version")) {
            return (T)new Integer(this.getRecord().getVersion());
        }
        if (key.equals("_rid")) {
            return (T)this.rawElement.getIdentity().toString();
        }
        Object fieldValue = this.getRecord().field(key);
        if (graph != null && fieldValue instanceof OIdentifiable && !(((OIdentifiable)fieldValue).getRecord() instanceof ORecordBytes)) {
            return (T)graph.getElement(fieldValue);
        }
        if (OMultiValue.isMultiValue(fieldValue) && OMultiValue.getFirstValue(fieldValue) instanceof OIdentifiable) {
            ODocument document;
            OIdentifiable firstValue = (OIdentifiable)OMultiValue.getFirstValue(fieldValue);
            if (firstValue instanceof ODocument && ((document = (ODocument)firstValue).isEmbedded() || ODocumentInternal.getImmutableSchemaClass(document) == null)) {
                return (T)fieldValue;
            }
            if (graph != null) {
                return (T)new OrientElementIterable(graph, OMultiValue.getMultiValueIterable(fieldValue));
            }
        }
        return (T)fieldValue;
    }

    @Override
    public Object getId() {
        return this.getIdentity();
    }

    public void save() {
        this.save(null);
    }

    public void save(String iClusterName) {
        this.checkIfAttached();
        OrientBaseGraph graph = this.getGraph();
        graph.setCurrentGraphInThreadLocal();
        if (this.rawElement instanceof ODocument) {
            this.rawElement = iClusterName != null ? ((ODocument)this.rawElement).save(iClusterName) : ((ODocument)this.rawElement).save();
        }
    }

    public int hashCode() {
        return this.rawElement == null ? 0 : this.rawElement.hashCode();
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.rawElement.getIdentity().toString().getBytes();
    }

    @Override
    public OSerializableStream fromStream(byte[] stream) throws OSerializationException {
        ODocument record = this.getRecord();
        ((ORecordId)record.getIdentity()).fromString(new String(stream));
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rawElement != null ? this.rawElement.getIdentity() : null);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rawElement = (OIdentifiable)in.readObject();
    }

    @Override
    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().lockRecord(this, iExclusive ? OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.SHARED_LOCK);
    }

    @Override
    public boolean isLocked() {
        return ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().isLockedRecord(this);
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().lockingStrategy(this);
    }

    @Override
    public void unlock() {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().unlockRecord(this);
    }

    @Override
    public ORID getIdentity() {
        if (this.rawElement == null) {
            return ORecordId.EMPTY_RECORD_ID;
        }
        ORID rid = this.rawElement.getIdentity();
        OrientBaseGraph graph = this.getGraph();
        if (!rid.isValid() && graph != null) {
            graph.setCurrentGraphInThreadLocal();
            graph.autoStartTransaction();
            this.save();
        }
        return rid;
    }

    public ODocument getRecord() {
        if (this.rawElement == null) {
            return null;
        }
        if (this.rawElement instanceof ODocument) {
            return (ODocument)this.rawElement;
        }
        ODocument doc = (ODocument)this.rawElement.getRecord();
        if (doc == null) {
            return null;
        }
        this.rawElement = doc;
        return doc;
    }

    public OrientElement detach() {
        this.getRecord().setLazyLoad(false);
        this.getRecord().fieldNames();
        if (this.graph != null) {
            this.settings = this.graph.settings.copy();
            this.graph = null;
        }
        this.classicDetachMode = true;
        return this;
    }

    public void switchToAutoAttachmentMode() {
        this.graph = null;
        this.classicDetachMode = false;
    }

    public void switchToManualAttachmentMode(OrientBaseGraph iNewGraph) {
        this.attach(iNewGraph);
    }

    public OrientElement attach(OrientBaseGraph iNewGraph) {
        if (iNewGraph == null) {
            throw new IllegalArgumentException("Graph is null");
        }
        this.classicDetachMode = true;
        this.graph = iNewGraph;
        this.settings = this.graph.settings;
        return this;
    }

    public boolean isDetached() {
        return this.getGraph() == null;
    }

    @Override
    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    @Override
    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo(iSecond);
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        ORID myRID = this.getIdentity();
        ORID otherRID = iOther.getIdentity();
        if (myRID == null && otherRID == null) {
            return 0;
        }
        if (myRID == null) {
            return -1;
        }
        if (otherRID == null) {
            return 1;
        }
        return myRID.compareTo(otherRID);
    }

    public OrientBaseGraph getGraph() {
        if (this.classicDetachMode) {
            return this.graph;
        }
        return OrientBaseGraph.getActiveGraph();
    }

    public final void validateProperty(Element element, String key, Object value) throws IllegalArgumentException {
        if (this.settings.isStandardElementConstraints() && null == value) {
            throw ExceptionFactory.propertyValueCanNotBeNull();
        }
        if (null == key) {
            throw ExceptionFactory.propertyKeyCanNotBeNull();
        }
        if (this.settings.isStandardElementConstraints() && key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        if (element instanceof Edge && key.equals(LABEL_FIELD_NAME)) {
            throw ExceptionFactory.propertyKeyLabelIsReservedForEdges();
        }
        if (key.isEmpty()) {
            throw ExceptionFactory.propertyKeyCanNotBeEmpty();
        }
    }

    public void reload() {
        ODocument rec = this.getRecord();
        if (rec != null) {
            rec.reload(null, true);
        }
    }

    protected void copyTo(OrientElement iCopy) {
        iCopy.graph = this.graph;
        iCopy.settings = this.settings;
        if (this.rawElement instanceof ODocument) {
            iCopy.rawElement = new ODocument().fromStream(((ODocument)this.rawElement).toStream());
        } else if (this.rawElement instanceof ORID) {
            iCopy.rawElement = ((ORID)this.rawElement).copy();
        } else {
            throw new IllegalArgumentException("Cannot clone element " + this.rawElement);
        }
    }

    protected void checkClass() {
        ODocument doc = this.getRecord();
        doc.deserializeFields(new String[0]);
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(doc);
        if (cls == null || !cls.isSubClassOf(this.getBaseClassName())) {
            throw new IllegalArgumentException("The document received is not a " + this.getElementType() + ". Found class '" + cls + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkForClassInSchema(final String className) {
        if (className == null) {
            return null;
        }
        OrientBaseGraph graph = this.getGraph();
        if (graph == null) {
            return className;
        }
        final OSchemaProxy schema = graph.getRawGraph().getMetadata().getSchema();
        if (!schema.existsClass(className)) {
            try {
                graph.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

                    @Override
                    public OClass call(OrientBaseGraph g) {
                        return schema.createClass(className, schema.getClass(OrientElement.this.getBaseClassName()));
                    }
                }, "Committing the active transaction to create the new type '", className, "' as subclass of '", this.getBaseClassName(), "'. The transaction will be reopen right after that. To avoid this behavior create the classes outside the transaction");
                return className;
            }
            catch (OSchemaException e) {
                if (schema.existsClass(className)) return className;
                throw e;
            }
        } else {
            OClass cls = schema.getClass(className);
            if (cls.isSubClassOf(this.getBaseClassName())) return className;
            throw new IllegalArgumentException("Class '" + className + "' is not an instance of " + this.getBaseClassName());
        }
    }

    protected void setPropertyInternal(Element element, ODocument doc, String key, Object value) {
        this.validateProperty(element, key, value);
        doc.field(key, value);
    }

    protected OrientBaseGraph setCurrentGraphInThreadLocal() {
        OrientBaseGraph graph = this.getGraph();
        if (graph != null) {
            graph.setCurrentGraphInThreadLocal();
        }
        return graph;
    }

    protected OrientBaseGraph checkIfAttached() {
        OrientBaseGraph graph = this.getGraph();
        if (graph == null) {
            throw new IllegalStateException("There is no active graph instance for current element. Please either open connection to your storage, or use detach/attach methods instead.");
        }
        return graph;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T extends OrientElement> T setPropertiesInternal(Object ... fields) {
        OrientBaseGraph graph = this.getGraph();
        if (fields == null || fields.length <= 0 || fields[0] == null) return (T)this;
        if (graph != null) {
            graph.autoStartTransaction();
        }
        if (fields.length == 1) {
            Object f = fields[0];
            if (f instanceof Map) {
                for (Map.Entry entry : ((Map)f).entrySet()) {
                    this.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), entry.getKey().toString(), entry.getValue());
                }
                return (T)this;
            } else {
                if (!(f instanceof Collection)) throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + f);
                for (Object o : (Collection)f) {
                    if (!(o instanceof OPair)) {
                        throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object, but found the item: " + o);
                    }
                    OPair entry = (OPair)o;
                    this.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), entry.getKey().toString(), entry.getValue());
                }
            }
            return (T)this;
        } else {
            if (fields.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + Arrays.toString(fields));
            }
            for (int i = 0; i < fields.length; i += 2) {
                this.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), fields[i].toString(), fields[i + 1]);
            }
        }
        return (T)this;
    }
}

