/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBinaryTypeSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ODecimalSerializer
implements OBinarySerializer<BigDecimal> {
    public static final ODecimalSerializer INSTANCE = new ODecimalSerializer();
    public static final byte ID = 18;

    @Override
    public int getObjectSize(BigDecimal object, Object ... hints) {
        return 4 + OBinaryTypeSerializer.INSTANCE.getObjectSize(object.unscaledValue().toByteArray(), new Object[0]);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSize(stream, startPosition + 4);
        return size;
    }

    @Override
    public void serialize(BigDecimal object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeLiteral(object.scale(), stream, startPosition);
        OBinaryTypeSerializer.INSTANCE.serialize(object.unscaledValue().toByteArray(), stream, startPosition += 4, new Object[0]);
    }

    @Override
    public BigDecimal deserialize(byte[] stream, int startPosition) {
        int scale = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserialize(stream, startPosition += 4);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public byte getId() {
        return 18;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSizeNative(stream, startPosition + 4);
        return size;
    }

    @Override
    public void serializeNativeObject(BigDecimal object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeNative(object.scale(), stream, startPosition, new Object[0]);
        OBinaryTypeSerializer.INSTANCE.serializeNativeObject(object.unscaledValue().toByteArray(), stream, startPosition += 4, new Object[0]);
    }

    @Override
    public BigDecimal deserializeNativeObject(byte[] stream, int startPosition) {
        int scale = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserializeNativeObject(stream, startPosition += 4);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public void serializeInDirectMemoryObject(BigDecimal object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(object.scale(), pointer, offset, new Object[0]);
        OBinaryTypeSerializer.INSTANCE.serializeInDirectMemoryObject(object.unscaledValue().toByteArray(), pointer, offset += 4L, new Object[0]);
    }

    @Override
    public BigDecimal deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        int scale = pointer.getInt(offset);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserializeFromDirectMemoryObject(pointer, offset += 4L);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public BigDecimal deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        int scale = wrapper.getInt(offset);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserializeFromDirectMemoryObject(wrapper, offset += 4L);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSizeInDirectMemory(pointer, offset + 4L);
        return size;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSizeInDirectMemory(wrapper, offset + 4L);
        return size;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public BigDecimal preprocess(BigDecimal value, Object ... hints) {
        return value;
    }
}

