/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.nio.ByteOrder;

public class OFloatSerializer
implements OBinarySerializer<Float> {
    public static final byte ID = 7;
    public static final int FLOAT_SIZE = 4;
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static OFloatSerializer INSTANCE = new OFloatSerializer();

    @Override
    public int getObjectSize(Float object, Object ... hints) {
        return 4;
    }

    @Override
    public void serialize(Float object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeLiteral(Float.floatToIntBits(object.floatValue()), stream, startPosition);
    }

    @Override
    public Float deserialize(byte[] stream, int startPosition) {
        return Float.valueOf(Float.intBitsToFloat(OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition)));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public void serializeNativeObject(Float object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putInt(stream, startPosition, Float.floatToIntBits(object.floatValue()), ByteOrder.nativeOrder());
    }

    @Override
    public Float deserializeNativeObject(byte[] stream, int startPosition) {
        return Float.valueOf(Float.intBitsToFloat(CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder())));
    }

    @Override
    public void serializeInDirectMemoryObject(Float object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setInt(offset, Float.floatToIntBits(object.floatValue()));
    }

    @Override
    public Float deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        return Float.valueOf(Float.intBitsToFloat(pointer.getInt(offset)));
    }

    @Override
    public Float deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return Float.valueOf(Float.intBitsToFloat(wrapper.getInt(offset)));
    }

    public void serializeNative(float object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putInt(stream, startPosition, Float.floatToIntBits(object), ByteOrder.nativeOrder());
    }

    public float deserializeNative(byte[] stream, int startPosition) {
        return Float.intBitsToFloat(CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder()));
    }

    public void serializeInDirectMemory(float object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setInt(offset, Float.floatToIntBits(object));
    }

    public float deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return Float.intBitsToFloat(pointer.getInt(offset));
    }

    public float deserializeFromDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return Float.intBitsToFloat(wrapper.getInt(offset));
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 4;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 4;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 4;
    }

    @Override
    public Float preprocess(Float value, Object ... hints) {
        return value;
    }
}

