/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OPair<K extends Comparable<K>, V>
implements Map.Entry<K, V>,
Comparable<OPair<K, V>>,
Serializable {
    public K key;
    public V value;

    public OPair() {
    }

    public OPair(K iKey, V iValue) {
        this.key = iKey;
        this.value = iValue;
    }

    public OPair(Map.Entry<K, V> iSource) {
        this.key = (Comparable)iSource.getKey();
        this.value = iSource.getValue();
    }

    public void init(K iKey, V iValue) {
        this.key = iKey;
        this.value = iValue;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V iValue) {
        V oldValue = this.value;
        this.value = iValue;
        return oldValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(this.key);
        buffer.append(':');
        if (this.value == null || !this.value.getClass().isArray()) {
            buffer.append(this.value);
        } else {
            buffer.append(Arrays.toString((Object[])this.value));
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPair other = (OPair)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    @Override
    public int compareTo(OPair<K, V> o) {
        return this.key.compareTo(o.key);
    }

    public static <K extends Comparable<K>, V> Map<K, V> convertToMap(List<OPair<K, V>> iValues) {
        HashMap<Object, V> result = new HashMap<Object, V>(iValues.size());
        for (OPair<K, V> p : iValues) {
            result.put(p.getKey(), p.getValue());
        }
        return result;
    }

    public static <K extends Comparable<K>, V> List<OPair<K, V>> convertFromMap(Map<K, V> iValues) {
        ArrayList<OPair<K, V>> result = new ArrayList<OPair<K, V>>(iValues.size());
        for (Map.Entry<K, V> p : iValues.entrySet()) {
            result.add(new OPair<Comparable, V>((Comparable)p.getKey(), p.getValue()));
        }
        return result;
    }
}

