/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OImmutableRecordId;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class OStorageConfiguration
implements OSerializableStream {
    public static final ORecordId CONFIG_RID = new OImmutableRecordId(0, 0L);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String charset = "UTF-8";
    public static final int CURRENT_VERSION = 14;
    public static final int CURRENT_BINARY_FORMAT_VERSION = 12;
    private final List<OStorageEntryConfiguration> properties = Collections.synchronizedList(new ArrayList());
    protected final transient OStorage storage;
    private final OContextConfiguration configuration = new OContextConfiguration();
    public volatile int version = -1;
    public volatile String name;
    public volatile String schemaRecordId;
    public volatile String dictionaryRecordId;
    public volatile String indexMgrRecordId;
    public volatile String dateFormat = "yyyy-MM-dd";
    public volatile String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    public volatile int binaryFormatVersion;
    public volatile OStorageSegmentConfiguration fileTemplate;
    public volatile List<OStorageClusterConfiguration> clusters = Collections.synchronizedList(new ArrayList());
    private volatile String localeLanguage = Locale.getDefault().getLanguage();
    private volatile String localeCountry = Locale.getDefault().getCountry();
    private volatile TimeZone timeZone = TimeZone.getDefault();
    private volatile transient Locale localeInstance;
    private volatile transient DecimalFormatSymbols unusualSymbols;
    private volatile String clusterSelection;
    private volatile String conflictStrategy;
    private volatile int minimumClusters = 1;
    private volatile String recordSerializer;
    private volatile int recordSerializerVersion;
    private volatile boolean strictSQL;

    public OStorageConfiguration(OStorage iStorage) {
        this.storage = iStorage;
        this.fileTemplate = new OStorageSegmentConfiguration();
        this.binaryFormatVersion = 12;
    }

    public String getConflictStrategy() {
        return this.conflictStrategy;
    }

    public void setConflictStrategy(String conflictStrategy) {
        this.conflictStrategy = conflictStrategy;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.configuration;
    }

    public OStorageConfiguration load() throws OSerializationException {
        byte[] record = this.storage.readRecord((ORecordId)OStorageConfiguration.CONFIG_RID, null, (boolean)false, null).getResult().buffer;
        if (record == null) {
            throw new OStorageException("Cannot load database's configuration. The database seems to be corrupted.");
        }
        this.fromStream(record);
        return this;
    }

    public void update() throws OSerializationException {
        byte[] record = this.toStream();
        this.storage.updateRecord(CONFIG_RID, true, record, OVersionFactory.instance().createUntrackedVersion(), (byte)98, 0, null);
    }

    public boolean isEmpty() {
        return this.clusters.isEmpty();
    }

    public String getDirectory() {
        return this.fileTemplate.location != null ? this.fileTemplate.getLocation() : ((OLocalPaginatedStorage)this.storage).getStoragePath();
    }

    public Locale getLocaleInstance() {
        if (this.localeInstance == null) {
            this.localeInstance = new Locale(this.localeLanguage, this.localeCountry);
        }
        return this.localeInstance;
    }

    public void resetLocaleInstance() {
        this.localeInstance = null;
    }

    public SimpleDateFormat getDateFormatInstance() {
        SimpleDateFormat dateFormatInstance = new SimpleDateFormat(this.dateFormat);
        dateFormatInstance.setLenient(false);
        dateFormatInstance.setTimeZone(this.timeZone);
        return dateFormatInstance;
    }

    public SimpleDateFormat getDateTimeFormatInstance() {
        SimpleDateFormat dateTimeFormatInstance = new SimpleDateFormat(this.dateTimeFormat);
        dateTimeFormatInstance.setLenient(false);
        dateTimeFormatInstance.setTimeZone(this.timeZone);
        return dateTimeFormatInstance;
    }

    public DecimalFormatSymbols getUnusualSymbols() {
        if (this.unusualSymbols == null) {
            this.unusualSymbols = new DecimalFormatSymbols(this.getLocaleInstance());
        }
        return this.unusualSymbols;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int i;
        String[] values = new String(iStream).split("\\|");
        int index = 0;
        this.version = Integer.parseInt(this.read(values[index++]));
        this.name = this.read(values[index++]);
        this.schemaRecordId = this.read(values[index++]);
        this.dictionaryRecordId = this.read(values[index++]);
        this.indexMgrRecordId = this.version > 0 ? this.read(values[index++]) : null;
        this.localeLanguage = this.read(values[index++]);
        this.localeCountry = this.read(values[index++]);
        this.dateFormat = this.read(values[index++]);
        this.dateTimeFormat = this.read(values[index++]);
        if (this.version >= 4) {
            this.timeZone = TimeZone.getTimeZone(this.read(values[index++]));
            this.charset = this.read(values[index++]);
        }
        ORecordConflictStrategyFactory conflictStrategyFactory = Orient.instance().getRecordConflictStrategy();
        this.conflictStrategy = this.version >= 12 ? conflictStrategyFactory.getStrategy(this.read(values[index++])).getName() : conflictStrategyFactory.getDefaultStrategy();
        if (this.version > 1) {
            index = this.phySegmentFromStream(values, index, this.fileTemplate);
        }
        int size = Integer.parseInt(this.read(values[index++]));
        this.clusters.clear();
        String determineStorageCompression = null;
        for (i = 0; i < size; ++i) {
            OStorageClusterConfiguration.STATUS status;
            String clusterConflictStrategy;
            String clusterCompression;
            float aa;
            float bb;
            boolean cc;
            String clusterType;
            int clusterId;
            if ((clusterId = Integer.parseInt(this.read(values[index++]))) == -1) continue;
            String clusterName = this.read(values[index++]);
            int targetDataSegmentId = this.version >= 3 ? Integer.parseInt(this.read(values[index++])) : 0;
            if ((clusterType = this.read(values[index++])).equals("d")) {
                cc = Boolean.valueOf(this.read(values[index++]));
                bb = Float.valueOf(this.read(values[index++])).floatValue();
                aa = Float.valueOf(this.read(values[index++])).floatValue();
                clusterCompression = this.read(values[index++]);
                if (determineStorageCompression == null) {
                    determineStorageCompression = clusterCompression;
                }
                clusterConflictStrategy = this.version >= 12 ? this.read(values[index++]) : null;
                status = OStorageClusterConfiguration.STATUS.ONLINE;
                if (this.version >= 13) {
                    status = OStorageClusterConfiguration.STATUS.valueOf(this.read(values[index++]));
                }
            } else {
                if (clusterType.equals("p")) {
                    throw new IllegalArgumentException("Cluster of storage 'local' are not supported since 2.0");
                }
                throw new IllegalArgumentException("Unsupported cluster type: " + clusterType);
            }
            OStoragePaginatedClusterConfiguration currentCluster = new OStoragePaginatedClusterConfiguration(this, clusterId, clusterName, null, cc, bb, aa, clusterCompression, clusterConflictStrategy, status);
            for (int c = this.clusters.size(); c <= clusterId; ++c) {
                this.clusters.add(null);
            }
            this.clusters.set(clusterId, currentCluster);
        }
        if (this.version < 13) {
            size = Integer.parseInt(this.read(values[index++]));
            for (i = 0; i < size; ++i) {
                int dataId;
                if ((dataId = Integer.parseInt(this.read(values[index++]))) == -1) continue;
                this.read(values[index++]);
                this.read(values[index++]);
                this.read(values[index++]);
                this.read(values[index++]);
            }
            this.read(values[index++]);
            this.read(values[index++]);
            this.read(values[index++]);
            this.read(values[index++]);
            this.read(values[index++]);
        }
        size = Integer.parseInt(this.read(values[index++]));
        this.clearProperties();
        for (i = 0; i < size; ++i) {
            this.setProperty(this.read(values[index++]), this.read(values[index++]));
        }
        this.binaryFormatVersion = this.version >= 7 ? Integer.parseInt(this.read(values[index++])) : (this.version == 6 ? 9 : 8);
        this.clusterSelection = this.version >= 8 ? this.read(values[index++]) : "round-robin";
        this.minimumClusters = this.version >= 9 ? Integer.parseInt(this.read(values[index++])) : 1;
        if (this.version >= 10) {
            this.recordSerializer = this.read(values[index++]);
            this.recordSerializerVersion = Integer.parseInt(this.read(values[index++]));
        }
        if (this.version >= 11) {
            int cfgSize = Integer.parseInt(this.read(values[index++]));
            for (int i2 = 0; i2 < cfgSize; ++i2) {
                String key = this.read(values[index++]);
                String value = this.read(values[index++]);
                OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(key);
                if (cfg != null) {
                    this.configuration.setValue(key, OType.convert(value, cfg.getType()));
                    continue;
                }
                OLogManager.instance().warn((Object)this, "Ignored storage configuration because not supported: %s=%s.", key, value);
            }
        } else {
            this.configuration.setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, determineStorageCompression);
        }
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.toStream(Integer.MAX_VALUE);
    }

    public byte[] toStream(int version) throws OSerializationException {
        StringBuilder buffer = new StringBuilder(8192);
        this.write(buffer, 14);
        this.write(buffer, this.name);
        this.write(buffer, this.schemaRecordId);
        this.write(buffer, this.dictionaryRecordId);
        this.write(buffer, this.indexMgrRecordId);
        this.write(buffer, this.localeLanguage);
        this.write(buffer, this.localeCountry);
        this.write(buffer, this.dateFormat);
        this.write(buffer, this.dateTimeFormat);
        this.write(buffer, this.timeZone.getID());
        this.write(buffer, this.charset);
        if (version > 24) {
            this.write(buffer, this.conflictStrategy);
        }
        this.phySegmentToStream(buffer, this.fileTemplate);
        this.write(buffer, this.clusters.size());
        for (OStorageClusterConfiguration c : this.clusters) {
            if (c == null) {
                this.write(buffer, -1);
                continue;
            }
            this.write(buffer, c.getId());
            this.write(buffer, c.getName());
            this.write(buffer, c.getDataSegmentId());
            if (!(c instanceof OStoragePaginatedClusterConfiguration)) continue;
            this.write(buffer, "d");
            OStoragePaginatedClusterConfiguration paginatedClusterConfiguration = (OStoragePaginatedClusterConfiguration)c;
            this.write(buffer, paginatedClusterConfiguration.useWal);
            this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordOverflowGrowFactor));
            this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordGrowFactor));
            this.write(buffer, paginatedClusterConfiguration.compression);
            if (version > 24) {
                this.write(buffer, paginatedClusterConfiguration.conflictStrategy);
            }
            if (version <= 25) continue;
            this.write(buffer, paginatedClusterConfiguration.getStatus().name().toString());
        }
        if (version <= 25) {
            this.write(buffer, 0);
            this.write(buffer, "");
            this.write(buffer, "");
            this.write(buffer, 0);
            this.write(buffer, false);
            this.write(buffer, false);
        }
        this.write(buffer, this.properties.size());
        for (OStorageEntryConfiguration e : this.properties) {
            this.entryToStream(buffer, e);
        }
        this.write(buffer, this.binaryFormatVersion);
        this.write(buffer, this.clusterSelection);
        this.write(buffer, this.minimumClusters);
        if (version > 24) {
            this.write(buffer, this.recordSerializer);
            this.write(buffer, this.recordSerializerVersion);
            this.write(buffer, this.configuration.getContextSize());
            for (String k : this.configuration.getContextKeys()) {
                this.write(buffer, k);
                this.write(buffer, this.configuration.getValueAsString(OGlobalConfiguration.findByKey(k)));
            }
        }
        buffer.append("|");
        return buffer.toString().getBytes();
    }

    public void lock() throws IOException {
    }

    public void unlock() throws IOException {
    }

    public void create() throws IOException {
        this.storage.createRecord(CONFIG_RID, new byte[]{0, 0, 0, 0}, OVersionFactory.instance().createVersion(), (byte)98, 0, null);
    }

    public void synch() throws IOException {
    }

    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    public void close() throws IOException {
    }

    public void setCluster(OStorageClusterConfiguration config) {
        while (config.getId() >= this.clusters.size()) {
            this.clusters.add(null);
        }
        this.clusters.set(config.getId(), config);
    }

    public void dropCluster(int iClusterId) {
        if (iClusterId < this.clusters.size()) {
            this.clusters.set(iClusterId, null);
            this.update();
        }
    }

    public void setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS iStatus) {
        OStorageClusterConfiguration clusterCfg = this.clusters.get(clusterId);
        if (clusterCfg != null) {
            clusterCfg.setStatus(iStatus);
        }
        this.update();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public void setLocaleLanguage(String iValue) {
        this.localeLanguage = iValue;
        this.localeInstance = null;
    }

    public String getLocaleCountry() {
        return this.localeCountry;
    }

    public void setLocaleCountry(String iValue) {
        this.localeCountry = iValue;
        this.localeInstance = null;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getClusterSelection() {
        return this.clusterSelection;
    }

    public void setClusterSelection(String clusterSelection) {
        this.clusterSelection = clusterSelection;
    }

    public int getMinimumClusters() {
        return this.minimumClusters;
    }

    public void setMinimumClusters(int minimumClusters) {
        this.minimumClusters = minimumClusters;
    }

    public String getRecordSerializer() {
        return this.recordSerializer;
    }

    public void setRecordSerializer(String recordSerializer) {
        this.recordSerializer = recordSerializer;
    }

    public int getRecordSerializerVersion() {
        return this.recordSerializerVersion;
    }

    public void setRecordSerializerVersion(int recordSerializerVersion) {
        this.recordSerializerVersion = recordSerializerVersion;
    }

    public boolean isStrictSql() {
        return this.strictSQL;
    }

    public List<OStorageEntryConfiguration> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperty(String iName, String iValue) {
        if ("strictSql".equalsIgnoreCase(iName)) {
            this.strictSQL = "true".equalsIgnoreCase("" + iValue);
        }
        for (OStorageEntryConfiguration e : this.properties) {
            if (!e.name.equalsIgnoreCase(iName)) continue;
            e.value = iValue;
            return;
        }
        this.properties.add(new OStorageEntryConfiguration(iName, iValue));
    }

    public String getProperty(String iName) {
        for (OStorageEntryConfiguration e : this.properties) {
            if (!e.name.equalsIgnoreCase(iName)) continue;
            return e.value;
        }
        return null;
    }

    public boolean existsProperty(String iName) {
        for (OStorageEntryConfiguration e : this.properties) {
            if (!e.name.equalsIgnoreCase(iName)) continue;
            return true;
        }
        return false;
    }

    public void removeProperty(String iName) {
        Iterator<OStorageEntryConfiguration> it = this.properties.iterator();
        while (it.hasNext()) {
            OStorageEntryConfiguration e = it.next();
            if (!e.name.equalsIgnoreCase(iName)) continue;
            it.remove();
            break;
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    private int phySegmentFromStream(String[] values, int index, OStorageSegmentConfiguration iSegment) {
        iSegment.location = this.version > 2 ? this.read(values[index++]) : null;
        iSegment.maxSize = this.read(values[index++]);
        iSegment.fileType = this.read(values[index++]);
        iSegment.fileStartSize = this.read(values[index++]);
        iSegment.fileMaxSize = this.read(values[index++]);
        iSegment.fileIncrementSize = this.read(values[index++]);
        iSegment.defrag = this.read(values[index++]);
        int size = Integer.parseInt(this.read(values[index++]));
        iSegment.infoFiles = new OStorageFileConfiguration[size];
        for (int i = 0; i < size; ++i) {
            int pos;
            String fileName;
            if (!(fileName = this.read(values[index++])).contains("$") && (pos = fileName.indexOf("/databases")) > -1) {
                fileName = "${ORIENTDB_HOME}" + fileName.substring(pos);
            }
            iSegment.infoFiles[i] = new OStorageFileConfiguration(iSegment, fileName, this.read(values[index++]), this.read(values[index++]), iSegment.fileIncrementSize);
        }
        return index;
    }

    private void phySegmentToStream(StringBuilder iBuffer, OStorageSegmentConfiguration iSegment) {
        this.write(iBuffer, iSegment.location);
        this.write(iBuffer, iSegment.maxSize);
        this.write(iBuffer, iSegment.fileType);
        this.write(iBuffer, iSegment.fileStartSize);
        this.write(iBuffer, iSegment.fileMaxSize);
        this.write(iBuffer, iSegment.fileIncrementSize);
        this.write(iBuffer, iSegment.defrag);
        this.write(iBuffer, iSegment.infoFiles.length);
        for (OStorageFileConfiguration f : iSegment.infoFiles) {
            this.fileToStream(iBuffer, f);
        }
    }

    private void fileToStream(StringBuilder iBuffer, OStorageFileConfiguration iFile) {
        this.write(iBuffer, iFile.path);
        this.write(iBuffer, iFile.type);
        this.write(iBuffer, iFile.maxSize);
    }

    private void entryToStream(StringBuilder iBuffer, OStorageEntryConfiguration iEntry) {
        this.write(iBuffer, iEntry.name);
        this.write(iBuffer, iEntry.value);
    }

    private String read(String iValue) {
        if (iValue.equals(" ")) {
            return null;
        }
        return iValue;
    }

    private void write(StringBuilder iBuffer, Object iValue) {
        if (iBuffer.length() > 0) {
            iBuffer.append('|');
        }
        iBuffer.append(iValue != null ? iValue.toString() : Character.valueOf(' '));
    }
}

