/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.util.OBackupable;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface ODatabase<T>
extends OBackupable,
Closeable,
OUserObject2RecordHandler {
    public <DB extends ODatabase> DB open(String var1, String var2);

    public <DB extends ODatabase> DB create();

    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> var1);

    public ODatabase activateOnCurrentThread();

    public boolean isActiveOnCurrentThread();

    public void reload();

    public void drop();

    public OContextConfiguration getConfiguration();

    public boolean declareIntent(OIntent var1);

    public boolean exists();

    @Override
    public void close();

    public STATUS getStatus();

    public <DB extends ODatabase> DB setStatus(STATUS var1);

    public long getSize();

    public String getName();

    public String getURL();

    public OLocalRecordCache getLocalCache();

    public int getDefaultClusterId();

    public int getClusters();

    public boolean existsCluster(String var1);

    public Collection<String> getClusterNames();

    public int getClusterIdByName(String var1);

    public String getClusterNameById(int var1);

    public long getClusterRecordSizeByName(String var1);

    public long getClusterRecordSizeById(int var1);

    public boolean isClosed();

    public long countClusterElements(int var1);

    public long countClusterElements(int var1, boolean var2);

    public long countClusterElements(int[] var1);

    public long countClusterElements(int[] var1, boolean var2);

    public long countClusterElements(String var1);

    public int addCluster(String var1, Object ... var2);

    public int addCluster(String var1, int var2, Object ... var3);

    public boolean dropCluster(String var1, boolean var2);

    public boolean dropCluster(int var1, boolean var2);

    public Object setProperty(String var1, Object var2);

    public Object getProperty(String var1);

    public Iterator<Map.Entry<String, Object>> getProperties();

    public Object get(ATTRIBUTES var1);

    public <DB extends ODatabase> DB set(ATTRIBUTES var1, Object var2);

    public void registerListener(ODatabaseListener var1);

    public void unregisterListener(ODatabaseListener var1);

    public ORecordMetadata getRecordMetadata(ORID var1);

    public void freeze();

    public void release();

    public void freeze(boolean var1);

    public void freezeCluster(int var1);

    public void releaseCluster(int var1);

    public void freezeCluster(int var1, boolean var2);

    public <RET> RET newInstance();

    public ODictionary<T> getDictionary();

    public OSecurityUser getUser();

    public void setUser(OSecurityUser var1);

    public <RET extends T> RET load(T var1);

    public <RET extends T> RET load(T var1, String var2);

    @Deprecated
    public <RET extends T> RET load(T var1, String var2, boolean var3, boolean var4, OStorage.LOCKING_STRATEGY var5);

    @Deprecated
    public <RET extends T> RET load(T var1, String var2, boolean var3, boolean var4, boolean var5, OStorage.LOCKING_STRATEGY var6);

    public <RET extends T> RET load(T var1, String var2, boolean var3);

    public <RET extends T> RET reload(T var1, String var2, boolean var3);

    public <RET extends T> RET reload(T var1, String var2, boolean var3, boolean var4);

    public <RET extends T> RET load(ORID var1);

    public <RET extends T> RET load(ORID var1, String var2);

    public <RET extends T> RET load(ORID var1, String var2, boolean var3);

    @Deprecated
    public <RET extends T> RET load(ORID var1, String var2, boolean var3, boolean var4, OStorage.LOCKING_STRATEGY var5);

    @Deprecated
    public <RET extends T> RET load(ORID var1, String var2, boolean var3, boolean var4, boolean var5, OStorage.LOCKING_STRATEGY var6);

    public <RET extends T> RET save(T var1);

    public <RET extends T> RET save(T var1, OPERATION_MODE var2, boolean var3, ORecordCallback<? extends Number> var4, ORecordCallback<ORecordVersion> var5);

    public <RET extends T> RET save(T var1, String var2);

    public <RET extends T> RET save(T var1, String var2, OPERATION_MODE var3, boolean var4, ORecordCallback<? extends Number> var5, ORecordCallback<ORecordVersion> var6);

    public ODatabase<T> delete(T var1);

    public ODatabase<T> delete(ORID var1);

    public ODatabase<T> delete(ORID var1, ORecordVersion var2);

    public boolean hide(ORID var1);

    public ODatabase<T> cleanOutRecord(ORID var1, ORecordVersion var2);

    public OTransaction getTransaction();

    public ODatabase<T> begin();

    public ODatabase<T> begin(OTransaction.TXTYPE var1);

    public ODatabase<T> begin(OTransaction var1) throws OTransactionException;

    public ODatabase<T> commit() throws OTransactionException;

    public ODatabase<T> commit(boolean var1) throws OTransactionException;

    public ODatabase<T> rollback() throws OTransactionException;

    public ODatabase<T> rollback(boolean var1) throws OTransactionException;

    public <RET extends List<?>> RET query(OQuery<?> var1, Object ... var2);

    public <RET extends OCommandRequest> RET command(OCommandRequest var1);

    public OMetadata getMetadata();

    public <DB extends ODatabase<?>> DB registerHook(ORecordHook var1);

    public <DB extends ODatabase<?>> DB registerHook(ORecordHook var1, ORecordHook.HOOK_POSITION var2);

    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks();

    public <DB extends ODatabase<?>> DB unregisterHook(ORecordHook var1);

    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE var1, OIdentifiable var2);

    public boolean isMVCC();

    public Iterable<ODatabaseListener> getListeners();

    public <DB extends ODatabase<?>> DB setMVCC(boolean var1);

    public String getType();

    public ORecordConflictStrategy getConflictStrategy();

    public <DB extends ODatabase<?>> DB setConflictStrategy(String var1);

    public <DB extends ODatabase<?>> DB setConflictStrategy(ORecordConflictStrategy var1);

    public static enum OPERATION_MODE {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        ASYNCHRONOUS_NOANSWER;

    }

    public static enum ATTRIBUTES {
        TYPE,
        STATUS,
        DEFAULTCLUSTERID,
        DATEFORMAT,
        DATETIMEFORMAT,
        TIMEZONE,
        LOCALECOUNTRY,
        LOCALELANGUAGE,
        CHARSET,
        CUSTOM,
        CLUSTERSELECTION,
        MINIMUMCLUSTERS,
        CONFLICTSTRATEGY,
        VALIDATION;

    }

    public static enum STATUS {
        OPEN,
        CLOSED,
        IMPORTING;

    }

    public static enum OPTIONS {
        SECURITY;

    }
}

